/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.UserPropertyProcNode;
import org.apache.doris.mysql.privilege.PaloAuth;

public class AuthProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"UserIdentity").add((Object)"Password").add((Object)"GlobalPrivs").add((Object)"DatabasePrivs").add((Object)"TablePrivs").add((Object)"ResourcePrivs").build();
    private PaloAuth auth;

    public AuthProcDir(PaloAuth auth) {
        this.auth = auth;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String userIdent) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)userIdent)) {
            throw new AnalysisException("User is not specified");
        }
        UserIdentity userIdentity = UserIdentity.fromString(userIdent);
        if (userIdentity == null) {
            throw new AnalysisException("Invalid user ident: " + userIdent);
        }
        return new UserPropertyProcNode(this.auth, userIdentity.getQualifiedUser());
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        result.setRows(Catalog.getCurrentCatalog().getAuth().getAuthInfo(null));
        return result;
    }
}

