/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.path;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class PathTrie<T> {
    private static final char PATH_SEPARATOR = '/';
    private static final char LEFT_BRACE = '{';
    private static final char RIGHT_BRACE = '}';
    private static final String ASTERISK_WILDCARD = "*";
    public static final Decoder NO_DECODER = new Decoder(){

        @Override
        public String decode(String value) {
            return value;
        }
    };
    private final Decoder decoder;
    private final TrieNode<T> root;
    private final char separator;
    private T rootValue;

    public PathTrie() {
        this('/', ASTERISK_WILDCARD, NO_DECODER);
    }

    public PathTrie(Decoder decoder) {
        this('/', ASTERISK_WILDCARD, decoder);
    }

    public PathTrie(char separator, String wildcard, Decoder decoder) {
        this.decoder = decoder;
        this.separator = separator;
        this.root = new TrieNode<Object>(new String(new char[]{separator}), null, null, wildcard);
    }

    public void insert(String path, T value) {
        String[] strings = path.split(String.valueOf(this.separator));
        if (strings.length == 0) {
            this.rootValue = value;
            return;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        this.root.insert(strings, index, value);
    }

    public T retrieve(String path) {
        return this.retrieve(path, null);
    }

    public T retrieve(String path, Map<String, String> params) {
        if (path.length() == 0) {
            return this.rootValue;
        }
        String[] strings = path.split(String.valueOf(this.separator));
        if (strings.length == 0) {
            return this.rootValue;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        return this.root.retrieve(strings, index, params);
    }

    public class TrieNode<T> {
        private transient String key;
        private transient T value;
        private boolean isWildcard;
        private final String wildcard;
        private transient String namedWildcard;
        private ImmutableMap<String, TrieNode<T>> children;
        private final TrieNode<T> parent;

        public TrieNode(String key, T value, TrieNode<T> parent, String wildcard) {
            this.key = key;
            this.wildcard = wildcard;
            this.isWildcard = key.equals(wildcard);
            this.parent = parent;
            this.value = value;
            this.children = ImmutableMap.of();
            this.namedWildcard = this.isNamedWildcard(key) ? key.substring(key.indexOf(123) + 1, key.indexOf(125)) : null;
        }

        public void updateKeyWithNamedWildcard(String key) {
            this.key = key;
            this.namedWildcard = key.substring(key.indexOf(123) + 1, key.indexOf(125));
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }

        public synchronized void addChild(TrieNode<T> child) {
            HashMap temp = Maps.newHashMap(this.children);
            temp.put(child.key, child);
            this.children = ImmutableMap.copyOf((Map)temp);
        }

        public TrieNode<T> getChild(String key) {
            return (TrieNode)this.children.get((Object)key);
        }

        public synchronized void insert(String[] path, int index, T value) {
            TrieNode<Object> node;
            String token;
            if (index >= path.length) {
                return;
            }
            String key = token = path[index];
            if (this.isNamedWildcard(token)) {
                key = this.wildcard;
            }
            if ((node = (TrieNode<T>)this.children.get((Object)key)) == null) {
                node = index == path.length - 1 ? new TrieNode<T>(token, value, this, this.wildcard) : new TrieNode<Object>(token, null, this, this.wildcard);
                HashMap temp = Maps.newHashMap(this.children);
                temp.put(key, node);
                this.children = ImmutableMap.copyOf((Map)temp);
            } else {
                if (this.isNamedWildcard(token)) {
                    node.updateKeyWithNamedWildcard(token);
                }
                if (index == path.length - 1) {
                    assert (node.value == null || node.value == value);
                    if (node.value == null) {
                        node.value = value;
                    }
                }
            }
            node.insert(path, index + 1, value);
        }

        private boolean isNamedWildcard(String key) {
            return key.indexOf(123) != -1 && key.indexOf(125) != -1;
        }

        private boolean isNamedWildcard() {
            return this.namedWildcard != null;
        }

        private String namedWildcard() {
            return this.namedWildcard;
        }

        public T retrieve(String[] path, int index, Map<String, String> params) {
            boolean usedWildcard;
            if (index >= path.length) {
                return null;
            }
            String token = path[index];
            TrieNode node = (TrieNode)this.children.get((Object)token);
            if (node == null) {
                node = (TrieNode)this.children.get((Object)this.wildcard);
                if (node == null) {
                    return null;
                }
                usedWildcard = true;
            } else if (index + 1 == path.length && node.value == null && this.children.get((Object)this.wildcard) != null) {
                node = (TrieNode)this.children.get((Object)this.wildcard);
                usedWildcard = true;
            } else {
                usedWildcard = token.equals(this.wildcard);
            }
            this.put(params, node, token);
            if (index == path.length - 1) {
                return node.value;
            }
            T res = node.retrieve(path, index + 1, params);
            if (res == null && !usedWildcard && (node = (TrieNode)this.children.get((Object)this.wildcard)) != null) {
                this.put(params, node, token);
                res = node.retrieve(path, index + 1, params);
            }
            return res;
        }

        private void put(Map<String, String> params, TrieNode<T> node, String value) {
            if (params != null && super.isNamedWildcard()) {
                params.put(super.namedWildcard(), PathTrie.this.decoder.decode(value));
            }
        }
    }

    public static interface Decoder {
        public String decode(String var1);
    }
}

