/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.parquet;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.common.parquet.BrokerInputFile;
import org.apache.doris.common.parquet.LocalInputFile;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class ParquetReader {
    private ParquetFileReader fileReader;

    private ParquetReader(InputFile inputFile) throws IOException {
        ParquetReadOptions readOptions = ParquetReadOptions.builder().build();
        this.fileReader = new ParquetFileReader(inputFile, readOptions);
    }

    public static ParquetReader create(String filePath, BrokerDesc brokerDesc) throws IOException {
        BrokerInputFile inputFile = BrokerInputFile.create(filePath, brokerDesc);
        return new ParquetReader(inputFile);
    }

    public static ParquetReader create(String filePath) throws IOException {
        LocalInputFile inputFile = new LocalInputFile(new File(filePath));
        return new ParquetReader(inputFile);
    }

    public static ParquetReader create(String filePath, BrokerDesc brokerDesc, String ip, int port) throws IOException {
        BrokerInputFile inputFile = BrokerInputFile.create(filePath, brokerDesc, ip, port);
        return new ParquetReader(inputFile);
    }

    public List<String> getSchema(boolean debug) {
        ArrayList colNames = Lists.newArrayList();
        FileMetaData metaData = this.fileReader.getFileMetaData();
        MessageType messageType = metaData.getSchema();
        List columnDescriptors = messageType.getColumns();
        for (ColumnDescriptor column : columnDescriptors) {
            if (debug) {
                colNames.add(column.toString());
                continue;
            }
            String colName = column.getPath()[0];
            if (column.getMaxDefinitionLevel() > 1) {
                colName = colName + " (" + column.getMaxDefinitionLevel() + ")";
            }
            colNames.add(colName);
        }
        return colNames;
    }

    public List<List<String>> getLines(int limit) throws IOException {
        ArrayList lines = Lists.newArrayList();
        FileMetaData metaData = this.fileReader.getFileMetaData();
        MessageType schema = metaData.getSchema();
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
        int readLines = 0;
        PageReadStore pages = null;
        while (null != (pages = this.fileReader.readNextRowGroup()) && readLines < limit) {
            long rows = pages.getRowCount();
            RecordReader recordReader = columnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(schema));
            int i = 0;
            while ((long)i < rows && readLines < limit) {
                ArrayList line = Lists.newArrayList();
                Group g = (Group)recordReader.read();
                this.parseGroup(g, line);
                lines.add(line);
                ++readLines;
                ++i;
            }
        }
        return lines;
    }

    private void parseGroup(Group g, List<String> line) {
        int fieldCount = g.getType().getFieldCount();
        for (int field = 0; field < fieldCount; ++field) {
            int valueCount = g.getFieldRepetitionCount(field);
            Type fieldType = g.getType().getType(field);
            String fieldName = fieldType.getName();
            if (valueCount == 1) {
                line.add(g.getValueToString(field, 0));
                continue;
            }
            if (valueCount > 1) {
                ArrayList array = Lists.newArrayList();
                for (int index = 0; index < valueCount; ++index) {
                    if (!fieldType.isPrimitive()) continue;
                    array.add(g.getValueToString(field, index));
                }
                line.add("[" + Joiner.on((String)",").join((Iterable)array) + "]");
                continue;
            }
            line.add("");
        }
    }

    public void close() throws IOException {
        this.fileReader.close();
    }
}

