/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.parquet;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class LocalInputFile
implements InputFile {
    private static final Logger LOG = LogManager.getLogger(LocalInputFile.class);
    private static final int COPY_BUFFER_SIZE = 8192;
    private final RandomAccessFile input;

    public LocalInputFile(File file) throws FileNotFoundException {
        this.input = new RandomAccessFile(file, "r");
    }

    private static int readDirectBuffer(ByteBuffer byteBufr, byte[] tmpBuf, ByteBufReader rdr) throws IOException {
        int bytesRead;
        int nextReadLength = Math.min(byteBufr.remaining(), tmpBuf.length);
        int totalBytesRead = 0;
        while ((bytesRead = rdr.read(tmpBuf, 0, nextReadLength)) == tmpBuf.length) {
            byteBufr.put(tmpBuf);
            totalBytesRead += bytesRead;
            nextReadLength = Math.min(byteBufr.remaining(), tmpBuf.length);
        }
        if (bytesRead < 0) {
            return totalBytesRead == 0 ? -1 : totalBytesRead;
        }
        byteBufr.put(tmpBuf, 0, bytesRead);
        return totalBytesRead += bytesRead;
    }

    private static void readFullyDirectBuffer(ByteBuffer byteBufr, byte[] tmpBuf, ByteBufReader rdr) throws IOException {
        int nextReadLength = Math.min(byteBufr.remaining(), tmpBuf.length);
        int bytesRead = 0;
        while (nextReadLength > 0 && (bytesRead = rdr.read(tmpBuf, 0, nextReadLength)) >= 0) {
            byteBufr.put(tmpBuf, 0, bytesRead);
            nextReadLength = Math.min(byteBufr.remaining(), tmpBuf.length);
        }
        if (bytesRead < 0 && byteBufr.remaining() > 0) {
            throw new EOFException("Reached the end of stream with " + byteBufr.remaining() + " bytes left to read");
        }
    }

    public long getLength() throws IOException {
        return this.input.length();
    }

    public SeekableInputStream newStream() {
        return new SeekableInputStream(){
            private final byte[] tmpBuf = new byte[8192];
            private long markPos = 0L;

            public int read() throws IOException {
                return LocalInputFile.this.input.read();
            }

            public int read(byte[] b) throws IOException {
                return LocalInputFile.this.input.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return LocalInputFile.this.input.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                long savPos = LocalInputFile.this.input.getFilePointer();
                long amtLeft = LocalInputFile.this.input.length() - savPos;
                n = Math.min(n, amtLeft);
                long newPos = savPos + n;
                LocalInputFile.this.input.seek(newPos);
                long curPos = LocalInputFile.this.input.getFilePointer();
                return curPos - savPos;
            }

            public int available() throws IOException {
                return 0;
            }

            public void close() throws IOException {
                LocalInputFile.this.input.close();
            }

            private <T extends Throwable, R> R uncheckedExceptionThrow(Throwable t) throws T {
                throw t;
            }

            public synchronized void mark(int readlimit) {
                try {
                    this.markPos = LocalInputFile.this.input.getFilePointer();
                }
                catch (IOException e) {
                    this.uncheckedExceptionThrow(e);
                }
            }

            public synchronized void reset() throws IOException {
                LocalInputFile.this.input.seek(this.markPos);
            }

            public boolean markSupported() {
                return true;
            }

            public long getPos() throws IOException {
                return LocalInputFile.this.input.getFilePointer();
            }

            public void seek(long l) throws IOException {
                LocalInputFile.this.input.seek(l);
            }

            public void readFully(byte[] bytes) throws IOException {
                LocalInputFile.this.input.readFully(bytes);
            }

            public void readFully(byte[] bytes, int i, int i1) throws IOException {
                LocalInputFile.this.input.readFully(bytes, i, i1);
            }

            public int read(ByteBuffer byteBuffer) throws IOException {
                return LocalInputFile.readDirectBuffer(byteBuffer, this.tmpBuf, LocalInputFile.this.input::read);
            }

            public void readFully(ByteBuffer byteBuffer) throws IOException {
                LocalInputFile.readFullyDirectBuffer(byteBuffer, this.tmpBuf, LocalInputFile.this.input::read);
            }
        };
    }

    private static interface ByteBufReader {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

