/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.parquet;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.common.util.BrokerReader;
import org.apache.doris.thrift.TBrokerFD;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class BrokerInputFile
implements InputFile {
    private static final Logger LOG = LogManager.getLogger(BrokerInputFile.class);
    private static final int COPY_BUFFER_SIZE = 0x100000;
    private BrokerDesc brokerDesc;
    private String filePath;
    private long fileLength = 0L;
    private BrokerReader reader;
    private TBrokerFD fd;

    public static BrokerInputFile create(String filePath, BrokerDesc brokerDesc) throws IOException {
        BrokerInputFile inputFile = new BrokerInputFile(filePath, brokerDesc);
        inputFile.init();
        return inputFile;
    }

    public static BrokerInputFile create(String filePath, BrokerDesc brokerDesc, String ip, int port) throws IOException {
        BrokerInputFile inputFile = new BrokerInputFile(filePath, brokerDesc);
        inputFile.init(ip, port);
        return inputFile;
    }

    private BrokerInputFile(String filePath, BrokerDesc brokerDesc) {
        this.filePath = filePath;
        this.brokerDesc = brokerDesc;
    }

    private void init() throws IOException {
        this.reader = BrokerReader.create(this.brokerDesc);
        this.fileLength = this.reader.getFileLength(this.filePath);
        this.fd = this.reader.open(this.filePath);
    }

    private void init(String ip, int port) throws IOException {
        this.reader = BrokerReader.create(this.brokerDesc, ip, port);
        this.fileLength = this.reader.getFileLength(this.filePath);
        this.fd = this.reader.open(this.filePath);
    }

    public long getLength() throws IOException {
        return this.fileLength;
    }

    public SeekableInputStream newStream() throws IOException {
        return new SeekableInputStream(){
            private final byte[] tmpBuf = new byte[0x100000];
            private long currentPos = 0L;
            private long markPos = 0L;
            private long bufferOffset = 0L;
            private long bufferLimit = 0L;

            public int read() throws IOException {
                try {
                    if (this.currentPos < this.bufferOffset || this.currentPos > this.bufferLimit || this.bufferOffset >= this.bufferLimit) {
                        this.bufferOffset = this.currentPos;
                        this.fill();
                    }
                    if (this.currentPos > this.bufferLimit) {
                        LOG.warn("current pos {} is larger than buffer limit {}. should not happen.", (Object)this.currentPos, (Object)this.bufferLimit);
                        return -1;
                    }
                    int pos = (int)(this.currentPos - this.bufferOffset);
                    int res = Byte.toUnsignedInt(this.tmpBuf[pos]);
                    ++this.currentPos;
                    return res;
                }
                catch (BrokerReader.EOFException e) {
                    return -1;
                }
            }

            private void fill() throws IOException, BrokerReader.EOFException {
                byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.bufferOffset, 0x100000);
                System.arraycopy(data, 0, this.tmpBuf, 0, data.length);
                this.bufferLimit = this.bufferOffset + (long)data.length;
            }

            public int read(byte[] b) throws IOException {
                try {
                    byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.currentPos, b.length);
                    System.arraycopy(data, 0, b, 0, data.length);
                    this.currentPos += (long)data.length;
                    return data.length;
                }
                catch (BrokerReader.EOFException e) {
                    return -1;
                }
            }

            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    if (this.currentPos < this.bufferOffset || this.currentPos > this.bufferLimit || this.currentPos + (long)len > this.bufferLimit) {
                        if (len > 0x100000) {
                            byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.currentPos, len);
                            System.arraycopy(data, 0, b, off, data.length);
                            this.currentPos += (long)data.length;
                            return data.length;
                        }
                        this.bufferOffset = this.currentPos;
                        this.fill();
                    }
                    if (this.currentPos > this.bufferLimit) {
                        LOG.warn("current pos {} is larger than buffer limit {}. should not happen.", (Object)this.currentPos, (Object)this.bufferLimit);
                        return -1;
                    }
                    int start = (int)(this.currentPos - this.bufferOffset);
                    int readLen = Math.min(len, (int)(this.bufferLimit - this.bufferOffset));
                    System.arraycopy(this.tmpBuf, start, b, off, readLen);
                    this.currentPos += (long)readLen;
                    return readLen;
                }
                catch (BrokerReader.EOFException e) {
                    return -1;
                }
            }

            public long skip(long n) throws IOException {
                long left = BrokerInputFile.this.fileLength - this.currentPos;
                long min = Math.min(n, left);
                this.currentPos += min;
                return min;
            }

            public int available() throws IOException {
                return 0;
            }

            public void close() throws IOException {
                BrokerInputFile.this.reader.close(BrokerInputFile.this.fd);
            }

            private <T extends Throwable, R> R uncheckedExceptionThrow(Throwable t) throws T {
                throw t;
            }

            public synchronized void mark(int readlimit) {
                this.markPos = this.currentPos;
            }

            public synchronized void reset() throws IOException {
                this.currentPos = this.markPos;
            }

            public boolean markSupported() {
                return true;
            }

            public long getPos() throws IOException {
                return this.currentPos;
            }

            public void seek(long l) throws IOException {
                this.currentPos = l;
            }

            public void readFully(byte[] bytes) throws IOException {
                try {
                    byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.currentPos, bytes.length);
                    System.arraycopy(data, 0, bytes, 0, data.length);
                    this.currentPos += (long)data.length;
                    if (data.length < bytes.length) {
                        throw new EOFException("Reach the end of file with " + (bytes.length - data.length) + " bytes left to read");
                    }
                }
                catch (BrokerReader.EOFException e) {
                    throw new EOFException("Reach the end of file");
                }
            }

            public void readFully(byte[] bytes, int offset, int len) throws IOException {
                try {
                    byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.currentPos, len);
                    System.arraycopy(data, 0, bytes, offset, data.length);
                    this.currentPos += (long)data.length;
                    if (data.length < len) {
                        throw new EOFException("Reach the end of file with " + (len - data.length) + " bytes left to read");
                    }
                }
                catch (BrokerReader.EOFException e) {
                    throw new EOFException("Reach the end of file");
                }
            }

            public int read(ByteBuffer byteBuffer) throws IOException {
                try {
                    byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.currentPos, byteBuffer.remaining());
                    byteBuffer.put(data);
                    this.currentPos += (long)data.length;
                    return data.length;
                }
                catch (BrokerReader.EOFException e) {
                    return -1;
                }
            }

            public void readFully(ByteBuffer byteBuffer) throws IOException {
                long markCurPos = this.currentPos;
                while (byteBuffer.remaining() > 0) {
                    try {
                        byte[] data = BrokerInputFile.this.reader.pread(BrokerInputFile.this.fd, this.currentPos, byteBuffer.remaining());
                        byteBuffer.put(data);
                        this.currentPos += (long)data.length;
                    }
                    catch (BrokerReader.EOFException e) {
                        if (byteBuffer.remaining() <= 0) continue;
                        throw new EOFException("Reach the end of file with " + byteBuffer.remaining() + " bytes left to read. read len: " + (this.currentPos - markCurPos));
                    }
                }
            }
        };
    }
}

