/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.logger;

import org.apache.doris.common.logger.DefaultDorisLogger;
import org.apache.doris.common.logger.TaggableLogger;
import org.apache.doris.common.logger.TaggedLogFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerProvider {
    public static TaggableLogger getLogger(Class<?> clazz) {
        return LoggerProvider.wrap(LogManager.getLogger(clazz));
    }

    public static TaggableLogger getLogger(String name) {
        return LoggerProvider.wrap(LogManager.getLogger((String)name));
    }

    public static TaggableLogger wrap(Logger logger) {
        return new DefaultDorisLogger((ExtendedLogger)logger, LoggerProvider.getTaggedLogFormat());
    }

    public static TaggedLogFormat getTaggedLogFormat() {
        return (message, tags) -> {
            StringBuilder builder = new StringBuilder(message.getFormattedMessage());
            while (tags != null) {
                builder.append('|').append(tags.key).append('=').append(tags.value);
                tags = tags.next;
            }
            return new SimpleMessage((CharSequence)builder);
        };
    }
}

