/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.logger;

import org.apache.doris.common.logger.TaggableLogger;
import org.apache.doris.common.logger.TaggedLogFormat;
import org.apache.doris.common.logger.Tags;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class DefaultDorisLogger
extends ExtendedLoggerWrapper
implements TaggableLogger {
    private final TaggedLogFormat format;
    private final ThreadLocal<Tags> tags;

    public DefaultDorisLogger(ExtendedLogger logger, TaggedLogFormat format) {
        super(logger, logger.getName(), logger.getMessageFactory());
        this.format = format;
        this.tags = ThreadLocal.withInitial(Tags::new);
    }

    @Override
    public TaggableLogger tag(String key, Object value) {
        Tags head = this.tags.get();
        Tags tag = new Tags();
        tag.key = key;
        tag.value = value;
        tag.next = head.next;
        head.next = tag;
        return this;
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        Tags tags = this.tags.get();
        Message m = tags.next == null ? message : this.format.getTaggedMessage(message, tags.next);
        super.logMessage(fqcn, level, marker, m, t);
        tags.next = null;
    }
}

