/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TreeNode<NodeType extends TreeNode<NodeType>> {
    protected ArrayList<NodeType> children = Lists.newArrayList();

    public NodeType getChild(int i) {
        return (NodeType)(this.hasChild(i) ? (TreeNode)this.children.get(i) : null);
    }

    public void addChild(NodeType n) {
        this.children.add(n);
    }

    public void addChildren(List<? extends NodeType> n) {
        this.children.addAll(n);
    }

    public boolean hasChild(int i) {
        return this.children.size() > i;
    }

    public void setChild(int index, NodeType n) {
        this.children.set(index, n);
    }

    public ArrayList<NodeType> getChildren() {
        return this.children;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void removeNode(int i) {
        if (this.children != null && i >= 0 && i < this.children.size()) {
            this.children.remove(i);
        }
    }

    public int numNodes() {
        int numNodes = 1;
        for (TreeNode child : this.children) {
            numNodes += child.numNodes();
        }
        return numNodes;
    }

    public <C extends TreeNode<NodeType>, D extends C> void collect(Predicate<? super C> predicate, Collection<D> matches) {
        if (predicate.apply((Object)this) && !matches.contains(this)) {
            matches.add(this);
            return;
        }
        for (TreeNode child : this.children) {
            child.collect(predicate, matches);
        }
    }

    public <C extends TreeNode<NodeType>, D extends C> void collect(Class cl, Collection<D> matches) {
        if (cl.equals(this.getClass())) {
            matches.add(this);
            return;
        }
        for (TreeNode child : this.children) {
            child.collect(cl, matches);
        }
    }

    public <C extends TreeNode<NodeType>, D extends C> void collectAll(Predicate<? super C> predicate, List<D> matches) {
        if (predicate.apply((Object)this)) {
            matches.add(this);
        }
        for (TreeNode child : this.children) {
            child.collectAll(predicate, matches);
        }
    }

    public static <C extends TreeNode<C>, D extends C> void collect(Collection<C> nodeList, Predicate<? super C> predicate, Collection<D> matches) {
        for (TreeNode node : nodeList) {
            node.collect(predicate, matches);
        }
    }

    public static <C extends TreeNode<C>, D extends C> void collect(Collection<C> nodeList, Class cl, Collection<D> matches) {
        for (TreeNode node : nodeList) {
            node.collect(cl, matches);
        }
    }

    public boolean contains(Class cl) {
        if (cl.isAssignableFrom(this.getClass()) && this.getClass().isAssignableFrom(cl)) {
            return true;
        }
        for (TreeNode child : this.children) {
            if (!child.contains(cl)) continue;
            return true;
        }
        return false;
    }

    public <C extends TreeNode<NodeType>> boolean contains(Predicate<? super C> predicate) {
        if (predicate.apply((Object)this)) {
            return true;
        }
        for (TreeNode child : this.children) {
            if (!child.contains(predicate)) continue;
            return true;
        }
        return false;
    }

    public static <C extends TreeNode<C>, D extends C> boolean contains(Collection<C> nodeList, Predicate<? super C> predicate) {
        for (TreeNode node : nodeList) {
            if (!node.contains(predicate)) continue;
            return true;
        }
        return false;
    }

    public static <C extends TreeNode<C>> boolean contains(List<C> nodeList, Class cl) {
        for (TreeNode node : nodeList) {
            if (!node.contains(cl)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSubclass(Class cl) {
        if (cl.isAssignableFrom(this.getClass())) {
            return true;
        }
        for (TreeNode child : this.children) {
            if (!child.containsSubclass(cl)) continue;
            return true;
        }
        return false;
    }

    public <C extends NodeType> C findFirstOf(Class<C> cl) {
        if (this.getClass().equals(cl)) {
            return (C)this;
        }
        for (TreeNode child : this.children) {
            C result = child.findFirstOf(cl);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

