/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.doris.common.ThriftServer;
import org.apache.doris.common.ThriftServerContext;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class ThriftServerEventProcessor
implements TServerEventHandler {
    private static final Logger LOG = LogManager.getLogger(ThriftServerEventProcessor.class);
    private ThriftServer thriftServer;
    private static ThreadLocal<ThriftServerContext> connectionContext;

    public ThriftServerEventProcessor(ThriftServer thriftServer) {
        this.thriftServer = thriftServer;
        connectionContext = new ThreadLocal();
    }

    public static ThriftServerContext getConnectionContext() {
        return connectionContext.get();
    }

    public void preServe() {
    }

    public ServerContext createContext(TProtocol input, TProtocol output) {
        TSocket tSocket = null;
        TTransport transport = input.getTransport();
        switch (this.thriftServer.getType()) {
            case THREADED_SELECTOR: {
                Preconditions.checkState((boolean)(transport instanceof TFramedTransport));
                LOG.debug("TFramedTransport cannot create thrift context. server type: {}", (Object)this.thriftServer.getType());
                return null;
            }
            case SIMPLE: 
            case THREAD_POOL: {
                Preconditions.checkState((boolean)(transport instanceof TSocket));
                tSocket = (TSocket)transport;
            }
        }
        if (tSocket == null) {
            LOG.warn("fail to get client socket. server type: {}", (Object)this.thriftServer.getType());
            return null;
        }
        SocketAddress socketAddress = tSocket.getSocket().getRemoteSocketAddress();
        InetSocketAddress inetSocketAddress = null;
        if (!(socketAddress instanceof InetSocketAddress)) {
            LOG.warn("fail to get client socket address. server type: {}", (Object)this.thriftServer.getType());
            return null;
        }
        inetSocketAddress = (InetSocketAddress)socketAddress;
        TNetworkAddress clientAddress = new TNetworkAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        this.thriftServer.addConnect(clientAddress);
        LOG.debug("create thrift context. client: {}, server type: {}", (Object)clientAddress, (Object)this.thriftServer.getType());
        return new ThriftServerContext(clientAddress);
    }

    public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
        if (serverContext == null) {
            return;
        }
        Preconditions.checkState((boolean)(serverContext instanceof ThriftServerContext));
        ThriftServerContext thriftServerContext = (ThriftServerContext)serverContext;
        TNetworkAddress clientAddress = thriftServerContext.getClient();
        connectionContext.remove();
        this.thriftServer.removeConnect(clientAddress);
        LOG.debug("delete thrift context. client: {}, server type: {}", (Object)clientAddress, (Object)this.thriftServer.getType());
    }

    public void processContext(ServerContext serverContext, TTransport inputTransport, TTransport outputTransport) {
        if (serverContext == null) {
            return;
        }
        ThriftServerContext thriftServerContext = (ThriftServerContext)serverContext;
        TNetworkAddress clientAddress = thriftServerContext.getClient();
        connectionContext.set(new ThriftServerContext(clientAddress));
    }
}

