/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.doris.common.Config;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.ThriftServerEventProcessor;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TSimpleServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftServer {
    private static final Logger LOG = LogManager.getLogger(ThriftServer.class);
    private ThriftServerType type;
    private int port;
    private TProcessor processor;
    private TServer server;
    private Thread serverThread;
    private Set<TNetworkAddress> connects;
    public static final String SIMPLE = "SIMPLE";
    public static final String THREADED_SELECTOR = "THREADED_SELECTOR";
    public static final String THREAD_POOL = "THREAD_POOL";

    public ThriftServer(int port, TProcessor processor) {
        this.port = port;
        this.processor = processor;
        this.connects = Sets.newConcurrentHashSet();
        this.type = ThriftServerType.getThriftServerType(Config.thrift_server_type);
    }

    public ThriftServerType getType() {
        return this.type;
    }

    private void createSimpleServer() throws TTransportException {
        TServer.Args args = (TServer.Args)((TServer.Args)new TServer.Args((TServerTransport)new TServerSocket(this.port)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor(this.processor);
        this.server = new TSimpleServer((TServer.AbstractServerArgs)args);
    }

    private void createThreadedServer() throws TTransportException {
        TThreadedSelectorServer.Args args = (TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)new TThreadedSelectorServer.Args((TNonblockingServerTransport)new TNonblockingServerSocket(this.port, Config.thrift_client_timeout_ms)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor(this.processor);
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolManager.newDaemonCacheThreadPool(Config.thrift_server_max_worker_threads, "thrift-server-pool", true);
        args.executorService((ExecutorService)threadPoolExecutor);
        this.server = new TThreadedSelectorServer(args);
    }

    private void createThreadPoolServer() throws TTransportException {
        TServerSocket.ServerSocketTransportArgs socketTransportArgs = (TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().bindAddr(new InetSocketAddress(this.port))).clientTimeout(Config.thrift_client_timeout_ms)).backlog(Config.thrift_backlog_num);
        TThreadPoolServer.Args serverArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)new TServerSocket(socketTransportArgs)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor(this.processor);
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolManager.newDaemonCacheThreadPool(Config.thrift_server_max_worker_threads, "thrift-server-pool", true);
        serverArgs.executorService((ExecutorService)threadPoolExecutor);
        this.server = new TThreadPoolServer(serverArgs);
    }

    public void start() throws IOException {
        try {
            switch (this.type) {
                case SIMPLE: {
                    this.createSimpleServer();
                    break;
                }
                case THREADED_SELECTOR: {
                    this.createThreadedServer();
                    break;
                }
                default: {
                    this.createThreadPoolServer();
                    break;
                }
            }
        }
        catch (TTransportException ex) {
            LOG.warn("create thrift server failed.", (Throwable)ex);
            throw new IOException("create thrift server failed.", ex);
        }
        ThriftServerEventProcessor eventProcessor = new ThriftServerEventProcessor(this);
        this.server.setServerEventHandler((TServerEventHandler)eventProcessor);
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ThriftServer.this.server.serve();
            }
        });
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void join() throws InterruptedException {
        if (this.server != null && this.server.isServing()) {
            this.server.stop();
        }
        this.serverThread.join();
    }

    public void addConnect(TNetworkAddress clientAddress) {
        this.connects.add(clientAddress);
    }

    public void removeConnect(TNetworkAddress clientAddress) {
        this.connects.remove(clientAddress);
    }

    public static enum ThriftServerType {
        SIMPLE("SIMPLE"),
        THREADED_SELECTOR("THREADED_SELECTOR"),
        THREAD_POOL("THREAD_POOL");

        private final String value;

        private ThriftServerType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ThriftServerType getThriftServerType(String value) {
            for (ThriftServerType val : ThriftServerType.values()) {
                if (!val.getValue().equalsIgnoreCase(value)) continue;
                return val;
            }
            return THREAD_POOL;
        }
    }
}

