/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.doris.metric.GaugeMetric;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricLabel;
import org.apache.doris.metric.MetricRepo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadPoolManager {
    private static Map<String, ThreadPoolExecutor> nameToThreadPoolMap = Maps.newConcurrentMap();
    private static String[] poolMetricTypes = new String[]{"pool_size", "active_thread_num", "task_in_queue"};
    private static final long KEEP_ALIVE_TIME = 60L;

    public static void registerAllThreadPoolMetric() {
        for (Map.Entry<String, ThreadPoolExecutor> entry : nameToThreadPoolMap.entrySet()) {
            ThreadPoolManager.registerThreadPoolMetric(entry.getKey(), entry.getValue());
        }
        nameToThreadPoolMap.clear();
    }

    public static void registerThreadPoolMetric(String poolName, final ThreadPoolExecutor threadPool) {
        for (String poolMetricType : poolMetricTypes) {
            GaugeMetric<Integer> gauge = new GaugeMetric<Integer>("thread_pool", Metric.MetricUnit.NOUNIT, "thread_pool statistics"){

                @Override
                public Integer getValue() {
                    String metricType;
                    switch (metricType = this.getLabels().get(1).getValue()) {
                        case "pool_size": {
                            return threadPool.getPoolSize();
                        }
                        case "active_thread_num": {
                            return threadPool.getActiveCount();
                        }
                        case "task_in_queue": {
                            return threadPool.getQueue().size();
                        }
                    }
                    return 0;
                }
            };
            gauge.addLabel(new MetricLabel("name", poolName)).addLabel(new MetricLabel("type", poolMetricType));
            MetricRepo.PALO_METRIC_REGISTER.addPaloMetrics(gauge);
        }
    }

    public static ThreadPoolExecutor newDaemonCacheThreadPool(int maxNumThread, String poolName, boolean needRegisterMetric) {
        return ThreadPoolManager.newDaemonThreadPool(0, maxNumThread, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new LogDiscardPolicy(poolName), poolName, needRegisterMetric);
    }

    public static ThreadPoolExecutor newDaemonFixedThreadPool(int numThread, int queueSize, String poolName, boolean needRegisterMetric) {
        return ThreadPoolManager.newDaemonThreadPool(numThread, numThread, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new BlockedPolicy(poolName, 60), poolName, needRegisterMetric);
    }

    public static ThreadPoolExecutor newDaemonProfileThreadPool(int numThread, int queueSize, String poolName, boolean needRegisterMetric) {
        return ThreadPoolManager.newDaemonThreadPool(numThread, numThread, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new LogDiscardOldestPolicy(poolName), poolName, needRegisterMetric);
    }

    public static ThreadPoolExecutor newDaemonThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler, String poolName, boolean needRegisterMetric) {
        ThreadFactory threadFactory = ThreadPoolManager.namedThreadFactory(poolName);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        if (needRegisterMetric) {
            nameToThreadPoolMap.put(poolName, threadPool);
        }
        return threadPool;
    }

    public static ScheduledThreadPoolExecutor newDaemonScheduledThreadPool(int corePoolSize, String poolName, boolean needRegisterMetric) {
        ThreadFactory threadFactory = ThreadPoolManager.namedThreadFactory(poolName);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        if (needRegisterMetric) {
            nameToThreadPoolMap.put(poolName, scheduledThreadPoolExecutor);
        }
        return scheduledThreadPoolExecutor;
    }

    private static ThreadFactory namedThreadFactory(String poolName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(poolName + "-%d").build();
    }

    static class LogDiscardOldestPolicy
    implements RejectedExecutionHandler {
        private static final Logger LOG = LogManager.getLogger(LogDiscardOldestPolicy.class);
        private String threadPoolName;

        public LogDiscardOldestPolicy(String threadPoolName) {
            this.threadPoolName = threadPoolName;
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                Runnable discardTask = (Runnable)executor.getQueue().poll();
                LOG.warn("Task: {} submit to {}, and discard the oldest task:{}", (Object)task, (Object)this.threadPoolName, (Object)discardTask);
                executor.execute(task);
            }
        }
    }

    static class BlockedPolicy
    implements RejectedExecutionHandler {
        private static final Logger LOG = LogManager.getLogger(BlockedPolicy.class);
        private String threadPoolName;
        private int timeoutSeconds;

        public BlockedPolicy(String threadPoolName, int timeoutSeconds) {
            this.threadPoolName = threadPoolName;
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                boolean ret = executor.getQueue().offer(r, this.timeoutSeconds, TimeUnit.SECONDS);
                if (!ret) {
                    throw new RejectedExecutionException("submit task failed, queue size is full: " + this.threadPoolName);
                }
            }
            catch (InterruptedException e) {
                String errMsg = String.format("Task %s wait to enqueue in %s %s failed", r.toString(), this.threadPoolName, executor.toString());
                LOG.warn(errMsg);
                throw new RejectedExecutionException(errMsg);
            }
        }
    }

    static class LogDiscardPolicy
    implements RejectedExecutionHandler {
        private static final Logger LOG = LogManager.getLogger(LogDiscardPolicy.class);
        private String threadPoolName;

        public LogDiscardPolicy(String threadPoolName) {
            this.threadPoolName = threadPoolName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOG.warn("Task " + r.toString() + " rejected from " + this.threadPoolName + " " + executor.toString());
        }
    }
}

