/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import org.apache.doris.proto.Types;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TStatusCode;

public class Status {
    public static final Status OK = new Status();
    public static final Status CANCELLED = new Status(TStatusCode.CANCELLED, "Cancelled");
    public static final Status THRIFT_RPC_ERROR = new Status(TStatusCode.THRIFT_RPC_ERROR, "Thrift RPC failed");
    private TStatusCode errorCode;
    private String errorMsg;

    public TStatusCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Status() {
        this.errorCode = TStatusCode.OK;
        this.errorMsg = null;
    }

    public Status(Status status) {
        this(status.getErrorCode(), status.getErrorMsg());
    }

    public Status(TStatusCode code, String errorMsg) {
        this.errorCode = code;
        this.errorMsg = errorMsg;
    }

    public Status(TStatus status) {
        this.errorCode = status.status_code;
        if (status.isSetErrorMsgs()) {
            this.errorMsg = (String)status.error_msgs.get(0);
        }
    }

    public boolean ok() {
        return this.errorCode == TStatusCode.OK;
    }

    public boolean isCancelled() {
        return this.errorCode == TStatusCode.CANCELLED;
    }

    public boolean isRpcError() {
        return this.errorCode == TStatusCode.THRIFT_RPC_ERROR;
    }

    public void setStatus(Status status) {
        this.errorCode = status.errorCode;
        this.errorMsg = status.getErrorMsg();
    }

    public void setStatus(String msg) {
        this.errorCode = TStatusCode.INTERNAL_ERROR;
        this.errorMsg = msg;
    }

    public void setPstatus(Types.PStatus status) {
        this.errorCode = TStatusCode.findByValue((int)status.getStatusCode());
        if (!status.getErrorMsgsList().isEmpty()) {
            this.errorMsg = status.getErrorMsgs(0);
        }
    }

    public void setRpcStatus(String msg) {
        this.errorCode = TStatusCode.THRIFT_RPC_ERROR;
        this.errorMsg = msg;
    }

    public void rewriteErrorMsg() {
        if (this.ok()) {
            return;
        }
        switch (this.errorCode) {
            case CANCELLED: {
                this.errorMsg = "Cancelled";
                break;
            }
            case ANALYSIS_ERROR: {
                this.errorMsg = "Analysis_error";
                break;
            }
            case NOT_IMPLEMENTED_ERROR: {
                this.errorMsg = "Not_implemented_error";
                break;
            }
            case RUNTIME_ERROR: {
                this.errorMsg = "Runtime_error";
                break;
            }
            case MEM_LIMIT_EXCEEDED: {
                this.errorMsg = "Mem_limit_error";
                break;
            }
            case INTERNAL_ERROR: {
                this.errorMsg = "Internal_error";
                break;
            }
            case THRIFT_RPC_ERROR: {
                this.errorMsg = "Thrift_rpc_error";
                break;
            }
            case TIMEOUT: {
                this.errorMsg = "Timeout";
                break;
            }
            default: {
                this.errorMsg = "Unknown_error";
            }
        }
    }
}

