/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.doris.common.AnalysisException;

public class PatternMatcher {
    private Pattern pattern;
    private static final Set<Character> FORBIDDEN_CHARS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('<'), Character.valueOf('('), Character.valueOf('['), Character.valueOf('{'), Character.valueOf('^'), Character.valueOf('='), Character.valueOf('$'), Character.valueOf('!'), Character.valueOf('|'), Character.valueOf(']'), Character.valueOf('}'), Character.valueOf(')'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('>'), Character.valueOf('@')});

    public boolean match(String candidate) {
        if (this.pattern == null || candidate == null) {
            return false;
        }
        return this.pattern.matcher(candidate).matches();
    }

    private static String convertMysqlPattern(String mysqlPattern) throws AnalysisException {
        char ch;
        int i;
        String newMysqlPattern = mysqlPattern;
        StringBuilder sb = new StringBuilder();
        block12: for (i = 0; i < newMysqlPattern.length(); ++i) {
            ch = newMysqlPattern.charAt(i);
            PatternMatcher.checkPermittedCharactor(ch);
            switch (ch) {
                case '%': {
                    sb.append(".*");
                    continue block12;
                }
                case '.': {
                    sb.append("\\.");
                    continue block12;
                }
                case '_': {
                    sb.append(".");
                    continue block12;
                }
                case '\\': {
                    if (i == newMysqlPattern.length() - 1) {
                        sb.append('\\');
                        continue block12;
                    }
                    char nextChar = newMysqlPattern.charAt(i + 1);
                    switch (nextChar) {
                        case '%': 
                        case '\\': 
                        case '_': {
                            sb.append(nextChar);
                            ++i;
                            continue block12;
                        }
                    }
                    continue block12;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        newMysqlPattern = sb.toString();
        sb = new StringBuilder();
        block13: for (i = 0; i < newMysqlPattern.length(); ++i) {
            ch = newMysqlPattern.charAt(i);
            switch (ch) {
                case '\\': {
                    if (i == newMysqlPattern.length() - 1) {
                        sb.append('\\').append('\\');
                        continue block13;
                    }
                    if (newMysqlPattern.charAt(i + 1) == '.') {
                        sb.append('\\').append('.');
                        ++i;
                        continue block13;
                    }
                    sb.append('\\').append('\\');
                    continue block13;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static void checkPermittedCharactor(char c) throws AnalysisException {
        if (FORBIDDEN_CHARS.contains(Character.valueOf(c))) {
            throw new AnalysisException("Forbidden charactor: '" + c + "'");
        }
    }

    public static PatternMatcher createMysqlPattern(String mysqlPattern, boolean caseSensitive) throws AnalysisException {
        PatternMatcher matcher = new PatternMatcher();
        String newMysqlPattern = Strings.nullToEmpty((String)mysqlPattern);
        String javaPattern = PatternMatcher.convertMysqlPattern(newMysqlPattern);
        try {
            matcher.pattern = caseSensitive ? Pattern.compile(javaPattern) : Pattern.compile(javaPattern, 2);
        }
        catch (Exception e) {
            throw new AnalysisException("Bad pattern in SQL: " + e.getMessage());
        }
        return matcher;
    }
}

