/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.gson.annotations.SerializedName;
import java.util.Comparator;

public class Pair<F, S> {
    public static PairComparator<Pair<?, Comparable>> PAIR_VALUE_COMPARATOR = new PairComparator();
    @SerializedName(value="first")
    public F first;
    @SerializedName(value="second")
    public S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public static <F, S> Pair<F, S> create(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair other = (Pair)o;
            return this.first.equals(other.first) && this.second.equals(other.second);
        }
        return false;
    }

    public int hashCode() {
        int hashFirst = this.first != null ? this.first.hashCode() : 0;
        int hashSecond = this.second != null ? this.second.hashCode() : 0;
        return (hashFirst + hashSecond) * hashSecond + hashFirst;
    }

    public String toString() {
        return this.first.toString() + ":" + this.second.toString();
    }

    public static class PairComparator<T extends Pair<?, Comparable>>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            return ((Comparable)((Pair)o1).second).compareTo(((Pair)o2).second);
        }
    }
}

