/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.MetaFooter;
import org.apache.doris.common.MetaHeader;
import org.apache.doris.common.MetaIndex;
import org.apache.doris.common.Reference;
import org.apache.doris.common.io.CountingDataOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaWriter {
    private static final Logger LOG = LogManager.getLogger(MetaWriter.class);
    public static MetaWriter writer = new MetaWriter();
    private Delegate delegate;

    public void setDelegate(CountingDataOutputStream dos, List<MetaIndex> indices) {
        this.delegate = (name, method) -> {
            indices.add(new MetaIndex(name, dos.getCount()));
            return method.write();
        };
    }

    public long doWork(String name, WriteMethod method) throws IOException {
        if (this.delegate == null) {
            return method.write();
        }
        return this.delegate.doWork(name, method);
    }

    public static void write(File imageFile, Catalog catalog) throws IOException {
        LOG.info("start to save image to {}. is ckpt: {}", (Object)imageFile.getAbsolutePath(), (Object)Catalog.isCheckpointThread());
        Reference<Long> checksum = new Reference<Long>(0L);
        long saveImageStartTime = System.currentTimeMillis();
        long startPosition = MetaHeader.write(imageFile);
        ArrayList metaIndices = Lists.newArrayList();
        FileOutputStream imageFileOut = new FileOutputStream(imageFile, true);
        try (CountingDataOutputStream dos = new CountingDataOutputStream((OutputStream)new BufferedOutputStream(imageFileOut), startPosition);){
            writer.setDelegate(dos, metaIndices);
            long replayedJournalId = catalog.getReplayedJournalId();
            checksum.setRef(writer.doWork("header", () -> catalog.saveHeader(dos, replayedJournalId, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("masterInfo", () -> catalog.saveMasterInfo(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("frontends", () -> catalog.saveFrontends(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("backends", () -> Catalog.getCurrentSystemInfo().saveBackends(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("db", () -> catalog.saveDb(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("loadJob", () -> catalog.saveLoadJob(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("alterJob", () -> catalog.saveAlterJob(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("recycleBin", () -> catalog.saveRecycleBin(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("globalVariable", () -> catalog.saveGlobalVariable(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("cluster", () -> catalog.saveCluster(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("broker", () -> catalog.saveBrokers(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("resources", () -> catalog.saveResources(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("exportJob", () -> catalog.saveExportJob(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("syncJob", () -> catalog.saveSyncJobs(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("backupHandler", () -> catalog.saveBackupHandler(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("paloAuth", () -> catalog.savePaloAuth(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("transactionState", () -> catalog.saveTransactionState(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("colocateTableIndex", () -> catalog.saveColocateTableIndex(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("routineLoadJobs", () -> catalog.saveRoutineLoadJobs(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("loadJobV2", () -> catalog.saveLoadJobsV2(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("smallFiles", () -> catalog.saveSmallFiles(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("plugins", () -> catalog.savePlugins((DataOutputStream)dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("deleteHandler", () -> catalog.saveDeleteHandler(dos, (Long)checksum.getRef())));
            checksum.setRef(writer.doWork("sqlBlockRule", () -> catalog.saveSqlBlockRule(dos, (Long)checksum.getRef())));
            imageFileOut.getChannel().force(true);
        }
        MetaFooter.write(imageFile, metaIndices, checksum.getRef());
        long saveImageEndTime = System.currentTimeMillis();
        LOG.info("finished save image {} in {} ms. checksum is {}", (Object)imageFile.getAbsolutePath(), (Object)(saveImageEndTime - saveImageStartTime), (Object)checksum.getRef());
    }

    private static interface WriteMethod {
        public long write() throws IOException;
    }

    private static interface Delegate {
        public long doWork(String var1, WriteMethod var2) throws IOException;
    }
}

