/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MetaFooter;
import org.apache.doris.common.MetaHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaReader {
    private static final Logger LOG = LogManager.getLogger(MetaReader.class);

    public static void read(File imageFile, Catalog catalog) throws IOException, DdlException {
        LOG.info("start load image from {}. is ckpt: {}", (Object)imageFile.getAbsolutePath(), (Object)Catalog.isCheckpointThread());
        long loadImageStartTime = System.currentTimeMillis();
        MetaHeader metaHeader = MetaHeader.read(imageFile);
        long checksum = 0L;
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(imageFile)));){
            IOUtils.skipFully((InputStream)dis, (long)metaHeader.getEnd());
            checksum = catalog.loadHeader(dis, metaHeader, checksum);
            checksum = catalog.loadMasterInfo(dis, checksum);
            checksum = catalog.loadFrontends(dis, checksum);
            checksum = Catalog.getCurrentSystemInfo().loadBackends(dis, checksum);
            checksum = catalog.loadDb(dis, checksum);
            catalog.recreateTabletInvertIndex();
            catalog.getEsRepository().loadTableFromCatalog();
            checksum = catalog.loadLoadJob(dis, checksum);
            checksum = catalog.loadAlterJob(dis, checksum);
            checksum = catalog.loadRecycleBin(dis, checksum);
            checksum = catalog.loadGlobalVariable(dis, checksum);
            checksum = catalog.loadCluster(dis, checksum);
            checksum = catalog.loadBrokers(dis, checksum);
            checksum = catalog.loadResources(dis, checksum);
            checksum = catalog.loadExportJob(dis, checksum);
            checksum = catalog.loadSyncJobs(dis, checksum);
            checksum = catalog.loadBackupHandler(dis, checksum);
            checksum = catalog.loadPaloAuth(dis, checksum);
            checksum = catalog.loadTransactionState(dis, checksum);
            checksum = catalog.loadColocateTableIndex(dis, checksum);
            checksum = catalog.loadRoutineLoadJobs(dis, checksum);
            checksum = catalog.loadLoadJobsV2(dis, checksum);
            checksum = catalog.loadSmallFiles(dis, checksum);
            checksum = catalog.loadPlugins(dis, checksum);
            checksum = catalog.loadDeleteHandler(dis, checksum);
            checksum = catalog.loadSqlBlockRule(dis, checksum);
        }
        MetaFooter metaFooter = MetaFooter.read(imageFile);
        long remoteChecksum = metaFooter.checksum;
        Preconditions.checkState((remoteChecksum == checksum ? 1 : 0) != 0, (Object)(remoteChecksum + " vs. " + checksum));
        long loadImageEndTime = System.currentTimeMillis();
        LOG.info("finished to load image in " + (loadImageEndTime - loadImageStartTime) + " ms");
    }
}

