/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Text;
import org.codehaus.jackson.map.ObjectMapper;

public class MetaJsonHeader {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String IMAGE_VERSION = FeConstants.meta_format.getVersion();
    public String imageVersion;

    public static MetaJsonHeader read(RandomAccessFile raf) throws IOException {
        String jsonHeader = Text.readString((DataInput)raf);
        return MetaJsonHeader.fromJson(jsonHeader);
    }

    public static void write(RandomAccessFile raf) throws IOException {
        MetaJsonHeader metaJsonHeader = new MetaJsonHeader();
        metaJsonHeader.imageVersion = IMAGE_VERSION;
        String jsonHeader = MetaJsonHeader.toJson(metaJsonHeader);
        Text.writeString((DataOutput)raf, (String)jsonHeader);
    }

    private static MetaJsonHeader fromJson(String json) throws IOException {
        return (MetaJsonHeader)OBJECT_MAPPER.readValue(json, MetaJsonHeader.class);
    }

    private static String toJson(MetaJsonHeader jsonHeader) throws IOException {
        return OBJECT_MAPPER.writeValueAsString((Object)jsonHeader);
    }
}

