/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.doris.common.io.Text;

public class MetaIndex {
    public String name;
    public long offset;

    public MetaIndex() {
    }

    public MetaIndex(String name, long offset) {
        this.name = name;
        this.offset = offset;
    }

    public static MetaIndex read(RandomAccessFile raf) throws IOException {
        MetaIndex metaIndex = new MetaIndex();
        metaIndex.name = Text.readString((DataInput)raf);
        metaIndex.offset = raf.readLong();
        return metaIndex;
    }

    public static void write(RandomAccessFile raf, MetaIndex metaIndex) throws IOException {
        Text.writeString((DataOutput)raf, (String)metaIndex.name);
        raf.writeLong(metaIndex.offset);
    }

    public String toString() {
        return this.name + ":" + this.offset;
    }
}

