/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.apache.doris.common.FeMetaFormat;
import org.apache.doris.common.MetaJsonHeader;
import org.apache.doris.common.MetaMagicNumber;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaHeader {
    private static final Logger LOG = LogManager.getLogger(MetaHeader.class);
    public static final MetaHeader EMPTY_HEADER = new MetaHeader(null, 0L);
    private static final long HEADER_LENGTH_SIZE = 4L;
    private long length;
    private FeMetaFormat metaFormat;
    public MetaJsonHeader metaJsonHeader;

    public static MetaHeader read(File imageFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(imageFile, "r");){
            raf.seek(0L);
            MetaMagicNumber magicNumber = MetaMagicNumber.read(raf);
            if (!Arrays.equals(MetaMagicNumber.MAGIC, magicNumber.getBytes())) {
                LOG.warn("Image file {} format mismatch. Expected magic number is {}, actual is {}", (Object)imageFile.getPath(), (Object)Arrays.toString(MetaMagicNumber.MAGIC), (Object)Arrays.toString(magicNumber.getBytes()));
                MetaHeader metaHeader = EMPTY_HEADER;
                return metaHeader;
            }
            MetaJsonHeader metaJsonHeader = MetaJsonHeader.read(raf);
            if (!MetaJsonHeader.IMAGE_VERSION.equalsIgnoreCase(metaJsonHeader.imageVersion)) {
                String errMsg = "Image file " + imageFile.getPath() + " format version mismatch. Expected version is " + MetaJsonHeader.IMAGE_VERSION + ", actual is" + metaJsonHeader.imageVersion;
                throw new IOException(errMsg);
            }
            long length = raf.getFilePointer() - (long)MetaMagicNumber.MAGIC_STR.length() - 4L;
            FeMetaFormat metaFormat = FeMetaFormat.valueOf(new String(magicNumber.getBytes()));
            LOG.info("Image header length: {}, format: {}.", (Object)length, (Object)metaFormat);
            MetaHeader metaHeader = new MetaHeader(metaJsonHeader, length, metaFormat);
            return metaHeader;
        }
    }

    public static long write(File imageFile) throws IOException {
        if (imageFile.length() != 0L) {
            throw new IOException("Meta header has to be written to an empty file.");
        }
        try (RandomAccessFile raf = new RandomAccessFile(imageFile, "rw");){
            raf.seek(0L);
            MetaMagicNumber.write(raf);
            MetaJsonHeader.write(raf);
            raf.getChannel().force(true);
            long l = raf.getFilePointer();
            return l;
        }
    }

    public MetaHeader(MetaJsonHeader metaJsonHeader, long length) {
        this(metaJsonHeader, length, FeMetaFormat.COR1);
    }

    public MetaHeader(MetaJsonHeader metaJsonHeader, long length, FeMetaFormat metaFormat) {
        this.metaJsonHeader = metaJsonHeader;
        this.length = length;
        this.metaFormat = metaFormat;
    }

    public long getEnd() {
        if (this.length > 0L) {
            return (long)MetaMagicNumber.MAGIC_STR.length() + 4L + this.length;
        }
        return 0L;
    }

    public long getLength() {
        return this.length;
    }

    public FeMetaFormat getMetaFormat() {
        return this.metaFormat;
    }

    public MetaJsonHeader getMetaJsonHeader() {
        return this.metaJsonHeader;
    }
}

