/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.doris.common.MetaIndex;
import org.apache.doris.common.MetaMagicNumber;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaFooter {
    private static final Logger LOG = LogManager.getLogger(MetaFooter.class);
    private static final long FOOTER_LENGTH_SIZE = 8L;
    private static final long CHECKSUM_LENGTH_SIZE = 8L;
    public long checksum;
    public long length;
    public List<MetaIndex> metaIndices;

    public static MetaFooter read(File imageFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(imageFile, "r");){
            long fileLength = raf.length();
            long footerLengthIndex = fileLength - 8L - (long)MetaMagicNumber.MAGIC_STR.length();
            raf.seek(footerLengthIndex);
            long footerLength = raf.readLong();
            MetaMagicNumber magicNumber = MetaMagicNumber.read(raf);
            if (!Arrays.equals(MetaMagicNumber.MAGIC, magicNumber.getBytes())) {
                LOG.warn("Image file {} format mismatch. Expected magic number is {}, actual is {}", (Object)imageFile.getPath(), (Object)Arrays.toString(MetaMagicNumber.MAGIC), (Object)Arrays.toString(magicNumber.getBytes()));
                long footerIndex = fileLength - 8L;
                raf.seek(footerIndex);
                long checksum = raf.readLong();
                MetaFooter metaFooter = new MetaFooter(Lists.newArrayList(), checksum, 8L);
                return metaFooter;
            }
            long footerIndex = footerLengthIndex - footerLength;
            raf.seek(footerIndex);
            long checksum = raf.readLong();
            int indexNum = raf.readInt();
            ArrayList metaIndices = Lists.newArrayList();
            for (int i = 0; i < indexNum; ++i) {
                MetaIndex index = MetaIndex.read(raf);
                metaIndices.add(index);
            }
            LOG.info("Image footer length: {}, indices: {}", (Object)footerLength, (Object)metaIndices.toArray());
            MetaFooter metaFooter = new MetaFooter(metaIndices, checksum, footerLength);
            return metaFooter;
        }
    }

    public static void write(File imageFile, List<MetaIndex> metaIndices, long checksum) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(imageFile, "rw");){
            long startIndex = raf.length();
            raf.seek(startIndex);
            raf.writeLong(checksum);
            raf.writeInt(metaIndices.size());
            for (MetaIndex metaIndex : metaIndices) {
                MetaIndex.write(raf, metaIndex);
            }
            long endIndex = raf.length();
            raf.writeLong(endIndex - startIndex);
            MetaMagicNumber.write(raf);
            raf.getChannel().force(true);
        }
    }

    public MetaFooter(List<MetaIndex> metaIndices, long checksum, long length) {
        this.checksum = checksum;
        this.metaIndices = metaIndices;
        this.length = length;
    }
}

