/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.doris.common.Status;

public class MarkedCountDownLatch<K, V>
extends CountDownLatch {
    private Multimap<K, V> marks;
    private Status st = Status.OK;

    public MarkedCountDownLatch(int count) {
        super(count);
        this.marks = HashMultimap.create();
    }

    public void addMark(K key, V value) {
        this.marks.put(key, value);
    }

    public synchronized boolean markedCountDown(K key, V value) {
        if (this.marks.remove(key, value)) {
            super.countDown();
            return true;
        }
        return false;
    }

    public synchronized List<Map.Entry<K, V>> getLeftMarks() {
        return Lists.newArrayList((Iterable)this.marks.entries());
    }

    public Status getStatus() {
        return this.st;
    }

    public synchronized void countDownToZero(Status status) {
        if (this.st.ok()) {
            this.st = status;
        }
        while (this.getCount() > 0L) {
            super.countDown();
        }
    }
}

