/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.UserException;

public class MarkDownParser {
    private Map<String, Map<String, String>> documents;
    private List<String> lines;
    private int nextToRead;
    private ParseState state;
    private int headLevel;
    private String head;
    private Map<String, String> keyValues;

    public MarkDownParser(List<String> lines) {
        this.lines = lines;
        this.documents = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.nextToRead = 0;
        this.state = ParseState.START;
    }

    public Map<String, Map<String, String>> parse() throws UserException {
        block5: while (this.nextToRead < this.lines.size()) {
            Map.Entry<String, String> keyValue = this.parseOneItem();
            if (keyValue == null) continue;
            switch (this.state) {
                case START: {
                    if (this.headLevel == 1) {
                        this.head = keyValue.getKey();
                        this.keyValues = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
                        this.state = ParseState.PARSED_H1;
                        continue block5;
                    }
                    throw new UserException("Head first read is not h1.");
                }
                case PARSED_H1: {
                    if (this.headLevel == 1) {
                        this.documents.put(this.head, this.keyValues);
                        this.head = keyValue.getKey();
                        this.keyValues = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
                        continue block5;
                    }
                    if (this.headLevel == 2) {
                        this.keyValues.put(keyValue.getKey(), keyValue.getValue());
                        this.state = ParseState.PARSED_H2;
                        continue block5;
                    }
                    throw new UserException("Unknown head level.");
                }
                case PARSED_H2: {
                    if (this.headLevel == 1) {
                        this.documents.put(this.head, this.keyValues);
                        this.head = keyValue.getKey();
                        this.keyValues = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
                        continue block5;
                    }
                    if (this.headLevel != 2) continue block5;
                    this.keyValues.put(keyValue.getKey(), keyValue.getValue());
                    continue block5;
                }
            }
            throw new UserException("Unknown parse state.");
        }
        if (this.head != null) {
            this.documents.put(this.head, this.keyValues);
        }
        return this.documents;
    }

    private Map.Entry<String, String> parseOneItem() {
        while (this.nextToRead < this.lines.size() && !this.lines.get(this.nextToRead).startsWith("#")) {
            ++this.nextToRead;
        }
        if (this.nextToRead >= this.lines.size()) {
            return null;
        }
        String key = this.lines.get(this.nextToRead++);
        this.headLevel = 0;
        while (this.headLevel < key.length() && key.charAt(this.headLevel) == '#') {
            ++this.headLevel;
        }
        StringBuilder sb = new StringBuilder();
        while (this.nextToRead < this.lines.size()) {
            if (!this.lines.get(this.nextToRead).startsWith("#")) {
                sb.append(this.lines.get(this.nextToRead)).append('\n');
                ++this.nextToRead;
                continue;
            }
            if (!this.lines.get(this.nextToRead).startsWith("###")) break;
            sb.append(this.lines.get(this.nextToRead).replaceAll("#", "")).append('\n');
            ++this.nextToRead;
        }
        return Maps.immutableEntry((Object)key.substring(this.headLevel).trim(), (Object)sb.toString().replaceAll("\\s+$", "\n"));
    }

    private static enum ParseState {
        START,
        PARSED_H1,
        PARSED_H2;

    }
}

