/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Preconditions;
import org.apache.doris.common.DdlException;
import org.apache.doris.transaction.TransactionState;

public class LabelAlreadyUsedException
extends DdlException {
    private static final long serialVersionUID = -6798925248765094813L;
    private String jobStatus;

    public LabelAlreadyUsedException(String label) {
        super("Label [" + label + "] has already been used.");
    }

    public LabelAlreadyUsedException(TransactionState txn) {
        super("Label [" + txn.getLabel() + "] has already been used, relate to txn [" + txn.getTransactionId() + "]");
        switch (txn.getTransactionStatus()) {
            case UNKNOWN: 
            case PREPARE: {
                this.jobStatus = "RUNNING";
                break;
            }
            case PRECOMMITTED: {
                this.jobStatus = "PRECOMMITTED";
                break;
            }
            case COMMITTED: 
            case VISIBLE: {
                this.jobStatus = "FINISHED";
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)((Object)txn.getTransactionStatus()));
            }
        }
    }

    public LabelAlreadyUsedException(String label, String subLabel) {
        super("Sub label [" + subLabel + "] has already been used.");
    }

    public String getJobStatus() {
        return this.jobStatus;
    }
}

