/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.lang.reflect.Constructor;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class GenericPool<VALUE extends TServiceClient> {
    private static final Logger LOG = LogManager.getLogger(GenericPool.class);
    private GenericKeyedObjectPool<TNetworkAddress, VALUE> pool;
    private String className;
    private int timeoutMs;
    private boolean isNonBlockingIO;

    public GenericPool(String className, GenericKeyedObjectPoolConfig config, int timeoutMs, boolean isNonBlockingIO) {
        this.className = "org.apache.doris.thrift." + className + "$Client";
        ThriftClientFactory factory = new ThriftClientFactory();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory, config);
        this.timeoutMs = timeoutMs;
        this.isNonBlockingIO = isNonBlockingIO;
    }

    public GenericPool(String className, GenericKeyedObjectPoolConfig config, int timeoutMs) {
        this(className, config, timeoutMs, false);
    }

    public boolean reopen(VALUE object, int timeoutMs) {
        boolean ok = true;
        object.getOutputProtocol().getTransport().close();
        try {
            object.getOutputProtocol().getTransport().open();
            if (!this.isNonBlockingIO) {
                TSocket socket = (TSocket)object.getOutputProtocol().getTransport();
                socket.setTimeout(timeoutMs);
            }
        }
        catch (TTransportException e) {
            ok = false;
        }
        return ok;
    }

    public boolean reopen(VALUE object) {
        boolean ok = true;
        object.getOutputProtocol().getTransport().close();
        try {
            object.getOutputProtocol().getTransport().open();
        }
        catch (TTransportException e) {
            LOG.warn("reopen error", (Throwable)e);
            ok = false;
        }
        return ok;
    }

    public void clearPool(TNetworkAddress addr) {
        this.pool.clear((Object)addr);
    }

    public boolean peak(VALUE object) {
        return object.getOutputProtocol().getTransport().peek();
    }

    public VALUE borrowObject(TNetworkAddress address) throws Exception {
        return (VALUE)((TServiceClient)this.pool.borrowObject((Object)address));
    }

    public VALUE borrowObject(TNetworkAddress address, int timeoutMs) throws Exception {
        TServiceClient value = (TServiceClient)this.pool.borrowObject((Object)address);
        if (!this.isNonBlockingIO) {
            TSocket socket = (TSocket)value.getOutputProtocol().getTransport();
            socket.setTimeout(timeoutMs);
        }
        return (VALUE)value;
    }

    public void returnObject(TNetworkAddress address, VALUE object) {
        if (address == null || object == null) {
            return;
        }
        this.pool.returnObject((Object)address, object);
    }

    public void invalidateObject(TNetworkAddress address, VALUE object) {
        if (address == null || object == null) {
            return;
        }
        try {
            this.pool.invalidateObject((Object)address, object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ThriftClientFactory
    extends BaseKeyedPooledObjectFactory<TNetworkAddress, VALUE> {
        private ThriftClientFactory() {
        }

        private Object newInstance(String className, TProtocol protocol) throws Exception {
            Class<?> newoneClass = Class.forName(className);
            Constructor<?> cons = newoneClass.getConstructor(TProtocol.class);
            return cons.newInstance(protocol);
        }

        public VALUE create(TNetworkAddress key) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("before create socket hostname={} key.port={} timeoutMs={}", (Object)key.hostname, (Object)key.port, (Object)GenericPool.this.timeoutMs);
            }
            TFramedTransport transport = GenericPool.this.isNonBlockingIO ? new TFramedTransport((TTransport)new TSocket(key.hostname, key.port, GenericPool.this.timeoutMs)) : new TSocket(key.hostname, key.port, GenericPool.this.timeoutMs);
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            TServiceClient client = (TServiceClient)this.newInstance(GenericPool.this.className, (TProtocol)protocol);
            return client;
        }

        public PooledObject<VALUE> wrap(VALUE client) {
            return new DefaultPooledObject(client);
        }

        public boolean validateObject(TNetworkAddress key, PooledObject<VALUE> p) {
            boolean isOpen = ((TServiceClient)p.getObject()).getOutputProtocol().getTransport().isOpen();
            LOG.debug("isOpen={}", (Object)isOpen);
            return isOpen;
        }

        public void destroyObject(TNetworkAddress key, PooledObject<VALUE> p) {
            if (((TServiceClient)p.getObject()).getOutputProtocol().getTransport().isOpen()) {
                ((TServiceClient)p.getObject()).getOutputProtocol().getTransport().close();
            }
        }
    }
}

