/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.qe.ConnectContext;

public class ErrorReport {
    private static String reportCommon(String pattern, ErrorCode errorCode, Object ... objs) {
        String errMsg = pattern == null ? errorCode.formatErrorMsg(objs) : String.format(pattern, objs);
        ConnectContext ctx = ConnectContext.get();
        if (ctx != null) {
            ctx.getState().setError(errorCode, errMsg);
        }
        return errMsg;
    }

    public static void reportAnalysisException(String pattern, Object ... objs) throws AnalysisException {
        throw new AnalysisException(ErrorReport.reportCommon(pattern, ErrorCode.ERR_UNKNOWN_ERROR, objs), ErrorCode.ERR_UNKNOWN_ERROR);
    }

    public static void reportAnalysisException(ErrorCode errorCode, Object ... objs) throws AnalysisException {
        ErrorReport.reportAnalysisException(null, errorCode, objs);
    }

    public static void reportAnalysisException(String pattern, ErrorCode errorCode, Object ... objs) throws AnalysisException {
        throw new AnalysisException(ErrorReport.reportCommon(pattern, errorCode, objs), errorCode);
    }

    public static void reportDdlException(String pattern, Object ... objs) throws DdlException {
        ErrorReport.reportDdlException(pattern, ErrorCode.ERR_UNKNOWN_ERROR, objs);
    }

    public static void reportDdlException(ErrorCode errorCode, Object ... objs) throws DdlException {
        ErrorReport.reportDdlException(null, errorCode, objs);
    }

    public static void reportDdlException(String pattern, ErrorCode errorCode, Object ... objs) throws DdlException {
        throw new DdlException(ErrorReport.reportCommon(pattern, errorCode, objs));
    }

    public static void report(String pattern, Object ... objs) {
        ErrorReport.report(pattern, ErrorCode.ERR_UNKNOWN_ERROR, objs);
    }

    public static void report(ErrorCode errorCode, Object ... objs) {
        ErrorReport.report(null, errorCode, objs);
    }

    public static void report(String pattern, ErrorCode errorCode, Object ... objs) {
        ErrorReport.reportCommon(pattern, errorCode, objs);
    }
}

