/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.apache.doris.common.util.Daemon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigWatcher
extends Daemon {
    private static final Logger LOG = LogManager.getLogger(ConfigWatcher.class);
    public final Path configPath;

    public ConfigWatcher(String configPathStr) {
        super("config watcher");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)configPathStr) ? 1 : 0) != 0);
        this.configPath = Paths.get(configPathStr, new String[0]);
    }

    @Override
    protected void runOneCycle() {
        LOG.debug("start config watcher loop");
        try {
            WatchKey key;
            boolean valid;
            WatchService watchService = FileSystems.getDefault().newWatchService();
            this.configPath.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            do {
                key = watchService.take();
                for (WatchEvent<?> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> watchEventPath = watchEvent;
                    Path filePath = (Path)watchEventPath.context();
                    LOG.info("config watcher [" + kind + " -> " + filePath + "]");
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.handleCreate(filePath);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.handleModify(filePath);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    this.handleDelete(filePath);
                }
            } while (valid = key.reset());
            LOG.warn("config watch key is not valid");
        }
        catch (Exception e) {
            LOG.warn("config watcher got exception", (Throwable)e);
        }
    }

    private void handleCreate(Path filePath) {
    }

    private void handleDelete(Path filePath) {
    }

    private void handleModify(Path filePath) {
    }

    public static void main(String[] args) throws InterruptedException {
        ConfigWatcher watcher = new ConfigWatcher("./");
        watcher.start();
        Thread.sleep(500000L);
    }
}

