/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.GenericPool;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.FrontendService;
import org.apache.doris.thrift.HeartbeatService;
import org.apache.doris.thrift.TPaloBrokerService;

public class ClientPool {
    static GenericKeyedObjectPoolConfig heartbeatConfig = new GenericKeyedObjectPoolConfig();
    static int heartbeatTimeoutMs = FeConstants.heartbeat_interval_second * 1000;
    static GenericKeyedObjectPoolConfig backendConfig = new GenericKeyedObjectPoolConfig();
    static GenericKeyedObjectPoolConfig brokerPoolConfig;
    static int brokerTimeoutMs;
    public static GenericPool<HeartbeatService.Client> backendHeartbeatPool;
    public static GenericPool<FrontendService.Client> frontendHeartbeatPool;
    public static GenericPool<FrontendService.Client> frontendPool;
    public static GenericPool<BackendService.Client> backendPool;
    public static GenericPool<TPaloBrokerService.Client> brokerPool;

    static {
        heartbeatConfig.setLifo(true);
        heartbeatConfig.setMaxIdlePerKey(2);
        heartbeatConfig.setMinIdlePerKey(1);
        heartbeatConfig.setMaxTotalPerKey(-1);
        heartbeatConfig.setMaxTotal(-1);
        heartbeatConfig.setMaxWaitMillis(500L);
        backendConfig.setLifo(true);
        backendConfig.setMaxIdlePerKey(128);
        backendConfig.setMinIdlePerKey(2);
        backendConfig.setMaxTotalPerKey(-1);
        backendConfig.setMaxTotal(-1);
        backendConfig.setMaxWaitMillis(500L);
        brokerPoolConfig = new GenericKeyedObjectPoolConfig();
        brokerTimeoutMs = Config.broker_timeout_ms;
        brokerPoolConfig.setLifo(true);
        brokerPoolConfig.setMaxIdlePerKey(128);
        brokerPoolConfig.setMinIdlePerKey(2);
        brokerPoolConfig.setMaxTotalPerKey(-1);
        brokerPoolConfig.setMaxTotal(-1);
        brokerPoolConfig.setMaxWaitMillis(500L);
        backendHeartbeatPool = new GenericPool("HeartbeatService", heartbeatConfig, heartbeatTimeoutMs);
        frontendHeartbeatPool = new GenericPool("FrontendService", heartbeatConfig, heartbeatTimeoutMs, Config.thrift_server_type.equalsIgnoreCase("THREADED_SELECTOR"));
        frontendPool = new GenericPool("FrontendService", backendConfig, Config.backend_rpc_timeout_ms, Config.thrift_server_type.equalsIgnoreCase("THREADED_SELECTOR"));
        backendPool = new GenericPool("BackendService", backendConfig, Config.backend_rpc_timeout_ms);
        brokerPool = new GenericPool("TPaloBrokerService", brokerPoolConfig, brokerTimeoutMs);
    }
}

