/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.math.LongMath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckedMath {
    private static final Logger LOG = LogManager.getLogger(CheckedMath.class);

    public static long checkedMultiply(long a, long b) {
        try {
            return LongMath.checkedMultiply((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            LOG.warn("overflow when multiplying longs: " + a + ", " + b);
            return Long.MAX_VALUE;
        }
    }

    public static long checkedAdd(long a, long b) {
        try {
            return LongMath.checkedAdd((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            LOG.warn("overflow when adding longs: " + a + ", " + b);
            return Long.MAX_VALUE;
        }
    }
}

