/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.collect.ImmutableMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CIDR {
    private static final Logger LOG = LogManager.getLogger(CIDR.class);
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})";
    private static final Pattern addressPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern cidrPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})");
    private int address;
    private int netmask;
    private static ImmutableMap<Integer, Integer> maskBitNumMap;

    public CIDR(String cidrNotation) {
        Matcher matcher;
        if (cidrNotation.indexOf("/") == -1) {
            cidrNotation = cidrNotation + "/32";
        }
        if ((matcher = cidrPattern.matcher(cidrNotation)).matches()) {
            this.address = this.matchAddress(matcher);
            int cidrPart = this.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 32);
            this.netmask = -1;
            this.netmask <<= 32 - cidrPart;
        } else {
            throw new IllegalArgumentException("Could not parse [" + cidrNotation + "]");
        }
    }

    public boolean contains(String address) {
        return this.contains(this.toInteger(address));
    }

    public String getIP() {
        return this.format(this.address);
    }

    public String getNetmask() {
        return this.format(this.netmask);
    }

    private String format(int val) {
        StringBuilder sb = new StringBuilder(15);
        for (int shift = 24; shift > 0; shift -= 8) {
            sb.append(val >>> shift & 0xFF);
            sb.append('.');
        }
        sb.append(val & 0xFF);
        return sb.toString();
    }

    public String getCIDR() {
        int numberOfBits = (Integer)maskBitNumMap.get((Object)this.netmask);
        return this.format(this.address & this.netmask) + "/" + numberOfBits;
    }

    public String getIpRange() {
        int numberOfBits = (Integer)maskBitNumMap.get((Object)this.netmask);
        int numberOfIPs = 0;
        for (int n = 0; n < 32 - numberOfBits; ++n) {
            numberOfIPs <<= 1;
            numberOfIPs |= 1;
        }
        int baseIP = this.address & this.netmask;
        String firstIP = this.format(baseIP + 1);
        String lastIP = this.format(baseIP + numberOfIPs - 1);
        return firstIP + " - " + lastIP;
    }

    private int matchAddress(Matcher matcher) {
        int addr = 0;
        for (int i = 1; i <= 4; ++i) {
            int n = this.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            addr |= (n & 0xFF) << 8 * (4 - i);
        }
        return addr;
    }

    private int rangeCheck(int value, int begin, int end) {
        if (value >= begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range [" + begin + "," + end + "]");
    }

    private long networkLong() {
        long network = this.address & this.netmask;
        return network & 0xFFFFFFFFL;
    }

    private long broadcastLong() {
        long network = this.address & this.netmask;
        long broadcast = network | (long)(~this.netmask);
        return broadcast & 0xFFFFFFFFL;
    }

    private int low() {
        int network = this.address & this.netmask;
        return this.broadcastLong() - this.networkLong() > 1L ? network + 1 : 0;
    }

    private int high() {
        int network = this.address & this.netmask;
        int broadcast = network | ~this.netmask;
        return this.broadcastLong() - this.networkLong() > 1L ? broadcast - 1 : 0;
    }

    private boolean contains(int ipInt) {
        long addrLong = (long)ipInt & 0xFFFFFFFFL;
        long lowLong = (long)this.low() & 0xFFFFFFFFL;
        long highLong = (long)this.high() & 0xFFFFFFFFL;
        return addrLong >= lowLong && addrLong <= highLong;
    }

    private int toInteger(String address) {
        Matcher matcher = addressPattern.matcher(address);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + address + "]");
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)0, (Object)0);
        builder.put((Object)-1, (Object)32);
        int value = Integer.MIN_VALUE;
        for (int i = 1; i < 32; ++i) {
            builder.put((Object)value, (Object)i);
            value >>= 1;
        }
        maskBitNumMap = builder.build();
        LOG.debug("maskMap={}", maskBitNumMap);
    }
}

