/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class AuditLog {
    public static final AuditLog SLOW_AUDIT = new AuditLog("audit.slow_query");
    public static final AuditLog QUERY_AUDIT = new AuditLog("audit.query");
    public static final AuditLog LOAD_AUDIT = new AuditLog("audit.load");
    public static final AuditLog STREAM_LOAD_AUDIT = new AuditLog("audit.stream_load");
    private Logger logger;

    public static AuditLog getQueryAudit() {
        return QUERY_AUDIT;
    }

    public static AuditLog getSlowAudit() {
        return SLOW_AUDIT;
    }

    public static AuditLog getLoadAudit() {
        return LOAD_AUDIT;
    }

    public static AuditLog getStreamLoadAudit() {
        return STREAM_LOAD_AUDIT;
    }

    public AuditLog(String auditName) {
        this.logger = LogManager.getLogger((String)auditName);
    }

    public void log(Object message) {
        this.logger.info(message);
    }

    public void log(String message) {
        this.logger.info(message);
    }

    public void log(String message, Object ... params) {
        this.logger.info(message, params);
    }

    public void log(Message message) {
        this.logger.info(message);
    }
}

