/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

public abstract class AliasGenerator {
    private int numGeneratedAliases = 1;
    protected String aliasPrefix = null;
    protected Set<String> usedAliases = Sets.newHashSet();

    public String getNextAlias() {
        Preconditions.checkNotNull((Object)this.aliasPrefix);
        do {
            String candidateAlias;
            if (!this.usedAliases.add(candidateAlias = this.aliasPrefix + Integer.toString(this.numGeneratedAliases++))) continue;
            return candidateAlias;
        } while (this.numGeneratedAliases >= 0);
        throw new IllegalStateException("Overflow occurred during alias generation.");
    }
}

