/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.cluster;

import com.google.common.base.Strings;

public class ClusterNamespace {
    public static final String CLUSTER_DELIMITER = ":";

    public static String getFullName(String cluster, String name) {
        return ClusterNamespace.linkString(cluster, name);
    }

    public static String getClusterNameFromFullName(String fullName) {
        if (!ClusterNamespace.checkName(fullName)) {
            return null;
        }
        return ClusterNamespace.extract(fullName, 0);
    }

    public static String getNameFromFullName(String fullName) {
        if (!ClusterNamespace.checkName(fullName)) {
            return fullName;
        }
        return ClusterNamespace.extract(fullName, 1);
    }

    private static boolean checkName(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return false;
        }
        String[] ele = str.split(CLUSTER_DELIMITER);
        return ele.length > 1;
    }

    private static String linkString(String cluster, String name) {
        if (Strings.isNullOrEmpty((String)cluster) || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (name.contains(CLUSTER_DELIMITER) || name.equalsIgnoreCase("root") || name.equalsIgnoreCase("admin")) {
            return name;
        }
        StringBuilder sb = new StringBuilder(cluster);
        sb.append(CLUSTER_DELIMITER).append(name);
        return sb.toString();
    }

    private static String extract(String fullName, int index) {
        String[] ele = fullName.split(CLUSTER_DELIMITER);
        return ele[index];
    }
}

