/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.cluster.BaseParam;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.LinkDbInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cluster
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Cluster.class);
    private Long id;
    private String name;
    private Set<Long> backendIdSet = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<String, LinkDbInfo> linkDbNames = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, LinkDbInfo> linkDbIds = new ConcurrentHashMap();
    private Set<Long> dbIds = ConcurrentHashMap.newKeySet();
    private Set<String> dbNames = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<String, Long> dbNameToIDs = new ConcurrentHashMap();
    private ReentrantLock lock = new ReentrantLock(true);

    private Cluster() {
    }

    public Cluster(String name, long id) {
        this.name = name;
        this.id = id;
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void addLinkDb(BaseParam param) {
        this.lock();
        try {
            if (Strings.isNullOrEmpty((String)param.getStringParam(1)) || param.getLongParam(1) <= 0L) {
                return;
            }
            LinkDbInfo info = new LinkDbInfo(param.getStringParam(1), param.getLongParam(1));
            this.linkDbNames.put(param.getStringParam(), info);
            this.linkDbIds.put(param.getLongParam(), info);
        }
        finally {
            this.unlock();
        }
    }

    public void removeLinkDb(BaseParam param) {
        this.lock();
        try {
            this.linkDbNames.remove(param.getStringParam());
            this.linkDbIds.remove(param.getLongParam());
        }
        finally {
            this.unlock();
        }
    }

    public boolean containLink(String dest, String src) {
        LinkDbInfo info = this.linkDbNames.get(dest);
        return info != null && info.getName().equals(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDb(String name, long id) {
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        this.lock();
        try {
            this.dbNames.add(name);
            this.dbIds.add(id);
            this.dbNameToIDs.put(name, id);
        }
        finally {
            this.unlock();
        }
    }

    public List<String> getDbNames() {
        ArrayList<String> ret = new ArrayList<String>();
        this.lock();
        try {
            ret.addAll(this.dbNames);
            ret.addAll(this.linkDbNames.keySet());
        }
        finally {
            this.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDb(String name, long id) {
        this.lock();
        try {
            this.dbNames.remove(name);
            this.dbIds.remove(id);
        }
        finally {
            this.unlock();
        }
    }

    public boolean containDb(String name) {
        return this.dbNames.contains(name);
    }

    public List<Long> getBackendIdList() {
        return Lists.newArrayList(this.backendIdSet);
    }

    public void setBackendIdList(List<Long> backendIdList) {
        if (backendIdList == null) {
            return;
        }
        this.backendIdSet = ConcurrentHashMap.newKeySet();
        this.backendIdSet.addAll(backendIdList);
    }

    public void addBackend(long backendId) {
        this.backendIdSet.add(backendId);
    }

    public void addBackends(List<Long> backendIds) {
        this.backendIdSet.addAll(backendIds);
    }

    public void removeBackend(long removedBackendId) {
        this.backendIdSet.remove(removedBackendId);
    }

    public static Cluster read(DataInput in) throws IOException {
        Cluster cluster = new Cluster();
        cluster.readFields(in);
        return cluster;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.id);
        Text.writeString((DataOutput)out, (String)this.name);
        out.writeLong(this.backendIdSet.size());
        for (Long l : this.backendIdSet) {
            out.writeLong(l);
        }
        int dbCount = this.dbIds.size();
        if (this.dbNames.contains(ClusterNamespace.getFullName(this.name, "information_schema"))) {
            --dbCount;
        }
        out.writeInt(dbCount);
        for (String name : this.dbNames) {
            if (!name.equals(ClusterNamespace.getFullName(this.name, "information_schema"))) {
                Text.writeString((DataOutput)out, (String)name);
                continue;
            }
            this.dbIds.remove(this.dbNameToIDs.get(name));
        }
        String string = String.format("%d vs %d, fatal error, Write cluster meta failed!", this.dbNames.size(), this.dbIds.size() + 1);
        Preconditions.checkState((this.dbNames.size() == this.dbIds.size() + 1 ? 1 : 0) != 0, (Object)string);
        out.writeInt(dbCount);
        Iterator<Object> iterator = this.dbIds.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            out.writeLong(l);
        }
        out.writeInt(this.linkDbNames.size());
        for (Map.Entry entry : this.linkDbNames.entrySet()) {
            Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
            ((LinkDbInfo)entry.getValue()).write(out);
        }
        out.writeInt(this.linkDbIds.size());
        for (Map.Entry entry : this.linkDbIds.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((LinkDbInfo)entry.getValue()).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.id = in.readLong();
        this.name = Text.readString((DataInput)in);
        Long len = in.readLong();
        while (true) {
            Long l = len;
            Long l2 = len = Long.valueOf(len - 1L);
            if (l <= 0L) break;
            Long id = in.readLong();
            this.backendIdSet.add(id);
        }
        int count = in.readInt();
        while (count-- > 0) {
            this.dbNames.add(Text.readString((DataInput)in));
        }
        count = in.readInt();
        while (count-- > 0) {
            this.dbIds.add(in.readLong());
        }
        count = in.readInt();
        while (count-- > 0) {
            String key = Text.readString((DataInput)in);
            LinkDbInfo value = new LinkDbInfo();
            value.readFields(in);
            this.linkDbNames.put(key, value);
        }
        count = in.readInt();
        while (count-- > 0) {
            long key = in.readLong();
            LinkDbInfo value = new LinkDbInfo();
            value.readFields(in);
            this.linkDbIds.put(key, value);
        }
    }
}

