/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.cluster;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class BaseParam
implements Writable {
    private final List<String> strParams = Lists.newArrayList();
    private final List<Long> longParams = Lists.newArrayList();
    private final List<Float> floatParams = Lists.newArrayList();

    public String getStringParam() {
        return this.strParams.get(0);
    }

    public String getStringParam(int index) {
        return this.strParams.get(index);
    }

    public void addStringParam(String value) {
        this.strParams.add(value);
    }

    public long getLongParam() {
        return this.longParams.get(0);
    }

    public long getLongParam(int index) {
        return this.longParams.get(index);
    }

    public void addLongParam(long value) {
        this.longParams.add(value);
    }

    public int getParamLength() {
        return this.strParams.size() + this.longParams.size();
    }

    public float getFloatParam(int index) {
        return this.floatParams.get(index).floatValue();
    }

    public void addFloatParam(float value) {
        this.floatParams.add(Float.valueOf(value));
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.strParams.size());
        for (String str : this.strParams) {
            Text.writeString((DataOutput)out, (String)str);
        }
        out.writeInt(this.longParams.size());
        Iterator<Object> iterator = this.longParams.iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            out.writeLong(value);
        }
        out.writeInt(this.floatParams.size());
        iterator = this.floatParams.iterator();
        while (iterator.hasNext()) {
            float value = ((Float)iterator.next()).floatValue();
            out.writeFloat(value);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int count = in.readInt();
        while (count-- > 0) {
            this.strParams.add(Text.readString((DataInput)in));
        }
        count = in.readInt();
        while (count-- > 0) {
            this.longParams.add(in.readLong());
        }
        count = in.readInt();
        while (count-- > 0) {
            this.floatParams.add(Float.valueOf(in.readFloat()));
        }
    }
}

