/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.clone.PartitionRebalancer;
import org.apache.doris.common.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TwoDimensionalGreedyRebalanceAlgo {
    private static final Logger LOG = LogManager.getLogger(TwoDimensionalGreedyRebalanceAlgo.class);
    private final EqualSkewOption equalSkewOption;
    private static final Random rand = new Random(System.currentTimeMillis());

    TwoDimensionalGreedyRebalanceAlgo() {
        this(EqualSkewOption.PICK_RANDOM);
    }

    TwoDimensionalGreedyRebalanceAlgo(EqualSkewOption equalSkewOption) {
        this.equalSkewOption = equalSkewOption;
    }

    public List<PartitionMove> getNextMoves(PartitionRebalancer.ClusterBalanceInfo info, int maxMovesNum) {
        PartitionMove move;
        Preconditions.checkArgument((maxMovesNum >= 0 ? 1 : 0) != 0);
        if (maxMovesNum == 0) {
            maxMovesNum = Integer.MAX_VALUE;
        }
        if (info.partitionInfoBySkew.isEmpty()) {
            NavigableSet keySet = info.beByTotalReplicaCount.keySet();
            LOG.debug((Object)keySet);
            Preconditions.checkState((keySet.isEmpty() || (Long)keySet.last() == 0L ? 1 : 0) != 0, (Object)"non-zero replica count on be while no partition skew information in skewMap");
            return Lists.newArrayList();
        }
        NavigableSet keySet = info.beByTotalReplicaCount.keySet();
        if (keySet.isEmpty() || (Long)keySet.last() == 0L) {
            return Lists.newArrayList();
        }
        ArrayList moves = Lists.newArrayList();
        for (int i = 0; i < maxMovesNum && (move = this.getNextMove(info.beByTotalReplicaCount, info.partitionInfoBySkew)) != null && TwoDimensionalGreedyRebalanceAlgo.applyMove(move, info.beByTotalReplicaCount, info.partitionInfoBySkew); ++i) {
            moves.add(move);
        }
        return moves;
    }

    private PartitionMove getNextMove(TreeMultimap<Long, Long> beByTotalReplicaCount, TreeMultimap<Long, TabletInvertedIndex.PartitionBalanceInfo> skewMap) {
        PartitionMove move = null;
        if (skewMap.isEmpty() || beByTotalReplicaCount.isEmpty()) {
            return null;
        }
        long maxPartitionSkew = (Long)skewMap.keySet().last();
        long maxBeSkew = (Long)beByTotalReplicaCount.keySet().last() - (Long)beByTotalReplicaCount.keySet().first();
        if (maxPartitionSkew == 0L || maxPartitionSkew <= 1L && maxBeSkew <= 1L) {
            return null;
        }
        NavigableSet maxSet = skewMap.get((Object)maxPartitionSkew);
        for (TabletInvertedIndex.PartitionBalanceInfo pbi : maxSet) {
            Long maxLoadedBe;
            Long minLoadedBe;
            Preconditions.checkArgument((!pbi.beByReplicaCount.isEmpty() ? 1 : 0) != 0, (Object)("no information on replicas of partition " + pbi.partitionId + "-" + pbi.indexId));
            Long minReplicaCount = (Long)pbi.beByReplicaCount.keySet().first();
            Long maxReplicaCount = (Long)pbi.beByReplicaCount.keySet().last();
            LOG.debug("balancing partition {}-{} with replica count skew {} (min_replica_count: {}, max_replica_count: {})", (Object)pbi.partitionId, (Object)pbi.indexId, (Object)maxPartitionSkew, (Object)minReplicaCount, (Object)maxReplicaCount);
            IntersectionResult maxLoaded = TwoDimensionalGreedyRebalanceAlgo.getIntersection(ExtremumType.MAX, pbi.beByReplicaCount, beByTotalReplicaCount);
            IntersectionResult minLoaded = TwoDimensionalGreedyRebalanceAlgo.getIntersection(ExtremumType.MIN, pbi.beByReplicaCount, beByTotalReplicaCount);
            LOG.debug("partition-wise: min_count: {}, max_count: {}", (Object)minLoaded.replicaCountPartition, (Object)maxLoaded.replicaCountPartition);
            LOG.debug("cluster-wise: min_count: {}, max_count: {}", (Object)minLoaded.replicaCountTotal, (Object)maxLoaded.replicaCountTotal);
            LOG.debug("min_loaded_intersection: {}, max_loaded_intersection: {}", (Object)minLoaded.intersection.toString(), (Object)maxLoaded.intersection.toString());
            if (maxLoaded.replicaCountPartition <= minLoaded.replicaCountPartition + 1L && (minLoaded.intersection.isEmpty() || maxLoaded.intersection.isEmpty())) continue;
            if (this.equalSkewOption == EqualSkewOption.PICK_FIRST) {
                minLoadedBe = minLoaded.intersection.isEmpty() ? minLoaded.beWithExtremumCount.get(0) : minLoaded.intersection.get(0);
                maxLoadedBe = maxLoaded.intersection.isEmpty() ? maxLoaded.beWithExtremumCount.get(0) : maxLoaded.intersection.get(0);
            } else {
                minLoadedBe = minLoaded.intersection.isEmpty() ? TwoDimensionalGreedyRebalanceAlgo.getRandomListElement(minLoaded.beWithExtremumCount) : TwoDimensionalGreedyRebalanceAlgo.getRandomListElement(minLoaded.intersection);
                maxLoadedBe = maxLoaded.intersection.isEmpty() ? TwoDimensionalGreedyRebalanceAlgo.getRandomListElement(maxLoaded.beWithExtremumCount) : TwoDimensionalGreedyRebalanceAlgo.getRandomListElement(maxLoaded.intersection);
            }
            LOG.debug("min_loaded_be: {}, max_loaded_be: {}", (Object)minLoadedBe, (Object)maxLoadedBe);
            if (minLoadedBe.equals(maxLoadedBe)) continue;
            move = new PartitionMove(pbi.partitionId, pbi.indexId, maxLoadedBe, minLoadedBe);
            break;
        }
        return move;
    }

    public static <T> T getRandomListElement(List<T> items) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        return items.get(rand.nextInt(items.size()));
    }

    public static IntersectionResult getIntersection(ExtremumType extremumType, TreeMultimap<Long, Long> beByReplicaCount, TreeMultimap<Long, Long> beByTotalReplicaCount) {
        Pair<Long, Set<Long>> beSelectedByPartition = TwoDimensionalGreedyRebalanceAlgo.getMinMaxLoadedServers(beByReplicaCount, extremumType);
        Pair<Long, Set<Long>> beSelectedByTotal = TwoDimensionalGreedyRebalanceAlgo.getMinMaxLoadedServers(beByTotalReplicaCount, extremumType);
        Preconditions.checkNotNull(beSelectedByPartition);
        Preconditions.checkNotNull(beSelectedByTotal);
        IntersectionResult res = new IntersectionResult();
        res.replicaCountPartition = (Long)beSelectedByPartition.first;
        res.replicaCountTotal = (Long)beSelectedByTotal.first;
        res.beWithExtremumCount = Lists.newArrayList((Iterable)((Iterable)beSelectedByPartition.second));
        res.intersection = Lists.newArrayList((Iterable)Sets.intersection((Set)((Set)beSelectedByPartition.second), (Set)((Set)beSelectedByTotal.second)));
        return res;
    }

    private static Pair<Long, Set<Long>> getMinMaxLoadedServers(TreeMultimap<Long, Long> multimap, ExtremumType extremumType) {
        if (multimap.isEmpty()) {
            return null;
        }
        Long count = extremumType == ExtremumType.MIN ? (Long)multimap.keySet().first() : (Long)multimap.keySet().last();
        return new Pair<Long, Set<Long>>(count, multimap.get((Object)count));
    }

    public static boolean applyMove(PartitionMove move, TreeMultimap<Long, Long> beByTotalReplicaCount, TreeMultimap<Long, TabletInvertedIndex.PartitionBalanceInfo> skewMap) {
        TwoDimensionalGreedyRebalanceAlgo.moveOneReplica(move.fromBe, move.toBe, beByTotalReplicaCount);
        try {
            TabletInvertedIndex.PartitionBalanceInfo partitionBalanceInfo = null;
            Long skew = -1L;
            for (Long key : skewMap.keySet()) {
                NavigableSet pbiSet = skewMap.get((Object)key);
                List pbis = pbiSet.stream().filter(info -> info.partitionId.equals(move.partitionId) && info.indexId.equals(move.indexId)).collect(Collectors.toList());
                Preconditions.checkState((pbis.size() <= 1 ? 1 : 0) != 0, (Object)"skew map has dup partition info");
                if (pbis.size() != 1) continue;
                partitionBalanceInfo = (TabletInvertedIndex.PartitionBalanceInfo)pbis.get(0);
                skew = key;
                break;
            }
            Preconditions.checkState((skew != -1L ? 1 : 0) != 0, (Object)"partition is not in skew map");
            TabletInvertedIndex.PartitionBalanceInfo newInfo = new TabletInvertedIndex.PartitionBalanceInfo(partitionBalanceInfo);
            TwoDimensionalGreedyRebalanceAlgo.moveOneReplica(move.fromBe, move.toBe, newInfo.beByReplicaCount);
            skewMap.remove((Object)skew, partitionBalanceInfo);
            long min_count = (Long)newInfo.beByReplicaCount.keySet().first();
            long max_count = (Long)newInfo.beByReplicaCount.keySet().last();
            skewMap.put((Object)(max_count - min_count), (Object)newInfo);
        }
        catch (IllegalStateException e) {
            TwoDimensionalGreedyRebalanceAlgo.moveOneReplica(move.toBe, move.fromBe, beByTotalReplicaCount);
            LOG.info("{} apply failed, {}", (Object)move, (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOG.warn("got unexpected exception when apply {}, the skew may be broken. {}", (Object)move, (Object)e.toString());
            throw e;
        }
        return true;
    }

    private static void moveOneReplica(Long fromBe, Long toBe, TreeMultimap<Long, Long> m) throws IllegalStateException {
        boolean foundSrc = false;
        boolean foundDst = false;
        Long countSrc = 0L;
        Long countDst = 0L;
        for (Long key : m.keySet()) {
            NavigableSet values = m.get((Object)key);
            if (values.contains(fromBe)) {
                foundSrc = true;
                countSrc = key;
            }
            if (!values.contains(toBe)) continue;
            foundDst = true;
            countDst = key;
        }
        Preconditions.checkState((boolean)foundSrc, (Object)("fromBe " + fromBe + " is not in the map"));
        Preconditions.checkState((boolean)foundDst, (Object)("toBe " + toBe + " is not in the map"));
        Preconditions.checkState((countSrc > 0L ? 1 : 0) != 0, (Object)"fromBe has no replica in the map, can't move");
        m.remove((Object)countSrc, (Object)fromBe);
        m.remove((Object)countDst, (Object)toBe);
        m.put((Object)(countSrc - 1L), (Object)fromBe);
        m.put((Object)(countDst + 1L), (Object)toBe);
    }

    public static class IntersectionResult {
        Long replicaCountPartition;
        Long replicaCountTotal;
        List<Long> beWithExtremumCount;
        List<Long> intersection;
    }

    public static enum ExtremumType {
        MAX,
        MIN;

    }

    public static enum EqualSkewOption {
        PICK_FIRST,
        PICK_RANDOM;

    }

    public static class PartitionMove {
        Long partitionId;
        Long indexId;
        Long fromBe;
        Long toBe;

        PartitionMove(Long p, Long i, Long f, Long t) {
            this.partitionId = p;
            this.indexId = i;
            this.fromBe = f;
            this.toBe = t;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionMove that = (PartitionMove)o;
            return Objects.equal((Object)this.partitionId, (Object)that.partitionId) && Objects.equal((Object)this.indexId, (Object)that.indexId) && Objects.equal((Object)this.fromBe, (Object)that.fromBe) && Objects.equal((Object)this.toBe, (Object)that.toBe);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.partitionId, this.indexId, this.fromBe, this.toBe});
        }

        public String toString() {
            return "ReplicaMove{pid=" + this.partitionId + "-" + this.indexId + ", from=" + this.fromBe + ", to=" + this.toBe + '}';
        }
    }
}

