/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class TabletSchedulerStat {
    @StatField(value="num of tablet check round")
    public AtomicLong counterTabletCheckRound = new AtomicLong(0L);
    @StatField(value="cost of tablet check(ms)")
    public AtomicLong counterTabletCheckCostMs = new AtomicLong(0L);
    @StatField(value="num of tablet checked in tablet checker")
    public AtomicLong counterTabletChecked = new AtomicLong(0L);
    @StatField(value="num of unhealthy tablet checked in tablet checker")
    public AtomicLong counterUnhealthyTabletNum = new AtomicLong(0L);
    @StatField(value="num of tablet being added to tablet scheduler")
    public AtomicLong counterTabletAddToBeScheduled = new AtomicLong(0L);
    @StatField(value="num of tablet schedule round")
    public AtomicLong counterTabletScheduleRound = new AtomicLong(0L);
    @StatField(value="cost of tablet schedule(ms)")
    public AtomicLong counterTabletScheduleCostMs = new AtomicLong(0L);
    @StatField(value="num of tablet being scheduled")
    public AtomicLong counterTabletScheduled = new AtomicLong(0L);
    @StatField(value="num of tablet being scheduled succeeded")
    public AtomicLong counterTabletScheduledSucceeded = new AtomicLong(0L);
    @StatField(value="num of tablet being scheduled failed")
    public AtomicLong counterTabletScheduledFailed = new AtomicLong(0L);
    @StatField(value="num of tablet being scheduled discard")
    public AtomicLong counterTabletScheduledDiscard = new AtomicLong(0L);
    @StatField(value="num of tablet priority upgraded")
    public AtomicLong counterTabletPrioUpgraded = new AtomicLong(0L);
    @StatField(value="num of tablet priority downgraded")
    public AtomicLong counterTabletPrioDowngraded = new AtomicLong(0L);
    @StatField(value="num of clone task")
    public AtomicLong counterCloneTask = new AtomicLong(0L);
    @StatField(value="num of clone task succeeded")
    public AtomicLong counterCloneTaskSucceeded = new AtomicLong(0L);
    @StatField(value="num of clone task failed")
    public AtomicLong counterCloneTaskFailed = new AtomicLong(0L);
    @StatField(value="num of clone task timeout")
    public AtomicLong counterCloneTaskTimeout = new AtomicLong(0L);
    @StatField(value="num of replica missing error")
    public AtomicLong counterReplicaMissingErr = new AtomicLong(0L);
    @StatField(value="num of replica version missing error")
    public AtomicLong counterReplicaVersionMissingErr = new AtomicLong(0L);
    @StatField(value="num of replica unavailable error")
    public AtomicLong counterReplicaUnavailableErr = new AtomicLong(0L);
    @StatField(value="num of replica redundant error")
    public AtomicLong counterReplicaRedundantErr = new AtomicLong(0L);
    @StatField(value="num of replica missing in cluster error")
    public AtomicLong counterReplicaMissingInClusterErr = new AtomicLong(0L);
    @StatField(value="num of replica missing for tag error")
    public AtomicLong counterReplicaMissingForTagErr = new AtomicLong(0L);
    @StatField(value="num of balance scheduled")
    public AtomicLong counterBalanceSchedule = new AtomicLong(0L);
    @StatField(value="num of colocate replica mismatch")
    public AtomicLong counterReplicaColocateMismatch = new AtomicLong(0L);
    @StatField(value="num of colocate replica redundant")
    public AtomicLong counterReplicaColocateRedundant = new AtomicLong(0L);
    private TabletSchedulerStat lastSnapshot = null;

    private void snapshot() {
        this.lastSnapshot = new TabletSchedulerStat();
        try {
            Field[] fields;
            Class<?> clazz = Class.forName(this.getClass().getName());
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(StatField.class)) continue;
                ((AtomicLong)field.get(this.lastSnapshot)).set(((AtomicLong)field.get(this)).get());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            this.lastSnapshot = null;
        }
    }

    public TabletSchedulerStat getLastSnapshot() {
        return this.lastSnapshot;
    }

    public List<List<String>> getBrief() {
        ArrayList result = Lists.newArrayList();
        try {
            Field[] fields;
            Class<?> clazz = Class.forName(this.getClass().getName());
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(StatField.class)) continue;
                ArrayList info = Lists.newArrayList();
                info.add(field.getAnnotation(StatField.class).value());
                info.add(String.valueOf(((AtomicLong)field.get(this)).get()));
                result.add(info);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
        return result;
    }

    public String incrementalBrief() {
        StringBuilder sb = new StringBuilder("TStat :\n");
        try {
            Field[] fields;
            Class<?> clazz = Class.forName(this.getClass().getName());
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(StatField.class)) continue;
                long current = ((AtomicLong)field.get(this)).get();
                long last = this.lastSnapshot == null ? 0L : ((AtomicLong)field.get(this.lastSnapshot)).get();
                sb.append(field.getAnnotation(StatField.class).prefix()).append(" ");
                sb.append(field.getAnnotation(StatField.class).value()).append(": ");
                sb.append(current).append(" (+").append(current - last).append(")\n");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return "";
        }
        this.snapshot();
        return sb.toString();
    }

    public static void main(String[] args) {
        TabletSchedulerStat stat = new TabletSchedulerStat();
        stat.counterCloneTask.addAndGet(300L);
        System.out.println(stat.incrementalBrief());
        stat.counterCloneTask.addAndGet(3L);
        stat.counterTabletChecked.incrementAndGet();
        System.out.println(stat.incrementalBrief());
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StatField {
        public String value() default "";

        public String prefix() default "TStat";
    }
}

