/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.clone.SchedException;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.clone.TabletSchedulerStat;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.CloneTask;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TFinishTaskRequest;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TTabletInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabletSchedCtx
implements Comparable<TabletSchedCtx> {
    private static final Logger LOG = LogManager.getLogger(TabletSchedCtx.class);
    private static final int SCHED_FAILED_COUNTER_THRESHOLD = 5;
    private static final long MIN_ADJUST_PRIORITY_INTERVAL_MS = 300000L;
    private static final long MAX_NOT_BEING_SCHEDULED_INTERVAL_MS = 1800000L;
    private static final long MIN_CLONE_SPEED_MB_PER_SECOND = 1L;
    private static final int RUNNING_FAILED_COUNTER_THRESHOLD = 3;
    private static VersionCountComparator VERSION_COUNTER_COMPARATOR = new VersionCountComparator();
    private Type type;
    private Priority origPriority;
    private Priority dynamicPriority;
    private int failedSchedCounter = 0;
    private int failedRunningCounter = 0;
    private long lastSchedTime = 0L;
    private long lastAdjustPrioTime = 0L;
    private long lastVisitedTime = -1L;
    private long taskTimeoutMs = 0L;
    private State state;
    private Tablet.TabletStatus tabletStatus;
    private String cluster;
    private long dbId;
    private long tblId;
    private long partitionId;
    private long indexId;
    private long tabletId;
    private int schemaHash;
    private TStorageMedium storageMedium;
    private long createTime = -1L;
    private long finishedTime = -1L;
    private Tablet tablet = null;
    private long visibleVersion = -1L;
    private long committedVersion = -1L;
    private Replica srcReplica = null;
    private long srcPathHash = -1L;
    private long destBackendId = -1L;
    private long destPathHash = -1L;
    private String errMsg = null;
    private CloneTask cloneTask = null;
    private long copySize = 0L;
    private long copyTimeMs = 0L;
    private Set<Long> colocateBackendsSet = null;
    private int tabletOrderIdx = -1;
    private SystemInfoService infoService;
    private ReplicaAllocation replicaAlloc;
    private Tag tag;

    public TabletSchedCtx(Type type, String cluster, long dbId, long tblId, long partId, long idxId, long tabletId, ReplicaAllocation replicaAlloc, long createTime) {
        this.type = type;
        this.cluster = cluster;
        this.dbId = dbId;
        this.tblId = tblId;
        this.partitionId = partId;
        this.indexId = idxId;
        this.tabletId = tabletId;
        this.createTime = createTime;
        this.infoService = Catalog.getCurrentSystemInfo();
        this.state = State.PENDING;
        this.replicaAlloc = replicaAlloc;
    }

    public ReplicaAllocation getReplicaAlloc() {
        return this.replicaAlloc;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Priority getOrigPriority() {
        return this.origPriority;
    }

    public void setOrigPriority(Priority origPriority) {
        this.origPriority = origPriority;
        this.dynamicPriority = origPriority;
        this.failedSchedCounter = 0;
        this.lastSchedTime = 0L;
        this.lastAdjustPrioTime = 0L;
    }

    public Priority getDynamicPriority() {
        return this.dynamicPriority;
    }

    public void increaseFailedSchedCounter() {
        ++this.failedSchedCounter;
    }

    public int getFailedSchedCounter() {
        return this.failedSchedCounter;
    }

    public void increaseFailedRunningCounter() {
        ++this.failedRunningCounter;
    }

    public int getFailedRunningCounter() {
        return this.failedRunningCounter;
    }

    public void setLastSchedTime(long lastSchedTime) {
        this.lastSchedTime = lastSchedTime;
    }

    public void setLastVisitedTime(long lastVisitedTime) {
        this.lastVisitedTime = lastVisitedTime;
    }

    public void setFinishedTime(long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setTabletStatus(Tablet.TabletStatus tabletStatus) {
        this.tabletStatus = tabletStatus;
    }

    public Tablet.TabletStatus getTabletStatus() {
        return this.tabletStatus;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTblId() {
        return this.tblId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public void setSchemaHash(int schemaHash) {
        this.schemaHash = schemaHash;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public void setStorageMedium(TStorageMedium storageMedium) {
        this.storageMedium = storageMedium;
    }

    public TStorageMedium getStorageMedium() {
        return this.storageMedium;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getCommittedVersion() {
        return this.visibleVersion;
    }

    public void setTablet(Tablet tablet) {
        this.tablet = tablet;
    }

    public Tablet getTablet() {
        return this.tablet;
    }

    public List<Replica> getReplicas() {
        return this.tablet.getReplicas();
    }

    public void setVersionInfo(long visibleVersion, long committedVersion) {
        this.visibleVersion = visibleVersion;
        this.committedVersion = committedVersion;
    }

    public void setDest(Long destBeId, long destPathHash) {
        this.destBackendId = destBeId;
        this.destPathHash = destPathHash;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public CloneTask getCloneTask() {
        return this.cloneTask;
    }

    public long getCopySize() {
        return this.copySize;
    }

    public long getCopyTimeMs() {
        return this.copyTimeMs;
    }

    public long getSrcBackendId() {
        if (this.srcReplica != null) {
            return this.srcReplica.getBackendId();
        }
        return -1L;
    }

    public long getSrcPathHash() {
        return this.srcPathHash;
    }

    public void setSrc(Replica srcReplica) {
        this.srcReplica = srcReplica;
        this.srcPathHash = srcReplica.getPathHash();
    }

    public long getDestBackendId() {
        return this.destBackendId;
    }

    public long getDestPathHash() {
        return this.destPathHash;
    }

    public long getTabletSize() {
        long max = Long.MIN_VALUE;
        for (Replica replica : this.tablet.getReplicas()) {
            if (replica.getDataSize() <= max) continue;
            max = replica.getDataSize();
        }
        return max;
    }

    public boolean containsBE(long beId) {
        Backend backend = this.infoService.getBackend(beId);
        if (backend == null) {
            return true;
        }
        String host = backend.getHost();
        for (Replica replica : this.tablet.getReplicas()) {
            Backend be = this.infoService.getBackend(replica.getBackendId());
            if (be == null) continue;
            if (host.equals(be.getHost())) {
                return true;
            }
            if (replica.getBackendId() != beId) continue;
            return true;
        }
        return false;
    }

    public void setColocateGroupBackendIds(Set<Long> backendsSet) {
        this.colocateBackendsSet = backendsSet;
    }

    public Set<Long> getColocateBackendsSet() {
        return this.colocateBackendsSet;
    }

    public void setTabletOrderIdx(int idx) {
        this.tabletOrderIdx = idx;
    }

    public int getTabletOrderIdx() {
        return this.tabletOrderIdx;
    }

    public boolean compactionRecovered() {
        Replica chosenReplica = null;
        long maxVersionCount = -1L;
        long minVersionCount = Integer.MAX_VALUE;
        for (Replica replica : this.tablet.getReplicas()) {
            if (replica.getVersionCount() > maxVersionCount) {
                maxVersionCount = replica.getVersionCount();
                chosenReplica = replica;
            }
            if (replica.getVersionCount() >= minVersionCount) continue;
            minVersionCount = replica.getVersionCount();
        }
        boolean recovered = false;
        for (Replica replica : this.tablet.getReplicas()) {
            if (!replica.isAlive() || !replica.tooSlow() || chosenReplica.equals(replica)) continue;
            chosenReplica.setState(Replica.ReplicaState.NORMAL);
            recovered = true;
        }
        return recovered;
    }

    public void chooseSrcReplica(Map<Long, TabletScheduler.PathSlot> backendsWorkingSlots, long exceptBeId) throws SchedException {
        ArrayList candidates = Lists.newArrayList();
        for (Replica replica : this.tablet.getReplicas()) {
            Backend be;
            if (exceptBeId != -1L && replica.getBackendId() == exceptBeId || replica.isBad() || replica.tooSlow() || (be = this.infoService.getBackend(replica.getBackendId())) == null || !be.isAlive() || replica.getLastFailedVersion() > 0L || !replica.checkVersionCatchUp(this.visibleVersion, false)) continue;
            candidates.add(replica);
        }
        if (candidates.isEmpty()) {
            throw new SchedException(SchedException.Status.UNRECOVERABLE, "unable to find source replica");
        }
        Collections.sort(candidates, VERSION_COUNTER_COMPARATOR);
        for (Replica srcReplica : candidates) {
            long srcPathHash;
            TabletScheduler.PathSlot slot = backendsWorkingSlots.get(srcReplica.getBackendId());
            if (slot == null || (srcPathHash = slot.takeSlot(srcReplica.getPathHash())) == -1L) continue;
            this.setSrc(srcReplica);
            return;
        }
        throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "unable to find source slot");
    }

    public void chooseSrcReplicaForVersionIncomplete(Map<Long, TabletScheduler.PathSlot> backendsWorkingSlots) throws SchedException {
        this.chooseSrcReplica(backendsWorkingSlots, this.destBackendId);
        Preconditions.checkState((this.srcReplica.getBackendId() != this.destBackendId ? 1 : 0) != 0, (Object)("wrong be id: " + this.destBackendId));
    }

    public void chooseDestReplicaForVersionIncomplete(Map<Long, TabletScheduler.PathSlot> backendsWorkingSlots) throws SchedException {
        Replica chosenReplica = null;
        for (Replica replica : this.tablet.getReplicas()) {
            Backend be;
            if (replica.isBad() || (be = this.infoService.getBackend(replica.getBackendId())) == null || !be.isScheduleAvailable() || replica.getLastFailedVersion() <= 0L && (replica.getVersion() == this.visibleVersion || replica.getVersion() > this.visibleVersion) && replica.getState() != Replica.ReplicaState.DECOMMISSION) continue;
            if (replica.needFurtherRepair()) {
                chosenReplica = replica;
                break;
            }
            if (chosenReplica == null) {
                chosenReplica = replica;
                continue;
            }
            if (replica.getLastSuccessVersion() > replica.getLastFailedVersion()) {
                chosenReplica = replica;
                break;
            }
            if (replica.getLastFailedVersion() >= chosenReplica.getLastFailedVersion()) continue;
            chosenReplica = replica;
        }
        if (chosenReplica == null) {
            throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "unable to choose dest replica");
        }
        TabletScheduler.PathSlot slot = backendsWorkingSlots.get(chosenReplica.getBackendId());
        if (slot == null) {
            throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "backend of dest replica is missing");
        }
        long destPathHash = slot.takeSlot(chosenReplica.getPathHash());
        if (destPathHash == -1L) {
            throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "unable to take slot of dest path");
        }
        if (chosenReplica.getState() == Replica.ReplicaState.DECOMMISSION) {
            chosenReplica.setWatermarkTxnId(-1L);
            chosenReplica.setState(Replica.ReplicaState.NORMAL);
            LOG.info("choose replica {} on backend {} of tablet {} as dest replica for version incomplete, and change state from DECOMMISSION to NORMAL", (Object)chosenReplica.getId(), (Object)chosenReplica.getBackendId(), (Object)this.tabletId);
        }
        this.setDest(chosenReplica.getBackendId(), chosenReplica.getPathHash());
    }

    public void releaseResource(TabletScheduler tabletScheduler) {
        this.releaseResource(tabletScheduler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResource(TabletScheduler tabletScheduler, boolean reserveTablet) {
        TabletScheduler.PathSlot slot;
        if (this.srcReplica != null) {
            Preconditions.checkState((this.srcPathHash != -1L ? 1 : 0) != 0);
            slot = tabletScheduler.getBackendsWorkingSlots().get(this.srcReplica.getBackendId());
            if (slot != null) {
                if (this.type == Type.REPAIR) {
                    slot.freeSlot(this.srcPathHash);
                } else {
                    slot.freeBalanceSlot(this.srcPathHash);
                }
            }
        }
        if (this.destPathHash != -1L && (slot = tabletScheduler.getBackendsWorkingSlots().get(this.destBackendId)) != null) {
            if (this.type == Type.REPAIR) {
                slot.freeSlot(this.destPathHash);
            } else {
                slot.freeBalanceSlot(this.destPathHash);
            }
        }
        if (this.cloneTask != null) {
            Table table;
            AgentTaskQueue.removeTask(this.cloneTask.getBackendId(), TTaskType.CLONE, this.cloneTask.getSignature());
            Database db = Catalog.getCurrentCatalog().getDbNullable(this.dbId);
            if (db != null && (table = db.getTableNullable(this.tblId)) != null && table.writeLockIfExist()) {
                try {
                    ArrayList cloneReplicas = Lists.newArrayList();
                    this.tablet.getReplicas().stream().filter(r -> r.getState() == Replica.ReplicaState.CLONE).forEach(r -> cloneReplicas.add(r));
                    for (Replica cloneReplica : cloneReplicas) {
                        this.tablet.deleteReplica(cloneReplica);
                    }
                }
                finally {
                    table.writeUnlock();
                }
            }
        }
        this.reset(reserveTablet);
    }

    private void reset(boolean reserveTablet) {
        if (this.state == State.PENDING) {
            if (!reserveTablet) {
                this.tablet = null;
            }
            this.srcReplica = null;
            this.srcPathHash = -1L;
            this.destBackendId = -1L;
            this.destPathHash = -1L;
            this.cloneTask = null;
        }
    }

    public void deleteReplica(Replica replica) {
        this.tablet.deleteReplicaByBackendId(replica.getBackendId());
    }

    public CloneTask createCloneReplicaAndTask() throws SchedException {
        Backend srcBe = this.infoService.getBackend(this.srcReplica.getBackendId());
        if (srcBe == null) {
            throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "src backend " + this.srcReplica.getBackendId() + " does not exist");
        }
        Backend destBe = this.infoService.getBackend(this.destBackendId);
        if (destBe == null) {
            throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "dest backend " + this.srcReplica.getBackendId() + " does not exist");
        }
        this.taskTimeoutMs = this.getApproximateTimeoutMs();
        TBackend tSrcBe = new TBackend(srcBe.getHost(), srcBe.getBePort(), srcBe.getHttpPort());
        this.cloneTask = new CloneTask(this.destBackendId, this.dbId, this.tblId, this.partitionId, this.indexId, this.tabletId, this.schemaHash, Lists.newArrayList((Object[])new TBackend[]{tSrcBe}), this.storageMedium, this.visibleVersion, (int)(this.taskTimeoutMs / 1000L));
        this.cloneTask.setPathHash(this.srcPathHash, this.destPathHash);
        if (this.tabletStatus == Tablet.TabletStatus.REPLICA_MISSING || this.tabletStatus == Tablet.TabletStatus.REPLICA_MISSING_IN_CLUSTER || this.tabletStatus == Tablet.TabletStatus.REPLICA_RELOCATING || this.type == Type.BALANCE || this.tabletStatus == Tablet.TabletStatus.COLOCATE_MISMATCH || this.tabletStatus == Tablet.TabletStatus.REPLICA_MISSING_FOR_TAG) {
            Replica cloneReplica = new Replica(Catalog.getCurrentCatalog().getNextId(), this.destBackendId, -1L, this.schemaHash, -1L, -1L, Replica.ReplicaState.CLONE, this.committedVersion, -1L);
            this.tablet.addReplica(cloneReplica);
        } else if (this.tabletStatus == Tablet.TabletStatus.VERSION_INCOMPLETE) {
            Preconditions.checkState((this.type == Type.REPAIR ? 1 : 0) != 0, (Object)((Object)this.type));
            Replica replica = this.tablet.getReplicaByBackendId(this.destBackendId);
            if (replica == null) {
                throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "dest replica does not exist on BE " + this.destBackendId);
            }
            if (replica.getPathHash() != this.destPathHash) {
                throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "dest replica's path hash is changed. current: " + replica.getPathHash() + ", scheduled: " + this.destPathHash);
            }
        }
        this.state = State.RUNNING;
        return this.cloneTask;
    }

    private long getApproximateTimeoutMs() {
        long tabletSize = this.getTabletSize();
        long timeoutMs = tabletSize / 1024L / 1024L / 1L * 1000L;
        timeoutMs = Math.max(timeoutMs, Config.min_clone_task_timeout_sec * 1000L);
        timeoutMs = Math.min(timeoutMs, Config.max_clone_task_timeout_sec * 1000L);
        return timeoutMs;
    }

    public void finishCloneTask(CloneTask cloneTask, TFinishTaskRequest request) throws SchedException {
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (Object)((Object)this.state));
        Preconditions.checkArgument((cloneTask.getTaskVersion() == 2 ? 1 : 0) != 0);
        this.setLastVisitedTime(System.currentTimeMillis());
        if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
            throw new SchedException(SchedException.Status.RUNNING_FAILED, (String)request.getTaskStatus().getErrorMsgs().get(0));
        }
        if (!request.isSetFinishTabletInfos() || request.getFinishTabletInfos().isEmpty()) {
            throw new SchedException(SchedException.Status.RUNNING_FAILED, "tablet info is not set in task report request");
        }
        if (this.dbId != cloneTask.getDbId() || this.tblId != cloneTask.getTableId() || this.partitionId != cloneTask.getPartitionId() || this.indexId != cloneTask.getIndexId() || this.tabletId != cloneTask.getTabletId() || this.destBackendId != cloneTask.getBackendId()) {
            String msg = String.format("clone task does not match the tablet info. clone task %d-%d-%d-%d-%d-%d, tablet info: %d-%d-%d-%d-%d-%d", cloneTask.getDbId(), cloneTask.getTableId(), cloneTask.getPartitionId(), cloneTask.getIndexId(), cloneTask.getTabletId(), cloneTask.getBackendId(), this.dbId, this.tblId, this.partitionId, this.indexId, this.tablet.getId(), this.destBackendId);
            throw new SchedException(SchedException.Status.RUNNING_FAILED, msg);
        }
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new SchedException(SchedException.Status.UNRECOVERABLE, "db " + this.dbId + " does not exist"));
        OlapTable olapTable = (OlapTable)db.getTableOrException(this.tblId, s -> new SchedException(SchedException.Status.UNRECOVERABLE, "tbl " + this.tabletId + " does not exist"));
        olapTable.writeLockOrException(new SchedException(SchedException.Status.UNRECOVERABLE, "table " + olapTable.getName() + " does not exist"));
        try {
            Partition partition = olapTable.getPartition(this.partitionId);
            if (partition == null) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, "partition does not exist");
            }
            MaterializedIndex index = partition.getIndex(this.indexId);
            if (index == null) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, "index does not exist");
            }
            if (this.schemaHash != olapTable.getSchemaHashByIndexId(this.indexId)) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, "schema hash is not consistent. index's: " + olapTable.getSchemaHashByIndexId(this.indexId) + ", task's: " + this.schemaHash);
            }
            Tablet tablet = index.getTablet(this.tabletId);
            if (tablet == null) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, "tablet does not exist");
            }
            List<Long> aliveBeIdsInCluster = this.infoService.getClusterBackendIds(db.getClusterName(), true);
            ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(this.partitionId);
            Pair<Tablet.TabletStatus, Priority> pair = tablet.getHealthStatusWithPriority(this.infoService, db.getClusterName(), this.visibleVersion, replicaAlloc, aliveBeIdsInCluster);
            if (pair.first == Tablet.TabletStatus.HEALTHY) {
                throw new SchedException(SchedException.Status.FINISHED, "tablet is healthy");
            }
            TTabletInfo reportedTablet = (TTabletInfo)request.getFinishTabletInfos().get(0);
            if (reportedTablet.getVersion() < this.visibleVersion) {
                String msg = String.format("the clone replica's version is stale. %d, task visible version: %d", reportedTablet.getVersion(), this.visibleVersion);
                throw new SchedException(SchedException.Status.RUNNING_FAILED, msg);
            }
            Replica replica = tablet.getReplicaByBackendId(this.destBackendId);
            if (replica == null) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, "replica does not exist. backend id: " + this.destBackendId);
            }
            replica.updateVersionInfo(reportedTablet.getVersion(), reportedTablet.getDataSize(), reportedTablet.getRowCount());
            if (reportedTablet.isSetPathHash()) {
                replica.setPathHash(reportedTablet.getPathHash());
            }
            if (this.type == Type.BALANCE) {
                long partitionVisibleVersion = partition.getVisibleVersion();
                if (replica.getVersion() < partitionVisibleVersion) {
                    replica.setNeedFurtherRepair(true);
                }
            } else {
                replica.setNeedFurtherRepair(false);
            }
            ReplicaPersistInfo info = ReplicaPersistInfo.createForClone(this.dbId, this.tblId, this.partitionId, this.indexId, this.tabletId, this.destBackendId, replica.getId(), reportedTablet.getVersion(), reportedTablet.getSchemaHash(), reportedTablet.getDataSize(), reportedTablet.getRowCount(), replica.getLastFailedVersion(), replica.getLastSuccessVersion());
            if (replica.getState() == Replica.ReplicaState.CLONE) {
                replica.setState(Replica.ReplicaState.NORMAL);
                Catalog.getCurrentCatalog().getEditLog().logAddReplica(info);
            } else {
                Catalog.getCurrentCatalog().getEditLog().logUpdateReplica(info);
            }
            this.state = State.FINISHED;
            LOG.info("clone finished: {}", (Object)this);
        }
        catch (SchedException e) {
            ++this.failedRunningCounter;
            if (this.failedRunningCounter > 3) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, e.getMessage());
            }
            throw e;
        }
        finally {
            olapTable.writeUnlock();
        }
        if (request.isSetCopySize()) {
            this.copySize = request.getCopySize();
        }
        if (request.isSetCopyTimeMs()) {
            this.copyTimeMs = request.getCopyTimeMs();
        }
    }

    public boolean adjustPriority(TabletSchedulerStat stat) {
        long currentTime = System.currentTimeMillis();
        if (this.lastAdjustPrioTime == 0L) {
            this.lastAdjustPrioTime = currentTime;
            return false;
        }
        if (currentTime - this.lastAdjustPrioTime < 300000L) {
            return false;
        }
        boolean isDowngrade = false;
        boolean isUpgrade = false;
        if (this.failedSchedCounter > 5) {
            isDowngrade = true;
        } else {
            long lastTime;
            long l = lastTime = this.lastSchedTime == 0L ? this.createTime : this.lastSchedTime;
            if (currentTime - lastTime > 1800000L) {
                isUpgrade = true;
            }
        }
        Priority originDynamicPriority = this.dynamicPriority;
        if (isDowngrade) {
            this.dynamicPriority = this.dynamicPriority.adjust(this.origPriority, false);
            this.failedSchedCounter = 0;
            if (originDynamicPriority != this.dynamicPriority) {
                LOG.debug("downgrade dynamic priority from {} to {}, origin: {}, tablet: {}", (Object)originDynamicPriority.name(), (Object)this.dynamicPriority.name(), (Object)this.origPriority.name(), (Object)this.tabletId);
                stat.counterTabletPrioDowngraded.incrementAndGet();
                return true;
            }
        } else if (isUpgrade) {
            this.dynamicPriority = this.dynamicPriority.adjust(this.origPriority, true);
            if (originDynamicPriority != this.dynamicPriority) {
                LOG.debug("upgrade dynamic priority from {} to {}, origin: {}, tablet: {}", (Object)originDynamicPriority.name(), (Object)this.dynamicPriority.name(), (Object)this.origPriority.name(), (Object)this.tabletId);
                stat.counterTabletPrioUpgraded.incrementAndGet();
                return true;
            }
        }
        return false;
    }

    public boolean isTimeout() {
        if (this.state != State.RUNNING) {
            return false;
        }
        Preconditions.checkState((this.lastSchedTime != 0L && this.taskTimeoutMs != 0L ? 1 : 0) != 0, (Object)(this.lastSchedTime + "-" + this.taskTimeoutMs));
        return System.currentTimeMillis() - this.lastSchedTime > this.taskTimeoutMs;
    }

    public List<String> getBrief() {
        ArrayList result = Lists.newArrayList();
        result.add(String.valueOf(this.tabletId));
        result.add(this.type.name());
        result.add(this.storageMedium == null ? FeConstants.null_string : this.storageMedium.name());
        result.add(this.tabletStatus == null ? FeConstants.null_string : this.tabletStatus.name());
        result.add(this.state.name());
        result.add(this.origPriority.name());
        result.add(this.dynamicPriority.name());
        result.add(this.srcReplica == null ? "-1" : String.valueOf(this.srcReplica.getBackendId()));
        result.add(String.valueOf(this.srcPathHash));
        result.add(String.valueOf(this.destBackendId));
        result.add(String.valueOf(this.destPathHash));
        result.add(String.valueOf(this.taskTimeoutMs));
        result.add(TimeUtils.longToTimeString(this.createTime));
        result.add(TimeUtils.longToTimeString(this.lastSchedTime));
        result.add(TimeUtils.longToTimeString(this.lastVisitedTime));
        result.add(TimeUtils.longToTimeString(this.finishedTime));
        result.add(this.copyTimeMs > 0L ? String.valueOf((double)(this.copySize / this.copyTimeMs) / 1000.0) : FeConstants.null_string);
        result.add(String.valueOf(this.failedSchedCounter));
        result.add(String.valueOf(this.failedRunningCounter));
        result.add(TimeUtils.longToTimeString(this.lastAdjustPrioTime));
        result.add(String.valueOf(this.visibleVersion));
        result.add(String.valueOf(this.committedVersion));
        result.add(Strings.nullToEmpty((String)this.errMsg));
        return result;
    }

    @Override
    public int compareTo(TabletSchedCtx o) {
        if (this.dynamicPriority.ordinal() < o.dynamicPriority.ordinal()) {
            return 1;
        }
        if (this.dynamicPriority.ordinal() > o.dynamicPriority.ordinal()) {
            return -1;
        }
        if (this.lastVisitedTime < o.lastVisitedTime) {
            return -1;
        }
        if (this.lastVisitedTime > o.lastVisitedTime) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tablet id: ").append(this.tabletId).append(", status: ").append(this.tabletStatus.name());
        sb.append(", state: ").append(this.state.name()).append(", type: ").append(this.type.name());
        if (this.srcReplica != null) {
            sb.append(". from backend: ").append(this.srcReplica.getBackendId());
            sb.append(", src path hash: ").append(this.srcPathHash);
        }
        if (this.destPathHash != -1L) {
            sb.append(". to backend: ").append(this.destBackendId);
            sb.append(", dest path hash: ").append(this.destPathHash);
        }
        sb.append(", visible version: ").append(this.visibleVersion);
        sb.append(", committed version: ").append(this.committedVersion);
        if (this.errMsg != null) {
            sb.append(". err: ").append(this.errMsg);
        }
        return sb.toString();
    }

    public void resetReplicaState() {
        if (this.tablet != null) {
            for (Replica replica : this.tablet.getReplicas()) {
                if (replica.getState() != Replica.ReplicaState.DECOMMISSION) continue;
                replica.setState(Replica.ReplicaState.NORMAL);
                replica.setWatermarkTxnId(-1L);
                LOG.debug("reset replica {} on backend {} of tablet {} state from DECOMMISSION to NORMAL", (Object)replica.getId(), (Object)replica.getBackendId(), (Object)this.tabletId);
            }
        }
    }

    public static class VersionCountComparator
    implements Comparator<Replica> {
        @Override
        public int compare(Replica r1, Replica r2) {
            long verCount2;
            long verCount1 = r1.getVersionCount() == -1L ? Long.MAX_VALUE : r1.getVersionCount();
            long l = verCount2 = r2.getVersionCount() == -1L ? Long.MAX_VALUE : r2.getVersionCount();
            if (verCount1 < verCount2) {
                return -1;
            }
            if (verCount1 > verCount2) {
                return 1;
            }
            return 0;
        }
    }

    public static enum State {
        PENDING,
        RUNNING,
        FINISHED,
        CANCELLED,
        TIMEOUT,
        UNEXPECTED;

    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        VERY_HIGH;


        public Priority adjust(Priority origPriority, boolean isUp) {
            switch (this) {
                case VERY_HIGH: {
                    return isUp ? VERY_HIGH : HIGH;
                }
                case HIGH: {
                    return isUp ? (origPriority == LOW ? HIGH : VERY_HIGH) : NORMAL;
                }
                case NORMAL: {
                    return isUp ? HIGH : (origPriority == VERY_HIGH ? NORMAL : LOW);
                }
            }
            return isUp ? NORMAL : LOW;
        }
    }

    public static enum Type {
        BALANCE,
        REPAIR;

    }
}

