/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.doris.analysis.AdminCancelRepairTableStmt;
import org.apache.doris.analysis.AdminRepairTableStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.clone.TabletSchedulerStat;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.metric.GaugeMetric;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricLabel;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabletChecker
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(TabletChecker.class);
    private Catalog catalog;
    private SystemInfoService infoService;
    private TabletScheduler tabletScheduler;
    private TabletSchedulerStat stat;
    HashMap<String, AtomicLong> tabletCountByStatus = new HashMap<String, AtomicLong>(){
        {
            this.put("total", new AtomicLong(0L));
            this.put("unhealthy", new AtomicLong(0L));
            this.put("added", new AtomicLong(0L));
            this.put("in_sched", new AtomicLong(0L));
            this.put("not_ready", new AtomicLong(0L));
        }
    };
    private com.google.common.collect.Table<Long, Long, Set<PrioPart>> prios = HashBasedTable.create();

    public TabletChecker(Catalog catalog, SystemInfoService infoService, TabletScheduler tabletScheduler, TabletSchedulerStat stat) {
        super("tablet checker", FeConstants.tablet_checker_interval_ms);
        this.catalog = catalog;
        this.infoService = infoService;
        this.tabletScheduler = tabletScheduler;
        this.stat = stat;
        this.initMetrics();
    }

    private void initMetrics() {
        for (final String status : this.tabletCountByStatus.keySet()) {
            GaugeMetric<Long> gauge = new GaugeMetric<Long>("tablet_status_count", Metric.MetricUnit.NOUNIT, "tablet count on different status"){

                @Override
                public Long getValue() {
                    return TabletChecker.this.tabletCountByStatus.get(status).get();
                }
            };
            gauge.addLabel(new MetricLabel("type", status));
            MetricRepo.PALO_METRIC_REGISTER.addPaloMetrics(gauge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPrios(RepairTabletInfo repairTabletInfo, long timeoutMs) {
        Preconditions.checkArgument((!repairTabletInfo.partIds.isEmpty() ? 1 : 0) != 0);
        long currentTime = System.currentTimeMillis();
        com.google.common.collect.Table<Long, Long, Set<PrioPart>> table = this.prios;
        synchronized (table) {
            Set parts = (Set)this.prios.get((Object)repairTabletInfo.dbId, (Object)repairTabletInfo.tblId);
            if (parts == null) {
                parts = Sets.newHashSet();
                this.prios.put((Object)repairTabletInfo.dbId, (Object)repairTabletInfo.tblId, (Object)parts);
            }
            for (long partId : repairTabletInfo.partIds) {
                PrioPart prioPart = new PrioPart(partId, currentTime, timeoutMs);
                parts.add(prioPart);
            }
        }
        this.tabletScheduler.changeTabletsPriorityToVeryHigh(repairTabletInfo.dbId, repairTabletInfo.tblId, repairTabletInfo.partIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePrios(RepairTabletInfo repairTabletInfo) {
        Preconditions.checkArgument((!repairTabletInfo.partIds.isEmpty() ? 1 : 0) != 0);
        com.google.common.collect.Table<Long, Long, Set<PrioPart>> table = this.prios;
        synchronized (table) {
            Map tblMap = this.prios.row((Object)repairTabletInfo.dbId);
            if (tblMap == null) {
                return;
            }
            Set parts = (Set)tblMap.get(repairTabletInfo.tblId);
            if (parts == null) {
                return;
            }
            for (long partId : repairTabletInfo.partIds) {
                parts.remove(new PrioPart(partId, -1L, -1L));
            }
            if (parts.isEmpty()) {
                tblMap.remove(repairTabletInfo.tblId);
            }
        }
    }

    @Override
    protected void runAfterCatalogReady() {
        int pendingNum = this.tabletScheduler.getPendingNum();
        int runningNum = this.tabletScheduler.getRunningNum();
        if (pendingNum > Config.max_scheduling_tablets || runningNum > Config.max_scheduling_tablets) {
            LOG.info("too many tablets are being scheduled. pending: {}, running: {}, limit: {}. skip check", (Object)pendingNum, (Object)runningNum, (Object)Config.max_scheduling_tablets);
            return;
        }
        this.checkTablets();
        this.removePriosIfNecessary();
        this.stat.counterTabletCheckRound.incrementAndGet();
        LOG.debug(this.stat.incrementalBrief());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTablets() {
        Database db;
        HashBasedTable copiedPrios;
        long start = System.currentTimeMillis();
        CheckerCounter counter = new CheckerCounter();
        Object object = this.prios;
        synchronized (object) {
            copiedPrios = HashBasedTable.create(this.prios);
        }
        object = copiedPrios.rowKeySet().iterator();
        block11: while (object.hasNext()) {
            long dbId = (Long)object.next();
            db = this.catalog.getDbNullable(dbId);
            if (db == null) continue;
            List<Long> aliveBeIdsInCluster = this.infoService.getClusterBackendIds(db.getClusterName(), true);
            Map tblPartMap = copiedPrios.row((Object)dbId);
            Iterator<Object> iterator = tblPartMap.keySet().iterator();
            while (iterator.hasNext()) {
                long tblId = (Long)iterator.next();
                OlapTable tbl = (OlapTable)db.getTableNullable(tblId);
                if (tbl == null) continue;
                tbl.readLock();
                try {
                    if (!tbl.needSchedule()) continue;
                    for (Partition partition : tbl.getAllPartitions()) {
                        LoopControlStatus st = this.handlePartitionTablet(db, tbl, partition, true, aliveBeIdsInCluster, start, counter);
                        if (st != LoopControlStatus.BREAK_OUT) continue;
                        break block11;
                    }
                }
                finally {
                    tbl.readUnlock();
                }
            }
        }
        List<Long> dbIds = this.catalog.getDbIds();
        block14: for (Long dbId : dbIds) {
            db = this.catalog.getDbNullable(dbId);
            if (db == null || db.isInfoSchemaDb()) continue;
            List<Table> tableList = db.getTables();
            List<Long> aliveBeIdsInCluster = this.infoService.getClusterBackendIds(db.getClusterName(), true);
            for (Table table : tableList) {
                table.readLock();
                try {
                    if (!table.needSchedule()) continue;
                    OlapTable tbl = (OlapTable)table;
                    for (Partition partition : tbl.getAllPartitions()) {
                        LoopControlStatus st;
                        if (this.isInPrios(db.getId(), tbl.getId(), partition.getId()) || (st = this.handlePartitionTablet(db, tbl, partition, false, aliveBeIdsInCluster, start, counter)) != LoopControlStatus.BREAK_OUT) continue;
                        break block14;
                    }
                }
                finally {
                    table.readUnlock();
                }
            }
        }
        long cost = System.currentTimeMillis() - start;
        this.stat.counterTabletCheckCostMs.addAndGet(cost);
        this.stat.counterTabletChecked.addAndGet(counter.totalTabletNum);
        this.stat.counterUnhealthyTabletNum.addAndGet(counter.unhealthyTabletNum);
        this.stat.counterTabletAddToBeScheduled.addAndGet(counter.addToSchedulerTabletNum);
        this.tabletCountByStatus.get("unhealthy").set(counter.unhealthyTabletNum);
        this.tabletCountByStatus.get("total").set(counter.totalTabletNum);
        this.tabletCountByStatus.get("added").set(counter.addToSchedulerTabletNum);
        this.tabletCountByStatus.get("in_sched").set(counter.tabletInScheduler);
        this.tabletCountByStatus.get("not_ready").set(counter.tabletNotReady);
        LOG.info("finished to check tablets. unhealth/total/added/in_sched/not_ready: {}/{}/{}/{}/{}, cost: {} ms", (Object)counter.unhealthyTabletNum, (Object)counter.totalTabletNum, (Object)counter.addToSchedulerTabletNum, (Object)counter.tabletInScheduler, (Object)counter.tabletNotReady, (Object)cost);
    }

    private LoopControlStatus handlePartitionTablet(Database db, OlapTable tbl, Partition partition, boolean isInPrios, List<Long> aliveBeIdsInCluster, long startTime, CheckerCounter counter) {
        if (partition.getState() != Partition.PartitionState.NORMAL) {
            return LoopControlStatus.CONTINUE;
        }
        boolean prioPartIsHealthy = true;
        for (MaterializedIndex idx : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
            for (Tablet tablet : idx.getTablets()) {
                ++counter.totalTabletNum;
                if (this.tabletScheduler.containsTablet(tablet.getId())) {
                    ++counter.tabletInScheduler;
                    continue;
                }
                Pair<Tablet.TabletStatus, TabletSchedCtx.Priority> statusWithPrio = tablet.getHealthStatusWithPriority(this.infoService, db.getClusterName(), partition.getVisibleVersion(), tbl.getPartitionInfo().getReplicaAllocation(partition.getId()), aliveBeIdsInCluster);
                if (statusWithPrio.first == Tablet.TabletStatus.HEALTHY) {
                    tablet.setLastStatusCheckTime(startTime);
                    continue;
                }
                if (statusWithPrio.first == Tablet.TabletStatus.UNRECOVERABLE) {
                    ++counter.unhealthyTabletNum;
                    continue;
                }
                if (isInPrios) {
                    statusWithPrio.second = TabletSchedCtx.Priority.VERY_HIGH;
                    prioPartIsHealthy = false;
                }
                ++counter.unhealthyTabletNum;
                if (!tablet.readyToBeRepaired((TabletSchedCtx.Priority)((Object)statusWithPrio.second))) {
                    ++counter.tabletNotReady;
                    continue;
                }
                TabletSchedCtx tabletCtx = new TabletSchedCtx(TabletSchedCtx.Type.REPAIR, db.getClusterName(), db.getId(), tbl.getId(), partition.getId(), idx.getId(), tablet.getId(), tbl.getPartitionInfo().getReplicaAllocation(partition.getId()), System.currentTimeMillis());
                tabletCtx.setTabletStatus((Tablet.TabletStatus)((Object)statusWithPrio.first));
                tabletCtx.setOrigPriority((TabletSchedCtx.Priority)((Object)statusWithPrio.second));
                TabletScheduler.AddResult res = this.tabletScheduler.addTablet(tabletCtx, false);
                if (res == TabletScheduler.AddResult.LIMIT_EXCEED || res == TabletScheduler.AddResult.DISABLED) {
                    LOG.info("tablet scheduler return: {}. stop tablet checker", (Object)res.name());
                    return LoopControlStatus.BREAK_OUT;
                }
                if (res != TabletScheduler.AddResult.ADDED) continue;
                ++counter.addToSchedulerTabletNum;
            }
        }
        if (prioPartIsHealthy && isInPrios) {
            LOG.info("partition is healthy, remove from prios: {}-{}-{}", (Object)db.getId(), (Object)tbl.getId(), (Object)partition.getId());
            this.removePrios(new RepairTabletInfo(db.getId(), tbl.getId(), Lists.newArrayList((Object[])new Long[]{partition.getId()})));
        }
        return LoopControlStatus.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInPrios(long dbId, long tblId, long partId) {
        com.google.common.collect.Table<Long, Long, Set<PrioPart>> table = this.prios;
        synchronized (table) {
            if (this.prios.contains((Object)dbId, (Object)tblId)) {
                return ((Set)this.prios.get((Object)dbId, (Object)tblId)).contains(new PrioPart(partId, -1L, -1L));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePriosIfNecessary() {
        HashBasedTable copiedPrios = null;
        com.google.common.collect.Table<Long, Long, Set<PrioPart>> table = this.prios;
        synchronized (table) {
            copiedPrios = HashBasedTable.create(this.prios);
        }
        ArrayList deletedPrios = Lists.newArrayList();
        Iterator iter = copiedPrios.rowMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry dbEntry = iter.next();
            long dbId = (Long)dbEntry.getKey();
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) {
                iter.remove();
                continue;
            }
            for (Map.Entry tblEntry : ((Map)dbEntry.getValue()).entrySet()) {
                long tblId = (Long)tblEntry.getKey();
                OlapTable tbl = (OlapTable)db.getTableNullable(tblId);
                if (tbl == null) {
                    deletedPrios.add(Pair.create(dbId, tblId));
                    continue;
                }
                tbl.readLock();
                try {
                    Set parts = (Set)tblEntry.getValue();
                    if (!(parts = parts.stream().filter(p -> tbl.getPartition(p.partId) != null && !p.isTimeout()).collect(Collectors.toSet())).isEmpty()) continue;
                    deletedPrios.add(Pair.create(dbId, tblId));
                }
                finally {
                    tbl.readUnlock();
                }
            }
            if (!((Map)dbEntry.getValue()).isEmpty()) continue;
            iter.remove();
        }
        for (Pair prio : deletedPrios) {
            copiedPrios.remove(prio.first, prio.second);
        }
        this.prios = copiedPrios;
    }

    public void repairTable(AdminRepairTableStmt stmt) throws DdlException {
        RepairTabletInfo repairTabletInfo = TabletChecker.getRepairTabletInfo(stmt.getDbName(), stmt.getTblName(), stmt.getPartitions());
        this.addPrios(repairTabletInfo, stmt.getTimeoutS() * 1000L);
        LOG.info("repair database: {}, table: {}, partition: {}", (Object)repairTabletInfo.dbId, (Object)repairTabletInfo.tblId, repairTabletInfo.partIds);
    }

    public void cancelRepairTable(AdminCancelRepairTableStmt stmt) throws DdlException {
        RepairTabletInfo repairTabletInfo = TabletChecker.getRepairTabletInfo(stmt.getDbName(), stmt.getTblName(), stmt.getPartitions());
        this.removePrios(repairTabletInfo);
        LOG.info("cancel repair database: {}, table: {}, partition: {}", (Object)repairTabletInfo.dbId, (Object)repairTabletInfo.tblId, repairTabletInfo.partIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrioPartitionNum() {
        int count = 0;
        com.google.common.collect.Table<Long, Long, Set<PrioPart>> table = this.prios;
        synchronized (table) {
            for (Set set : this.prios.values()) {
                count += set.size();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getPriosInfo() {
        ArrayList infos = Lists.newArrayList();
        com.google.common.collect.Table<Long, Long, Set<PrioPart>> table = this.prios;
        synchronized (table) {
            for (Table.Cell cell : this.prios.cellSet()) {
                for (PrioPart part : (Set)cell.getValue()) {
                    ArrayList row = Lists.newArrayList();
                    row.add(((Long)cell.getRowKey()).toString());
                    row.add(((Long)cell.getColumnKey()).toString());
                    row.add(String.valueOf(part.partId));
                    row.add(String.valueOf(part.timeoutMs - (System.currentTimeMillis() - part.addTime)));
                    infos.add(row);
                }
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepairTabletInfo getRepairTabletInfo(String dbName, String tblName, List<String> partitions) throws DdlException {
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrDdlException(dbName);
        long dbId = db.getId();
        long tblId = -1L;
        List<Object> partIds = Lists.newArrayList();
        OlapTable olapTable = db.getOlapTableOrDdlException(tblName);
        olapTable.readLock();
        try {
            tblId = olapTable.getId();
            if (partitions == null || partitions.isEmpty()) {
                partIds = olapTable.getPartitions().stream().map(Partition::getId).collect(Collectors.toList());
            } else {
                for (String partName : partitions) {
                    Partition partition = olapTable.getPartition(partName);
                    if (partition == null) {
                        throw new DdlException("Partition does not exist: " + partName);
                    }
                    partIds.add(partition.getId());
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        Preconditions.checkState((tblId != -1L ? 1 : 0) != 0);
        return new RepairTabletInfo(dbId, tblId, partIds);
    }

    private static enum LoopControlStatus {
        CONTINUE,
        BREAK_OUT;

    }

    private static class CheckerCounter {
        public long totalTabletNum = 0L;
        public long unhealthyTabletNum = 0L;
        public long addToSchedulerTabletNum = 0L;
        public long tabletInScheduler = 0L;
        public long tabletNotReady = 0L;

        private CheckerCounter() {
        }
    }

    public static class RepairTabletInfo {
        public long dbId;
        public long tblId;
        public List<Long> partIds;

        public RepairTabletInfo(Long dbId, Long tblId, List<Long> partIds) {
            this.dbId = dbId;
            this.tblId = tblId;
            this.partIds = partIds;
        }
    }

    public static class PrioPart {
        public long partId;
        public long addTime;
        public long timeoutMs;

        public PrioPart(long partId, long addTime, long timeoutMs) {
            this.partId = partId;
            this.addTime = addTime;
            this.timeoutMs = timeoutMs;
        }

        public boolean isTimeout() {
            return System.currentTimeMillis() - this.addTime > this.timeoutMs;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PrioPart)) {
                return false;
            }
            return this.partId == ((PrioPart)obj).partId;
        }

        public int hashCode() {
            return Long.valueOf(this.partId).hashCode();
        }
    }
}

