/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import org.apache.doris.catalog.DiskInfo;
import org.apache.doris.clone.BackendLoadStatistic;
import org.apache.doris.clone.BalanceStatus;
import org.apache.doris.common.Config;
import org.apache.doris.thrift.TStorageMedium;

public class RootPathLoadStatistic
implements Comparable<RootPathLoadStatistic> {
    private long beId;
    private String path;
    private Long pathHash;
    private TStorageMedium storageMedium;
    private long capacityB;
    private long usedCapacityB;
    private DiskInfo.DiskState diskState;
    private BackendLoadStatistic.Classification clazz = BackendLoadStatistic.Classification.INIT;

    public RootPathLoadStatistic(long beId, String path, Long pathHash, TStorageMedium storageMedium, long capacityB, long usedCapacityB, DiskInfo.DiskState diskState) {
        this.beId = beId;
        this.path = path;
        this.pathHash = pathHash;
        this.storageMedium = storageMedium;
        this.capacityB = capacityB <= 0L ? 1L : capacityB;
        this.usedCapacityB = usedCapacityB;
        this.diskState = diskState;
    }

    public long getBeId() {
        return this.beId;
    }

    public String getPath() {
        return this.path;
    }

    public long getPathHash() {
        return this.pathHash;
    }

    public TStorageMedium getStorageMedium() {
        return this.storageMedium;
    }

    public long getCapacityB() {
        return this.capacityB;
    }

    public long getUsedCapacityB() {
        return this.usedCapacityB;
    }

    public double getUsedPercent() {
        return this.capacityB <= 0L ? 0.0 : (double)this.usedCapacityB / (double)this.capacityB;
    }

    public void setClazz(BackendLoadStatistic.Classification clazz) {
        this.clazz = clazz;
    }

    public BackendLoadStatistic.Classification getClazz() {
        return this.clazz;
    }

    public DiskInfo.DiskState getDiskState() {
        return this.diskState;
    }

    public BalanceStatus isFit(long tabletSize, boolean isSupplement) {
        if (this.diskState == DiskInfo.DiskState.OFFLINE) {
            return new BalanceStatus(BalanceStatus.ErrCode.COMMON_ERROR, this.toString() + " does not fit tablet with size: " + tabletSize + ", offline");
        }
        if (isSupplement) {
            if ((double)(this.usedCapacityB + tabletSize) / (double)this.capacityB > (double)Config.storage_flood_stage_usage_percent / 100.0 && this.capacityB - this.usedCapacityB - tabletSize < Config.storage_flood_stage_left_capacity_bytes) {
                return new BalanceStatus(BalanceStatus.ErrCode.COMMON_ERROR, this.toString() + " does not fit tablet with size: " + tabletSize + ", limitation reached");
            }
            return BalanceStatus.OK;
        }
        if ((double)(this.usedCapacityB + tabletSize) / (double)this.capacityB > (double)Config.storage_high_watermark_usage_percent / 100.0 || this.capacityB - this.usedCapacityB - tabletSize < Config.storage_min_left_capacity_bytes) {
            return new BalanceStatus(BalanceStatus.ErrCode.COMMON_ERROR, this.toString() + " does not fit tablet with size: " + tabletSize);
        }
        return BalanceStatus.OK;
    }

    @Override
    public int compareTo(RootPathLoadStatistic o) {
        double myPercent = this.getUsedPercent();
        double otherPercent = o.getUsedPercent();
        return Double.compare(myPercent, otherPercent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("path: ").append(this.path).append(", be: ").append(this.beId);
        sb.append(", used: ").append(this.usedCapacityB).append(", total: ").append(this.capacityB);
        return sb.toString();
    }
}

