/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.clone.SchedException;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.thrift.TStorageMedium;

public abstract class Rebalancer {
    protected Table<String, Tag, ClusterLoadStatistic> statisticMap = HashBasedTable.create();
    protected TabletInvertedIndex invertedIndex;
    protected SystemInfoService infoService;

    public Rebalancer(SystemInfoService infoService, TabletInvertedIndex invertedIndex) {
        this.infoService = infoService;
        this.invertedIndex = invertedIndex;
    }

    public List<TabletSchedCtx> selectAlternativeTablets() {
        ArrayList alternativeTablets = Lists.newArrayList();
        for (Table.Cell entry : this.statisticMap.cellSet()) {
            for (TStorageMedium medium : TStorageMedium.values()) {
                alternativeTablets.addAll(this.selectAlternativeTabletsForCluster((ClusterLoadStatistic)entry.getValue(), medium));
            }
        }
        return alternativeTablets;
    }

    protected abstract List<TabletSchedCtx> selectAlternativeTabletsForCluster(ClusterLoadStatistic var1, TStorageMedium var2);

    public void createBalanceTask(TabletSchedCtx tabletCtx, Map<Long, TabletScheduler.PathSlot> backendsWorkingSlots, AgentBatchTask batchTask) throws SchedException {
        this.completeSchedCtx(tabletCtx, backendsWorkingSlots);
        batchTask.addTask(tabletCtx.createCloneReplicaAndTask());
    }

    protected abstract void completeSchedCtx(TabletSchedCtx var1, Map<Long, TabletScheduler.PathSlot> var2) throws SchedException;

    public Long getToDeleteReplicaId(TabletSchedCtx tabletCtx) {
        return -1L;
    }

    public void updateLoadStatistic(Table<String, Tag, ClusterLoadStatistic> statisticMap) {
        this.statisticMap = statisticMap;
    }
}

