/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.clone.BackendLoadStatistic;
import org.apache.doris.clone.BalanceStatus;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.clone.MovesCacheMap;
import org.apache.doris.clone.Rebalancer;
import org.apache.doris.clone.RootPathLoadStatistic;
import org.apache.doris.clone.SchedException;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.clone.TwoDimensionalGreedyRebalanceAlgo;
import org.apache.doris.common.Config;
import org.apache.doris.common.Pair;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionRebalancer
extends Rebalancer {
    private static final Logger LOG = LogManager.getLogger(PartitionRebalancer.class);
    private final TwoDimensionalGreedyRebalanceAlgo algo = new TwoDimensionalGreedyRebalanceAlgo();
    private final MovesCacheMap movesCacheMap = new MovesCacheMap();
    private final AtomicLong counterBalanceMoveCreated = new AtomicLong(0L);
    private final AtomicLong counterBalanceMoveSucceeded = new AtomicLong(0L);

    public PartitionRebalancer(SystemInfoService infoService, TabletInvertedIndex invertedIndex) {
        super(infoService, invertedIndex);
    }

    @Override
    protected List<TabletSchedCtx> selectAlternativeTabletsForCluster(ClusterLoadStatistic clusterStat, TStorageMedium medium) {
        String clusterName = clusterStat.getClusterName();
        MovesCacheMap.MovesCache movesInProgress = this.movesCacheMap.getCache(clusterName, clusterStat.getTag(), medium);
        Preconditions.checkNotNull((Object)movesInProgress, (Object)"clusterStat is got from statisticMap, movesCacheMap should have the same entry");
        List<TabletMove> movesInProgressList = movesInProgress.get().asMap().values().stream().map(p -> (TabletMove)p.first).collect(Collectors.toList());
        ArrayList toDeleteKeys = Lists.newArrayList();
        List<TabletMove> movesNeedCheck = movesInProgress.get().asMap().values().stream().filter(p -> (Long)p.second != -1L).map(p -> (TabletMove)p.first).collect(Collectors.toList());
        this.checkMovesCompleted(movesNeedCheck, toDeleteKeys);
        ClusterBalanceInfo clusterBalanceInfo = new ClusterBalanceInfo();
        if (!this.buildClusterInfo(clusterStat, medium, movesInProgressList, clusterBalanceInfo, toDeleteKeys)) {
            return Lists.newArrayList();
        }
        if (!toDeleteKeys.isEmpty()) {
            movesInProgress.get().invalidateAll((Iterable)toDeleteKeys);
            movesInProgressList = movesInProgressList.stream().filter(m -> !toDeleteKeys.contains(m.tabletId)).collect(Collectors.toList());
        }
        if (this.movesCacheMap.size() > (long)Config.max_balancing_tablets) {
            LOG.debug("Total in-progress moves > {}", (Object)Config.max_balancing_tablets);
            return Lists.newArrayList();
        }
        NavigableSet skews = clusterBalanceInfo.partitionInfoBySkew.keySet();
        LOG.debug("Cluster {}-{}: peek max skew {}, assume {} in-progress moves are succeeded {}", (Object)clusterName, (Object)medium, (Object)(skews.isEmpty() ? 0L : (Long)skews.last()), (Object)movesInProgressList.size(), movesInProgressList);
        List<TwoDimensionalGreedyRebalanceAlgo.PartitionMove> moves = this.algo.getNextMoves(clusterBalanceInfo, Config.partition_rebalance_max_moves_num_per_selection);
        ArrayList alternativeTablets = Lists.newArrayList();
        List inProgressIds = movesInProgressList.stream().map(m -> m.tabletId).collect(Collectors.toList());
        for (TwoDimensionalGreedyRebalanceAlgo.PartitionMove move : moves) {
            List<Long> tabletIds = this.invertedIndex.getTabletIdsByBackendIdAndStorageMedium(move.fromBe, medium);
            List<Long> invalidIds = this.invertedIndex.getTabletIdsByBackendIdAndStorageMedium(move.toBe, medium);
            tabletIds.removeAll(invalidIds);
            tabletIds.removeAll(inProgressIds);
            HashMap tabletCandidates = Maps.newHashMap();
            for (long tabletId : tabletIds) {
                TabletMeta tabletMeta = this.invertedIndex.getTabletMeta(tabletId);
                if (tabletMeta == null || tabletMeta.getPartitionId() != move.partitionId.longValue() || tabletMeta.getIndexId() != move.indexId.longValue()) continue;
                tabletCandidates.put(tabletId, tabletMeta);
            }
            LOG.debug("Find {} candidates for move {}", (Object)tabletCandidates.size(), (Object)move);
            if (tabletCandidates.isEmpty()) continue;
            Random rand = new Random();
            Object[] keys = tabletCandidates.keySet().toArray();
            long pickedTabletId = (Long)keys[rand.nextInt(keys.length)];
            LOG.debug("Picked tablet id for move {}: {}", (Object)move, (Object)pickedTabletId);
            TabletMeta tabletMeta = (TabletMeta)tabletCandidates.get(pickedTabletId);
            TabletSchedCtx tabletCtx = new TabletSchedCtx(TabletSchedCtx.Type.BALANCE, clusterName, tabletMeta.getDbId(), tabletMeta.getTableId(), tabletMeta.getPartitionId(), tabletMeta.getIndexId(), pickedTabletId, null, System.currentTimeMillis());
            tabletCtx.setTag(clusterStat.getTag());
            tabletCtx.setOrigPriority(TabletSchedCtx.Priority.LOW);
            alternativeTablets.add(tabletCtx);
            movesInProgress.get().put((Object)pickedTabletId, new Pair<TabletMove, Long>(new TabletMove(pickedTabletId, move.fromBe, move.toBe), -1L));
            this.counterBalanceMoveCreated.incrementAndGet();
            inProgressIds.add(pickedTabletId);
        }
        if (moves.isEmpty()) {
            LOG.debug("Cluster {}-{}: cluster is balanced.", (Object)clusterName, (Object)medium);
        } else {
            LOG.info("Cluster {}-{}: get {} moves, actually select {} alternative tablets to move. Tablets detail: {}", (Object)clusterName, (Object)medium, (Object)moves.size(), (Object)alternativeTablets.size(), (Object)alternativeTablets.stream().mapToLong(TabletSchedCtx::getTabletId).toArray());
        }
        return alternativeTablets;
    }

    private boolean buildClusterInfo(ClusterLoadStatistic clusterStat, TStorageMedium medium, List<TabletMove> movesInProgress, ClusterBalanceInfo info, List<Long> toDeleteKeys) {
        Preconditions.checkState((info.beByTotalReplicaCount.isEmpty() && info.partitionInfoBySkew.isEmpty() ? 1 : 0) != 0, (Object)"");
        info.beByTotalReplicaCount.putAll(clusterStat.getBeByTotalReplicaMap(medium));
        info.partitionInfoBySkew.putAll(clusterStat.getSkewMap(medium));
        List filteredMoves = movesInProgress.stream().filter(m -> !toDeleteKeys.contains(m.tabletId)).collect(Collectors.toList());
        for (TabletMove move : filteredMoves) {
            TabletMeta meta = this.invertedIndex.getTabletMeta(move.tabletId);
            if (meta == null) {
                toDeleteKeys.add(move.tabletId);
                continue;
            }
            TwoDimensionalGreedyRebalanceAlgo.PartitionMove partitionMove = new TwoDimensionalGreedyRebalanceAlgo.PartitionMove(meta.getPartitionId(), meta.getIndexId(), move.fromBe, move.toBe);
            boolean st = TwoDimensionalGreedyRebalanceAlgo.applyMove(partitionMove, info.beByTotalReplicaCount, info.partitionInfoBySkew);
            if (st) continue;
            toDeleteKeys.add(move.tabletId);
        }
        return true;
    }

    private void checkMovesCompleted(List<TabletMove> moves, List<Long> toDeleteKeys) {
        for (TabletMove move : moves) {
            boolean moveIsComplete = this.checkMoveCompleted(move);
            if (!moveIsComplete) continue;
            toDeleteKeys.add(move.tabletId);
            LOG.debug("Move {} is completed. The cur dist: {}", (Object)move, this.invertedIndex.getReplicasByTabletId(move.tabletId).stream().map(Replica::getBackendId).collect(Collectors.toList()));
            this.counterBalanceMoveSucceeded.incrementAndGet();
        }
    }

    private boolean checkMoveCompleted(TabletMove move) {
        Long tabletId = move.tabletId;
        List bes = this.invertedIndex.getReplicasByTabletId(tabletId).stream().map(Replica::getBackendId).collect(Collectors.toList());
        return !bes.contains(move.fromBe) && bes.contains(move.toBe);
    }

    @Override
    protected void completeSchedCtx(TabletSchedCtx tabletCtx, Map<Long, TabletScheduler.PathSlot> backendsWorkingSlots) throws SchedException {
        MovesCacheMap.MovesCache movesInProgress = this.movesCacheMap.getCache(tabletCtx.getCluster(), tabletCtx.getTag(), tabletCtx.getStorageMedium());
        Preconditions.checkNotNull((Object)movesInProgress, (Object)"clusterStat is got from statisticMap, movesInProgressMap should have the same entry");
        try {
            Pair pair = (Pair)movesInProgress.get().getIfPresent((Object)tabletCtx.getTabletId());
            Preconditions.checkNotNull((Object)pair, (Object)("No cached move for tablet: " + tabletCtx.getTabletId()));
            TabletMove move = (TabletMove)pair.first;
            this.checkMoveValidation(move);
            Replica srcReplica = tabletCtx.getTablet().getReplicaByBackendId(move.fromBe);
            Preconditions.checkNotNull((Object)srcReplica);
            TabletScheduler.PathSlot slot = backendsWorkingSlots.get(srcReplica.getBackendId());
            Preconditions.checkNotNull((Object)slot, (Object)("unable to get fromBe " + srcReplica.getBackendId() + " slot"));
            if (slot.takeBalanceSlot(srcReplica.getPathHash()) == -1L) {
                throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "no slot for src replica " + srcReplica + ", pathHash " + srcReplica.getPathHash());
            }
            tabletCtx.setSrc(srcReplica);
            ClusterLoadStatistic clusterStat = (ClusterLoadStatistic)this.statisticMap.get((Object)tabletCtx.getCluster(), (Object)tabletCtx.getTag());
            Preconditions.checkNotNull((Object)clusterStat, (Object)("cluster does not exist: " + tabletCtx.getCluster()));
            BackendLoadStatistic beStat = clusterStat.getBackendLoadStatistic(move.toBe);
            Preconditions.checkNotNull((Object)beStat);
            slot = backendsWorkingSlots.get(move.toBe);
            Preconditions.checkNotNull((Object)slot, (Object)("unable to get slot of toBe " + move.toBe));
            List<RootPathLoadStatistic> paths = beStat.getPathStatistics();
            Set<Long> availPath = paths.stream().filter(path -> path.getStorageMedium() == tabletCtx.getStorageMedium() && path.isFit(tabletCtx.getTabletSize(), false) == BalanceStatus.OK).map(RootPathLoadStatistic::getPathHash).collect(Collectors.toSet());
            long pathHash = slot.takeAnAvailBalanceSlotFrom(availPath);
            if (pathHash == -1L) {
                throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "paths has no available balance slot: " + availPath);
            }
            tabletCtx.setDest(beStat.getBeId(), pathHash);
            pair.second = srcReplica.getId();
        }
        catch (IllegalStateException | NullPointerException e) {
            movesInProgress.get().invalidate((Object)tabletCtx.getTabletId());
            throw new SchedException(SchedException.Status.UNRECOVERABLE, e.getMessage());
        }
    }

    private void checkMoveValidation(TabletMove move) throws IllegalStateException {
        boolean fromAvailable = this.infoService.checkBackendScheduleAvailable(move.fromBe);
        boolean toAvailable = this.infoService.checkBackendScheduleAvailable(move.toBe);
        Preconditions.checkState((fromAvailable && toAvailable ? 1 : 0) != 0, (Object)(move + "'s bes are not all available: from " + fromAvailable + ", to " + toAvailable));
    }

    @Override
    public Long getToDeleteReplicaId(TabletSchedCtx tabletCtx) {
        Pair<TabletMove, Long> pair = this.movesCacheMap.getTabletMove(tabletCtx);
        if (pair != null) {
            Preconditions.checkState(((Long)pair.second != -1L ? 1 : 0) != 0);
            return (Long)pair.second;
        }
        return -1L;
    }

    @Override
    public void updateLoadStatistic(Table<String, Tag, ClusterLoadStatistic> statisticMap) {
        super.updateLoadStatistic(statisticMap);
        this.movesCacheMap.updateMapping(statisticMap, Config.partition_rebalance_move_expire_after_access);
        this.movesCacheMap.maintain();
        LOG.debug("Move succeeded/total :{}/{}, current {}", (Object)this.counterBalanceMoveSucceeded.get(), (Object)this.counterBalanceMoveCreated.get(), (Object)this.movesCacheMap);
    }

    public static class ClusterBalanceInfo {
        TreeMultimap<Long, TabletInvertedIndex.PartitionBalanceInfo> partitionInfoBySkew = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.arbitrary());
        TreeMultimap<Long, Long> beByTotalReplicaCount = TreeMultimap.create();
    }

    public static class TabletMove {
        Long tabletId;
        Long fromBe;
        Long toBe;

        TabletMove(Long id, Long from, Long to) {
            this.tabletId = id;
            this.fromBe = from;
            this.toBe = to;
        }

        public String toString() {
            return "ReplicaMove{tabletId=" + this.tabletId + ", fromBe=" + this.fromBe + ", toBe=" + this.toBe + '}';
        }
    }
}

