/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.clone.PartitionRebalancer;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.common.Pair;
import org.apache.doris.resource.Tag;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MovesCacheMap {
    private static final Logger LOG = LogManager.getLogger(MovesCacheMap.class);
    private final Table<String, Tag, Map<TStorageMedium, MovesCache>> cacheMap = HashBasedTable.create();
    private long lastExpireConfig = -1L;

    public void updateMapping(Table<String, Tag, ClusterLoadStatistic> statisticMap, long expireAfterAccessSecond) {
        if (expireAfterAccessSecond > 0L && this.lastExpireConfig != expireAfterAccessSecond) {
            LOG.debug("Reset expireAfterAccess, last {} s, now {} s. Moves will be cleared.", (Object)this.lastExpireConfig, (Object)expireAfterAccessSecond);
            this.cacheMap.clear();
            this.lastExpireConfig = expireAfterAccessSecond;
        }
        this.cacheMap.cellSet().stream().filter(c -> !statisticMap.contains(c.getRowKey(), c.getColumnKey())).forEach(c -> this.cacheMap.remove(c.getRowKey(), c.getColumnKey()));
        List toAdd = statisticMap.cellSet().stream().filter(c -> !this.cacheMap.contains(c.getRowKey(), c.getColumnKey())).collect(Collectors.toList());
        for (Table.Cell cell : toAdd) {
            HashMap newCacheMap = Maps.newHashMap();
            Arrays.stream(TStorageMedium.values()).forEach(m -> newCacheMap.put(m, new MovesCache(expireAfterAccessSecond, TimeUnit.SECONDS)));
            this.cacheMap.put((Object)((String)cell.getRowKey()), (Object)((Tag)cell.getColumnKey()), (Object)newCacheMap);
        }
    }

    public MovesCache getCache(String clusterName, Tag tag, TStorageMedium medium) {
        Map clusterMoves = (Map)this.cacheMap.get((Object)clusterName, (Object)tag);
        if (clusterMoves != null) {
            return (MovesCache)clusterMoves.get(medium);
        }
        return null;
    }

    public Pair<PartitionRebalancer.TabletMove, Long> getTabletMove(TabletSchedCtx tabletCtx) {
        Map tagMap = this.cacheMap.row((Object)tabletCtx.getCluster());
        if (tagMap == null) {
            return null;
        }
        for (Map mediumMap : tagMap.values()) {
            MovesCache cache = (MovesCache)mediumMap.get(tabletCtx.getStorageMedium());
            if (cache == null) continue;
            return (Pair)cache.get().getIfPresent((Object)tabletCtx.getTabletId());
        }
        return null;
    }

    public void maintain() {
        this.cacheMap.values().forEach(maps -> maps.values().forEach(map -> map.get().cleanUp()));
    }

    public long size() {
        return this.cacheMap.values().stream().mapToLong(maps -> maps.values().stream().mapToLong(map -> map.get().size()).sum()).sum();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("\n", "MovesInProgress detail:\n", "");
        this.cacheMap.cellSet().forEach(c -> ((Map)c.getValue()).forEach((k, v) -> sj.add("(" + (String)c.getRowKey() + "-" + c.getColumnKey() + "-" + k + ": " + v.get().asMap() + ")")));
        return sj.toString();
    }

    public static class MovesCache {
        Cache<Long, Pair<PartitionRebalancer.TabletMove, Long>> cache;

        MovesCache(long duration, TimeUnit unit) {
            this.cache = CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build();
        }

        public Cache<Long, Pair<PartitionRebalancer.TabletMove, Long>> get() {
            return this.cache;
        }
    }
}

