/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.doris.analysis.AddPartitionClause;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.DropPartitionClause;
import org.apache.doris.analysis.HashDistributionDesc;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.analysis.PartitionValue;
import org.apache.doris.analysis.RandomDistributionDesc;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.DynamicPartitionProperty;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.DynamicPartitionUtil;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.common.util.RangeUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicPartitionScheduler
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(DynamicPartitionScheduler.class);
    public static final String LAST_SCHEDULER_TIME = "lastSchedulerTime";
    public static final String LAST_UPDATE_TIME = "lastUpdateTime";
    public static final String DYNAMIC_PARTITION_STATE = "dynamicPartitionState";
    public static final String CREATE_PARTITION_MSG = "createPartitionMsg";
    public static final String DROP_PARTITION_MSG = "dropPartitionMsg";
    private final String DEFAULT_RUNTIME_VALUE = FeConstants.null_string;
    private Map<Long, Map<String, String>> runtimeInfos = Maps.newConcurrentMap();
    private Set<Pair<Long, Long>> dynamicPartitionTableInfo = Sets.newConcurrentHashSet();
    private boolean initialize = false;

    public DynamicPartitionScheduler(String name, long intervalMs) {
        super(name, intervalMs);
    }

    public void executeDynamicPartitionFirstTime(Long dbId, Long tableId) {
        ArrayList tempDynamicPartitionTableInfo = Lists.newArrayList((Object[])new Pair[]{new Pair<Long, Long>(dbId, tableId)});
        this.executeDynamicPartition(tempDynamicPartitionTableInfo);
    }

    public void registerDynamicPartitionTable(Long dbId, Long tableId) {
        this.dynamicPartitionTableInfo.add(new Pair<Long, Long>(dbId, tableId));
    }

    public void removeDynamicPartitionTable(Long dbId, Long tableId) {
        this.dynamicPartitionTableInfo.remove(new Pair<Long, Long>(dbId, tableId));
    }

    public String getRuntimeInfo(long tableId, String key) {
        Map<String, String> tableRuntimeInfo = this.runtimeInfos.getOrDefault(tableId, this.createDefaultRuntimeInfo());
        return tableRuntimeInfo.getOrDefault(key, this.DEFAULT_RUNTIME_VALUE);
    }

    public void removeRuntimeInfo(long tableId) {
        this.runtimeInfos.remove(tableId);
    }

    public void createOrUpdateRuntimeInfo(long tableId, String key, String value) {
        Map<String, String> runtimeInfo = this.runtimeInfos.get(tableId);
        if (runtimeInfo == null) {
            runtimeInfo = this.createDefaultRuntimeInfo();
            runtimeInfo.put(key, value);
            this.runtimeInfos.put(tableId, runtimeInfo);
        } else {
            runtimeInfo.put(key, value);
        }
    }

    private Map<String, String> createDefaultRuntimeInfo() {
        ConcurrentMap defaultRuntimeInfo = Maps.newConcurrentMap();
        defaultRuntimeInfo.put(LAST_UPDATE_TIME, this.DEFAULT_RUNTIME_VALUE);
        defaultRuntimeInfo.put(LAST_SCHEDULER_TIME, this.DEFAULT_RUNTIME_VALUE);
        defaultRuntimeInfo.put(DYNAMIC_PARTITION_STATE, State.NORMAL.toString());
        defaultRuntimeInfo.put(CREATE_PARTITION_MSG, this.DEFAULT_RUNTIME_VALUE);
        defaultRuntimeInfo.put(DROP_PARTITION_MSG, this.DEFAULT_RUNTIME_VALUE);
        return defaultRuntimeInfo;
    }

    private ArrayList<AddPartitionClause> getAddPartitionClause(Database db, OlapTable olapTable, Column partitionColumn, String partitionFormat) {
        ArrayList<AddPartitionClause> addPartitionClauses = new ArrayList<AddPartitionClause>();
        DynamicPartitionProperty dynamicPartitionProperty = olapTable.getTableProperty().getDynamicPartitionProperty();
        RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)olapTable.getPartitionInfo();
        ZonedDateTime now = ZonedDateTime.now(dynamicPartitionProperty.getTimeZone().toZoneId());
        boolean createHistoryPartition = dynamicPartitionProperty.isCreateHistoryPartition();
        int start = dynamicPartitionProperty.getStart();
        int historyPartitionNum = dynamicPartitionProperty.getHistoryPartitionNum();
        int idx = createHistoryPartition ? (historyPartitionNum == -1 ? start : Math.max(start, -historyPartitionNum)) : 0;
        int hotPartitionNum = dynamicPartitionProperty.getHotPartitionNum();
        while (idx <= dynamicPartitionProperty.getEnd()) {
            block14: {
                Range addPartitionKeyRange;
                String prevBorder = DynamicPartitionUtil.getPartitionRangeString(dynamicPartitionProperty, now, idx, partitionFormat);
                String nextBorder = DynamicPartitionUtil.getPartitionRangeString(dynamicPartitionProperty, now, idx + 1, partitionFormat);
                PartitionValue lowerValue = new PartitionValue(prevBorder);
                PartitionValue upperValue = new PartitionValue(nextBorder);
                boolean isPartitionExists = false;
                try {
                    PartitionKey lowerBound = PartitionKey.createPartitionKey(Collections.singletonList(lowerValue), Collections.singletonList(partitionColumn));
                    PartitionKey upperBound = PartitionKey.createPartitionKey(Collections.singletonList(upperValue), Collections.singletonList(partitionColumn));
                    addPartitionKeyRange = Range.closedOpen((Comparable)lowerBound, (Comparable)upperBound);
                }
                catch (IllegalArgumentException | AnalysisException e) {
                    LOG.warn("Error in gen addPartitionKeyRange. Error={}, db: {}, table: {}", (Object)e.getMessage(), (Object)db.getFullName(), (Object)olapTable.getName());
                    break block14;
                }
                for (PartitionItem partitionItem : rangePartitionInfo.getIdToItem(false).values()) {
                    try {
                        RangeUtils.checkRangeIntersect((Range<PartitionKey>)((Range)partitionItem.getItems()), (Range<PartitionKey>)addPartitionKeyRange);
                    }
                    catch (Exception e) {
                        isPartitionExists = true;
                        if (addPartitionKeyRange.equals(partitionItem.getItems())) {
                            LOG.info("partition range {} exist in table {}, clear fail msg", (Object)addPartitionKeyRange, (Object)olapTable.getName());
                            this.clearCreatePartitionFailedMsg(olapTable.getId());
                            break;
                        }
                        this.recordCreatePartitionFailedMsg(db.getFullName(), olapTable.getName(), e.getMessage(), olapTable.getId());
                        break;
                    }
                }
                if (!isPartitionExists) {
                    PartitionKeyDesc partitionKeyDesc = PartitionKeyDesc.createFixed(Collections.singletonList(lowerValue), Collections.singletonList(upperValue));
                    HashMap<String, String> partitionProperties = new HashMap<String, String>(1);
                    if (dynamicPartitionProperty.getReplicaAllocation().isNotSet()) {
                        partitionProperties.put("replication_allocation", olapTable.getDefaultReplicaAllocation().toCreateStmt());
                    } else {
                        partitionProperties.put("replication_allocation", dynamicPartitionProperty.getReplicaAllocation().toCreateStmt());
                    }
                    if (hotPartitionNum > 0) {
                        this.setStorageMediumProperty(partitionProperties, dynamicPartitionProperty, now, hotPartitionNum, idx);
                    }
                    String partitionName = dynamicPartitionProperty.getPrefix() + DynamicPartitionUtil.getFormattedPartitionName(dynamicPartitionProperty.getTimeZone(), prevBorder, dynamicPartitionProperty.getTimeUnit());
                    SinglePartitionDesc rangePartitionDesc = new SinglePartitionDesc(true, partitionName, partitionKeyDesc, partitionProperties);
                    DistributionDesc distributionDesc = null;
                    DistributionInfo distributionInfo = olapTable.getDefaultDistributionInfo();
                    if (distributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH) {
                        HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)distributionInfo;
                        ArrayList<String> distColumnNames = new ArrayList<String>();
                        for (Column distributionColumn : hashDistributionInfo.getDistributionColumns()) {
                            distColumnNames.add(distributionColumn.getName());
                        }
                        distributionDesc = new HashDistributionDesc(dynamicPartitionProperty.getBuckets(), distColumnNames);
                    } else {
                        distributionDesc = new RandomDistributionDesc(dynamicPartitionProperty.getBuckets());
                    }
                    addPartitionClauses.add(new AddPartitionClause(rangePartitionDesc, distributionDesc, null, false));
                }
            }
            ++idx;
        }
        return addPartitionClauses;
    }

    private void setStorageMediumProperty(HashMap<String, String> partitionProperties, DynamicPartitionProperty property, ZonedDateTime now, int hotPartitionNum, int offset) {
        if (offset + hotPartitionNum <= 0) {
            return;
        }
        partitionProperties.put("storage_medium", TStorageMedium.SSD.name());
        String cooldownTime = DynamicPartitionUtil.getPartitionRangeString(property, now, offset + hotPartitionNum, "yyyy-MM-dd HH:mm:ss");
        partitionProperties.put("storage_cooldown_time", cooldownTime);
    }

    private Range<PartitionKey> getClosedRange(Database db, OlapTable olapTable, Column partitionColumn, String partitionFormat, String lowerBorderOfReservedHistory, String upperBorderOfReservedHistory) {
        Range reservedHistoryPartitionKeyRange = null;
        PartitionValue lowerBorderPartitionValue = new PartitionValue(lowerBorderOfReservedHistory);
        PartitionValue upperBorderPartitionValue = new PartitionValue(upperBorderOfReservedHistory);
        try {
            PartitionKey lowerBorderBound = PartitionKey.createPartitionKey(Collections.singletonList(lowerBorderPartitionValue), Collections.singletonList(partitionColumn));
            PartitionKey upperBorderBound = PartitionKey.createPartitionKey(Collections.singletonList(upperBorderPartitionValue), Collections.singletonList(partitionColumn));
            reservedHistoryPartitionKeyRange = Range.closed((Comparable)lowerBorderBound, (Comparable)upperBorderBound);
        }
        catch (AnalysisException e) {
            LOG.warn("Error in gen reservePartitionKeyRange. Error={}, db: {}, table: {}", (Object)e.getMessage(), (Object)db.getFullName(), (Object)olapTable.getName());
        }
        return reservedHistoryPartitionKeyRange;
    }

    private ArrayList<DropPartitionClause> getDropPartitionClause(Database db, OlapTable olapTable, Column partitionColumn, String partitionFormat) throws DdlException {
        ArrayList<DropPartitionClause> dropPartitionClauses = new ArrayList<DropPartitionClause>();
        DynamicPartitionProperty dynamicPartitionProperty = olapTable.getTableProperty().getDynamicPartitionProperty();
        if (dynamicPartitionProperty.getStart() == Integer.MIN_VALUE) {
            return dropPartitionClauses;
        }
        ZonedDateTime now = ZonedDateTime.now(dynamicPartitionProperty.getTimeZone().toZoneId());
        String lowerBorder = DynamicPartitionUtil.getPartitionRangeString(dynamicPartitionProperty, now, dynamicPartitionProperty.getStart(), partitionFormat);
        String upperBorder = DynamicPartitionUtil.getPartitionRangeString(dynamicPartitionProperty, now, dynamicPartitionProperty.getEnd() + 1, partitionFormat);
        PartitionValue lowerPartitionValue = new PartitionValue(lowerBorder);
        PartitionValue upperPartitionValue = new PartitionValue(upperBorder);
        ArrayList<Object> reservedHistoryPartitionKeyRangeList = new ArrayList<Object>();
        try {
            PartitionKey lowerBound = PartitionKey.createPartitionKey(Collections.singletonList(lowerPartitionValue), Collections.singletonList(partitionColumn));
            PartitionKey upperBound = PartitionKey.createPartitionKey(Collections.singletonList(upperPartitionValue), Collections.singletonList(partitionColumn));
            Range reservePartitionKeyRange = Range.closedOpen((Comparable)lowerBound, (Comparable)upperBound);
            reservedHistoryPartitionKeyRangeList.add(reservePartitionKeyRange);
        }
        catch (IllegalArgumentException | AnalysisException e) {
            LOG.warn("Error in gen reservePartitionKeyRange. Error={}, db: {}, table: {}", (Object)e.getMessage(), (Object)db.getFullName(), (Object)olapTable.getName());
            return dropPartitionClauses;
        }
        String reservedHistoryPeriods = dynamicPartitionProperty.getReservedHistoryPeriods();
        List<Range> ranges = DynamicPartitionUtil.convertStringToPeriodsList(reservedHistoryPeriods, dynamicPartitionProperty.getTimeUnit());
        if (ranges.size() != 0) {
            for (Range range : ranges) {
                try {
                    String lowerBorderOfReservedHistory = DynamicPartitionUtil.getHistoryPartitionRangeString(dynamicPartitionProperty, range.lowerEndpoint().toString(), partitionFormat);
                    String upperBorderOfReservedHistory = DynamicPartitionUtil.getHistoryPartitionRangeString(dynamicPartitionProperty, range.upperEndpoint().toString(), partitionFormat);
                    Range<PartitionKey> range2 = this.getClosedRange(db, olapTable, partitionColumn, partitionFormat, lowerBorderOfReservedHistory, upperBorderOfReservedHistory);
                    reservedHistoryPartitionKeyRangeList.add(range2);
                }
                catch (IllegalArgumentException e) {
                    return dropPartitionClauses;
                }
            }
        }
        RangePartitionInfo info = (RangePartitionInfo)olapTable.getPartitionInfo();
        ArrayList<Map.Entry<Long, PartitionItem>> idToItems = new ArrayList<Map.Entry<Long, PartitionItem>>(info.getIdToItem(false).entrySet());
        idToItems.sort(Comparator.comparing(o -> (PartitionKey)((RangePartitionItem)o.getValue()).getItems().upperEndpoint()));
        HashMap<Long, Boolean> isContaineds = new HashMap<Long, Boolean>();
        for (Map.Entry entry : idToItems) {
            isContaineds.put((Long)entry.getKey(), false);
            Long checkDropPartitionId = (Long)entry.getKey();
            Range checkDropPartitionKey = (Range)((PartitionItem)entry.getValue()).getItems();
            for (Range range : reservedHistoryPartitionKeyRangeList) {
                if (!RangeUtils.checkIsTwoRangesIntersect((Range<PartitionKey>)range, (Range<PartitionKey>)checkDropPartitionKey)) continue;
                isContaineds.put(checkDropPartitionId, true);
            }
        }
        for (Long l : isContaineds.keySet()) {
            if (((Boolean)isContaineds.get(l)).booleanValue()) continue;
            String dropPartitionName = olapTable.getPartition(l).getName();
            dropPartitionClauses.add(new DropPartitionClause(false, dropPartitionName, false, false));
        }
        return dropPartitionClauses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDynamicPartition(Collection<Pair<Long, Long>> dynamicPartitionTableInfoCol) {
        Iterator<Pair<Long, Long>> iterator = dynamicPartitionTableInfoCol.iterator();
        while (iterator.hasNext()) {
            Pair<Long, Long> tableInfo = iterator.next();
            Long dbId = (Long)tableInfo.first;
            Long tableId = (Long)tableInfo.second;
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) {
                iterator.remove();
                continue;
            }
            ArrayList<Object> addPartitionClauses = new ArrayList();
            ArrayList<DropPartitionClause> dropPartitionClauses = null;
            String tableName = null;
            boolean skipAddPartition = false;
            OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
            if (olapTable == null || !olapTable.dynamicPartitionExists() || !olapTable.getTableProperty().getDynamicPartitionProperty().getEnable()) {
                iterator.remove();
                continue;
            }
            olapTable.readLock();
            try {
                String partitionFormat;
                if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                    String errorMsg = "Table[" + olapTable.getName() + "]'s state is not NORMAL.Do not allow doing dynamic add partition. table state=" + (Object)((Object)olapTable.getState());
                    this.recordCreatePartitionFailedMsg(db.getFullName(), olapTable.getName(), errorMsg, olapTable.getId());
                    skipAddPartition = true;
                }
                this.createOrUpdateRuntimeInfo(olapTable.getId(), LAST_SCHEDULER_TIME, TimeUtils.getCurrentFormatTime());
                RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)olapTable.getPartitionInfo();
                if (rangePartitionInfo.getPartitionColumns().size() != 1) {
                    iterator.remove();
                    continue;
                }
                Column partitionColumn = rangePartitionInfo.getPartitionColumns().get(0);
                try {
                    partitionFormat = DynamicPartitionUtil.getPartitionFormat(partitionColumn);
                }
                catch (Exception e) {
                    this.recordCreatePartitionFailedMsg(db.getFullName(), olapTable.getName(), e.getMessage(), olapTable.getId());
                    olapTable.readUnlock();
                    continue;
                }
                if (!skipAddPartition) {
                    addPartitionClauses = this.getAddPartitionClause(db, olapTable, partitionColumn, partitionFormat);
                }
                dropPartitionClauses = this.getDropPartitionClause(db, olapTable, partitionColumn, partitionFormat);
                tableName = olapTable.getName();
            }
            catch (DdlException e) {
                e.printStackTrace();
            }
            finally {
                olapTable.readUnlock();
                continue;
            }
            for (DropPartitionClause dropPartitionClause : dropPartitionClauses) {
                if (!olapTable.writeLockIfExist()) continue;
                try {
                    Catalog.getCurrentCatalog().dropPartition(db, olapTable, dropPartitionClause);
                    this.clearDropPartitionFailedMsg(olapTable.getId());
                }
                catch (Exception e) {
                    this.recordDropPartitionFailedMsg(db.getFullName(), tableName, e.getMessage(), olapTable.getId());
                }
                finally {
                    olapTable.writeUnlock();
                }
            }
            if (skipAddPartition) continue;
            for (AddPartitionClause addPartitionClause : addPartitionClauses) {
                try {
                    Catalog.getCurrentCatalog().addPartition(db, tableName, addPartitionClause);
                    this.clearCreatePartitionFailedMsg(olapTable.getId());
                }
                catch (Exception e) {
                    this.recordCreatePartitionFailedMsg(db.getFullName(), tableName, e.getMessage(), olapTable.getId());
                }
            }
        }
    }

    private void recordCreatePartitionFailedMsg(String dbName, String tableName, String msg, long tableId) {
        LOG.warn("dynamic add partition failed: {}, db: {}, table: {}", (Object)msg, (Object)dbName, (Object)tableName);
        this.createOrUpdateRuntimeInfo(tableId, DYNAMIC_PARTITION_STATE, State.ERROR.toString());
        this.createOrUpdateRuntimeInfo(tableId, CREATE_PARTITION_MSG, msg);
    }

    private void clearCreatePartitionFailedMsg(long tableId) {
        this.createOrUpdateRuntimeInfo(tableId, DYNAMIC_PARTITION_STATE, State.NORMAL.toString());
        this.createOrUpdateRuntimeInfo(tableId, CREATE_PARTITION_MSG, this.DEFAULT_RUNTIME_VALUE);
    }

    private void recordDropPartitionFailedMsg(String dbName, String tableName, String msg, long tableId) {
        LOG.warn("dynamic drop partition failed: {}, db: {}, table: {}", (Object)msg, (Object)dbName, (Object)tableName);
        this.createOrUpdateRuntimeInfo(tableId, DYNAMIC_PARTITION_STATE, State.ERROR.toString());
        this.createOrUpdateRuntimeInfo(tableId, DROP_PARTITION_MSG, msg);
    }

    private void clearDropPartitionFailedMsg(long tableId) {
        this.createOrUpdateRuntimeInfo(tableId, DYNAMIC_PARTITION_STATE, State.NORMAL.toString());
        this.createOrUpdateRuntimeInfo(tableId, DROP_PARTITION_MSG, this.DEFAULT_RUNTIME_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDynamicPartitionTable() {
        for (Long dbId : Catalog.getCurrentCatalog().getDbIds()) {
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) continue;
            List<Table> tableList = db.getTables();
            for (Table table : tableList) {
                table.readLock();
                try {
                    if (!DynamicPartitionUtil.isDynamicPartitionTable(table)) continue;
                    this.registerDynamicPartitionTable(db.getId(), table.getId());
                }
                finally {
                    table.readUnlock();
                }
            }
        }
        this.initialize = true;
    }

    @Override
    protected void runAfterCatalogReady() {
        if (!this.initialize) {
            this.initDynamicPartitionTable();
        }
        this.setInterval(Config.dynamic_partition_check_interval_seconds * 1000L);
        if (Config.dynamic_partition_enable) {
            this.executeDynamicPartition(this.dynamicPartitionTableInfo);
        }
    }

    public static enum State {
        NORMAL,
        ERROR;

    }
}

