/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateGroupSchema;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.clone.BackendLoadStatistic;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.persist.ColocatePersistInfo;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.Strings;

public class ColocateTableCheckerAndBalancer
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(ColocateTableCheckerAndBalancer.class);
    private static volatile ColocateTableCheckerAndBalancer INSTANCE = null;

    private ColocateTableCheckerAndBalancer(long intervalMs) {
        super("colocate group clone checker", intervalMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColocateTableCheckerAndBalancer getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ColocateTableCheckerAndBalancer> clazz = ColocateTableCheckerAndBalancer.class;
        synchronized (ColocateTableCheckerAndBalancer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ColocateTableCheckerAndBalancer(FeConstants.tablet_checker_interval_ms);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    protected void runAfterCatalogReady() {
        this.relocateAndBalanceGroup();
        this.matchGroup();
    }

    private void relocateAndBalanceGroup() {
        if (Config.disable_colocate_balance) {
            return;
        }
        Catalog catalog = Catalog.getCurrentCatalog();
        ColocateTableIndex colocateIndex = catalog.getColocateTableIndex();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        Set<ColocateTableIndex.GroupId> groupIds = colocateIndex.getAllGroupIds();
        for (ColocateTableIndex.GroupId groupId : groupIds) {
            Table<String, Tag, ClusterLoadStatistic> statisticMap;
            Database db = catalog.getDbNullable(groupId.dbId);
            if (db == null || (statisticMap = catalog.getTabletScheduler().getStatisticMap()) == null) continue;
            ColocateGroupSchema groupSchema = colocateIndex.getGroupSchema(groupId);
            ReplicaAllocation replicaAlloc = groupSchema.getReplicaAlloc();
            try {
                Catalog.getCurrentSystemInfo().checkReplicaAllocation(db.getClusterName(), replicaAlloc);
            }
            catch (DdlException e) {
                colocateIndex.setErrMsgForGroup(groupId, e.getMessage());
                continue;
            }
            Map<Tag, Short> allocMap = replicaAlloc.getAllocMap();
            for (Map.Entry<Tag, Short> entry : allocMap.entrySet()) {
                ArrayList balancedBackendsPerBucketSeq;
                List<List<Long>> backendsPerBucketSeq;
                Tag tag = entry.getKey();
                ClusterLoadStatistic statistic = (ClusterLoadStatistic)statisticMap.get((Object)db.getClusterName(), (Object)tag);
                if (statistic == null || (backendsPerBucketSeq = colocateIndex.getBackendsPerBucketSeqByTag(groupId, tag)).isEmpty()) continue;
                Set<Long> unavailableBeIdsInGroup = this.getUnavailableBeIdsInGroup(infoService, colocateIndex, groupId, tag);
                Set<Long> beIdsInOtherTag = colocateIndex.getBackendIdsExceptForTag(groupId, tag);
                List<Long> availableBeIds = this.getAvailableBeIds(db.getClusterName(), tag, beIdsInOtherTag, infoService);
                if (!this.relocateAndBalance(groupId, tag, unavailableBeIdsInGroup, availableBeIds, colocateIndex, infoService, statistic, balancedBackendsPerBucketSeq = Lists.newArrayList())) continue;
                colocateIndex.addBackendsPerBucketSeqByTag(groupId, tag, balancedBackendsPerBucketSeq);
                HashMap balancedBackendsPerBucketSeqMap = Maps.newHashMap();
                balancedBackendsPerBucketSeqMap.put(tag, balancedBackendsPerBucketSeq);
                ColocatePersistInfo info = ColocatePersistInfo.createForBackendsPerBucketSeq(groupId, balancedBackendsPerBucketSeqMap);
                catalog.getEditLog().logColocateBackendsPerBucketSeq(info);
                LOG.info("balance group {}. now backends per bucket sequence for tag {} is: {}", (Object)groupId, (Object)tag, (Object)balancedBackendsPerBucketSeq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchGroup() {
        Catalog catalog = Catalog.getCurrentCatalog();
        ColocateTableIndex colocateIndex = catalog.getColocateTableIndex();
        TabletScheduler tabletScheduler = catalog.getTabletScheduler();
        Set<ColocateTableIndex.GroupId> groupIds = colocateIndex.getAllGroupIds();
        for (ColocateTableIndex.GroupId groupId : groupIds) {
            List<Set<Long>> backendBucketsSeq;
            List<Long> tableIds = colocateIndex.getAllTableIds(groupId);
            Database db = catalog.getDbNullable(groupId.dbId);
            if (db == null || (backendBucketsSeq = colocateIndex.getBackendsPerBucketSeqSet(groupId)).isEmpty()) continue;
            String unstableReason = null;
            block5: for (Long tableId : tableIds) {
                OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
                if (olapTable == null || !colocateIndex.isColocateTable(olapTable.getId())) continue;
                olapTable.readLock();
                try {
                    for (Partition partition : olapTable.getPartitions()) {
                        ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId());
                        short replicationNum = replicaAlloc.getTotalReplicaNum();
                        long visibleVersion = partition.getVisibleVersion();
                        for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                            Preconditions.checkState((backendBucketsSeq.size() == index.getTablets().size() ? 1 : 0) != 0, (Object)(backendBucketsSeq.size() + " vs. " + index.getTablets().size()));
                            int idx = 0;
                            for (Long tabletId : index.getTabletIdsInOrder()) {
                                Set<Long> bucketsSeq = backendBucketsSeq.get(idx);
                                Preconditions.checkState((bucketsSeq.size() == replicationNum ? 1 : 0) != 0, (Object)(bucketsSeq.size() + " vs. " + replicationNum));
                                Tablet tablet = index.getTablet(tabletId);
                                Tablet.TabletStatus st = tablet.getColocateHealthStatus(visibleVersion, replicaAlloc, bucketsSeq);
                                if (st != Tablet.TabletStatus.HEALTHY) {
                                    unstableReason = String.format("get unhealthy tablet %d in colocate table. status: %s", new Object[]{tablet.getId(), st});
                                    LOG.debug(unstableReason);
                                    if (!tablet.readyToBeRepaired(TabletSchedCtx.Priority.NORMAL)) continue;
                                    TabletSchedCtx tabletCtx = new TabletSchedCtx(TabletSchedCtx.Type.REPAIR, db.getClusterName(), db.getId(), tableId, partition.getId(), index.getId(), tablet.getId(), olapTable.getPartitionInfo().getReplicaAllocation(partition.getId()), System.currentTimeMillis());
                                    tabletCtx.setTabletStatus(st);
                                    tabletCtx.setOrigPriority(TabletSchedCtx.Priority.NORMAL);
                                    tabletCtx.setTabletOrderIdx(idx);
                                    TabletScheduler.AddResult res = tabletScheduler.addTablet(tabletCtx, false);
                                    if (res == TabletScheduler.AddResult.LIMIT_EXCEED || res == TabletScheduler.AddResult.DISABLED) {
                                        LOG.info("tablet scheduler return: {}. stop colocate table check", (Object)res.name());
                                        break block5;
                                    }
                                }
                                ++idx;
                            }
                        }
                    }
                }
                finally {
                    olapTable.readUnlock();
                }
            }
            if (Strings.isNullOrEmpty(unstableReason)) {
                colocateIndex.markGroupStable(groupId, true);
                continue;
            }
            colocateIndex.markGroupUnstable(groupId, unstableReason, true);
        }
    }

    private boolean relocateAndBalance(ColocateTableIndex.GroupId groupId, Tag tag, Set<Long> unavailableBeIds, List<Long> availableBeIds, ColocateTableIndex colocateIndex, SystemInfoService infoService, ClusterLoadStatistic statistic, List<List<Long>> balancedBackendsPerBucketSeq) {
        boolean isChanged;
        List<Long> flatBackendsPerBucketSeq;
        short replicaNum;
        block9: {
            boolean isThisRoundChanged;
            ColocateGroupSchema groupSchema = colocateIndex.getGroupSchema(groupId);
            replicaNum = groupSchema.getReplicaAlloc().getReplicaNumByTag(tag);
            List backendsPerBucketSeq = Lists.newArrayList(colocateIndex.getBackendsPerBucketSeqByTag(groupId, tag));
            flatBackendsPerBucketSeq = backendsPerBucketSeq.stream().flatMap(Collection::stream).collect(Collectors.toList());
            isChanged = false;
            block0: do {
                List<Map.Entry<Long, Long>> backendWithReplicaNum;
                List<List<String>> hostsPerBucketSeq;
                if ((hostsPerBucketSeq = this.getHostsPerBucketSeq(backendsPerBucketSeq = Lists.partition(flatBackendsPerBucketSeq, (int)replicaNum), infoService)) == null) {
                    return false;
                }
                Preconditions.checkState((backendsPerBucketSeq.size() == hostsPerBucketSeq.size() ? 1 : 0) != 0);
                long srcBeId = -1L;
                List<Integer> seqIndexes = null;
                boolean hasUnavailableBe = false;
                for (Long beId : unavailableBeIds) {
                    seqIndexes = this.getBeSeqIndexes(flatBackendsPerBucketSeq, beId);
                    if (seqIndexes.isEmpty()) continue;
                    srcBeId = beId;
                    hasUnavailableBe = true;
                    break;
                }
                if ((backendWithReplicaNum = this.getSortedBackendReplicaNumPairs(availableBeIds, unavailableBeIds, statistic, flatBackendsPerBucketSeq)).size() <= 1) break block9;
                if (seqIndexes == null || seqIndexes.isEmpty()) {
                    Preconditions.checkState((backendsPerBucketSeq.size() > 0 ? 1 : 0) != 0);
                    srcBeId = backendWithReplicaNum.get(0).getKey();
                    seqIndexes = this.getBeSeqIndexes(flatBackendsPerBucketSeq, srcBeId);
                }
                isThisRoundChanged = false;
                for (int j = backendWithReplicaNum.size() - 1; j >= 0; --j) {
                    Map.Entry<Long, Long> lowBackend = backendWithReplicaNum.get(j);
                    if (hasUnavailableBe || (long)seqIndexes.size() - lowBackend.getValue() > 1L) {
                        long destBeId = lowBackend.getKey();
                        Backend destBe = infoService.getBackend(destBeId);
                        if (destBe == null) {
                            LOG.info("backend {} does not exist", (Object)destBeId);
                            return false;
                        }
                        if (srcBeId == destBeId) continue;
                        for (int seqIndex : seqIndexes) {
                            int bucketIndex = seqIndex / replicaNum;
                            List backendsSet = (List)backendsPerBucketSeq.get(bucketIndex);
                            List<String> hostsSet = hostsPerBucketSeq.get(bucketIndex);
                            if (backendsSet.contains(destBeId) || hostsSet.contains(destBe.getHost())) continue;
                            Preconditions.checkState((boolean)backendsSet.contains(srcBeId), (Object)srcBeId);
                            flatBackendsPerBucketSeq.set(seqIndex, destBeId);
                            LOG.info("replace backend {} with backend {} in colocate group {}, idx: {}", (Object)srcBeId, (Object)destBeId, (Object)groupId, (Object)seqIndex);
                            isChanged = true;
                            isThisRoundChanged = true;
                            break;
                        }
                        if (isThisRoundChanged) continue block0;
                        LOG.info("unable to replace backend {} with backend {} in colocate group {}", (Object)srcBeId, (Object)destBeId, (Object)groupId);
                        continue;
                    }
                    break block9;
                }
            } while (isThisRoundChanged);
            LOG.info("all backends are checked but this round is not changed, end outer loop in colocate group {}", (Object)groupId);
        }
        if (isChanged) {
            balancedBackendsPerBucketSeq.addAll(Lists.partition(flatBackendsPerBucketSeq, (int)replicaNum));
        }
        return isChanged;
    }

    private List<List<String>> getHostsPerBucketSeq(List<List<Long>> backendsPerBucketSeq, SystemInfoService infoService) {
        ArrayList hostsPerBucketSeq = Lists.newArrayList();
        for (List<Long> backendIds : backendsPerBucketSeq) {
            ArrayList hosts = Lists.newArrayList();
            for (Long beId : backendIds) {
                Backend be = infoService.getBackend(beId);
                if (be == null) {
                    hosts.add("0.0.0.0");
                    continue;
                }
                hosts.add(be.getHost());
            }
            hostsPerBucketSeq.add(hosts);
        }
        return hostsPerBucketSeq;
    }

    private List<Map.Entry<Long, Long>> getSortedBackendReplicaNumPairs(List<Long> allAvailBackendIds, Set<Long> unavailBackendIds, ClusterLoadStatistic statistic, List<Long> flatBackendsPerBucketSeq) {
        Map backendToReplicaNum = flatBackendsPerBucketSeq.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (Long backendId : unavailBackendIds) {
            backendToReplicaNum.remove(backendId);
        }
        for (Long backendId : allAvailBackendIds) {
            if (backendToReplicaNum.containsKey(backendId)) continue;
            backendToReplicaNum.put(backendId, 0L);
        }
        return backendToReplicaNum.entrySet().stream().sorted((entry1, entry2) -> {
            double loadScore2;
            if (!((Long)entry1.getValue()).equals(entry2.getValue())) {
                return (int)((Long)entry2.getValue() - (Long)entry1.getValue());
            }
            BackendLoadStatistic beStat1 = statistic.getBackendLoadStatistic((Long)entry1.getKey());
            BackendLoadStatistic beStat2 = statistic.getBackendLoadStatistic((Long)entry2.getKey());
            if (beStat1 == null || beStat2 == null) {
                return 0;
            }
            double loadScore1 = beStat1.getMixLoadScore();
            if (Math.abs(loadScore1 - (loadScore2 = beStat2.getMixLoadScore())) < 1.0E-6) {
                return 0;
            }
            if (loadScore2 > loadScore1) {
                return 1;
            }
            return -1;
        }).collect(Collectors.toList());
    }

    private List<Integer> getBeSeqIndexes(List<Long> flatBackendsPerBucketSeq, long beId) {
        return IntStream.range(0, flatBackendsPerBucketSeq.size()).boxed().filter(idx -> ((Long)flatBackendsPerBucketSeq.get((int)idx)).equals(beId)).collect(Collectors.toList());
    }

    private Set<Long> getUnavailableBeIdsInGroup(SystemInfoService infoService, ColocateTableIndex colocateIndex, ColocateTableIndex.GroupId groupId, Tag tag) {
        Set<Long> backends = colocateIndex.getBackendsByGroup(groupId, tag);
        HashSet unavailableBeIds = Sets.newHashSet();
        for (Long backendId : backends) {
            if (this.checkBackendAvailable(backendId, tag, Sets.newHashSet(), infoService, Config.colocate_group_relocate_delay_second)) continue;
            unavailableBeIds.add(backendId);
        }
        return unavailableBeIds;
    }

    private List<Long> getAvailableBeIds(String cluster, Tag tag, Set<Long> excludedBeIds, SystemInfoService infoService) {
        List<Long> allBackendIds = infoService.getClusterBackendIds(cluster, false);
        ArrayList availableBeIds = Lists.newArrayList();
        for (Long backendId : allBackendIds) {
            if (!this.checkBackendAvailable(backendId, tag, excludedBeIds, infoService, Config.colocate_group_relocate_delay_second)) continue;
            availableBeIds.add(backendId);
        }
        return availableBeIds;
    }

    private boolean checkBackendAvailable(Long backendId, Tag tag, Set<Long> excludedBeIds, SystemInfoService infoService, long delaySecond) {
        long currTime = System.currentTimeMillis();
        Backend be = infoService.getBackend(backendId);
        if (be == null) {
            return false;
        }
        if (!be.getTag().equals(tag) || excludedBeIds.contains(be.getId())) {
            return false;
        }
        return be.isScheduleAvailable() || (be.isAlive() || currTime - be.getLastUpdateMs() <= delaySecond * 1000L) && !be.isDecommissioned();
    }
}

