/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.clone.BackendLoadStatistic;
import org.apache.doris.clone.LoadBalanceException;
import org.apache.doris.clone.RootPathLoadStatistic;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterLoadStatistic {
    private static final Logger LOG = LogManager.getLogger(ClusterLoadStatistic.class);
    private SystemInfoService infoService;
    private TabletInvertedIndex invertedIndex;
    private String clusterName;
    private Tag tag;
    private Map<TStorageMedium, Long> totalCapacityMap = Maps.newHashMap();
    private Map<TStorageMedium, Long> totalUsedCapacityMap = Maps.newHashMap();
    private Map<TStorageMedium, Long> totalReplicaNumMap = Maps.newHashMap();
    private Map<TStorageMedium, Double> avgUsedCapacityPercentMap = Maps.newHashMap();
    private Map<TStorageMedium, Double> avgReplicaNumPercentMap = Maps.newHashMap();
    private Map<TStorageMedium, Double> avgLoadScoreMap = Maps.newHashMap();
    private Map<TStorageMedium, Integer> backendNumMap = Maps.newHashMap();
    private List<BackendLoadStatistic> beLoadStatistics = Lists.newArrayList();
    private Map<TStorageMedium, TreeMultimap<Long, Long>> beByTotalReplicaCountMaps = Maps.newHashMap();
    private Map<TStorageMedium, TreeMultimap<Long, TabletInvertedIndex.PartitionBalanceInfo>> skewMaps = Maps.newHashMap();

    public ClusterLoadStatistic(String clusterName, Tag tag, SystemInfoService infoService, TabletInvertedIndex invertedIndex) {
        this.clusterName = clusterName;
        this.tag = tag;
        this.infoService = infoService;
        this.invertedIndex = invertedIndex;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void init() {
        List<Backend> backends = this.infoService.getBackendsByTagInCluster(this.clusterName, this.tag);
        for (Backend backend : backends) {
            if (backend.isDecommissioned()) continue;
            BackendLoadStatistic beStatistic = new BackendLoadStatistic(backend.getId(), backend.getOwnerClusterName(), backend.getTag(), this.infoService, this.invertedIndex);
            try {
                beStatistic.init();
            }
            catch (LoadBalanceException e) {
                LOG.info(e.getMessage());
                continue;
            }
            for (TStorageMedium medium : TStorageMedium.values()) {
                this.totalCapacityMap.put(medium, this.totalCapacityMap.getOrDefault(medium, 0L) + beStatistic.getTotalCapacityB(medium));
                this.totalUsedCapacityMap.put(medium, this.totalUsedCapacityMap.getOrDefault(medium, 0L) + beStatistic.getTotalUsedCapacityB(medium));
                this.totalReplicaNumMap.put(medium, this.totalReplicaNumMap.getOrDefault(medium, 0L) + beStatistic.getReplicaNum(medium));
                if (!beStatistic.hasMedium(medium)) continue;
                this.backendNumMap.put(medium, this.backendNumMap.getOrDefault(medium, 0) + 1);
            }
            this.beLoadStatistics.add(beStatistic);
        }
        for (Object medium : TStorageMedium.values()) {
            this.avgUsedCapacityPercentMap.put((TStorageMedium)medium, (double)this.totalUsedCapacityMap.getOrDefault(medium, 0L).longValue() / (double)this.totalCapacityMap.getOrDefault(medium, 1L).longValue());
            this.avgReplicaNumPercentMap.put((TStorageMedium)medium, (double)this.totalReplicaNumMap.getOrDefault(medium, 0L).longValue() / (double)this.backendNumMap.getOrDefault(medium, 1).intValue());
        }
        for (BackendLoadStatistic beStatistic : this.beLoadStatistics) {
            beStatistic.calcScore(this.avgUsedCapacityPercentMap, this.avgReplicaNumPercentMap);
        }
        for (Object medium : TStorageMedium.values()) {
            this.classifyBackendByLoad((TStorageMedium)medium);
        }
        Collections.sort(this.beLoadStatistics, BackendLoadStatistic.MIX_COMPARATOR);
        for (Object medium : TStorageMedium.values()) {
            TreeMultimap beByTotalReplicaCount = TreeMultimap.create();
            this.beLoadStatistics.stream().filter(BackendLoadStatistic::isAvailable).forEach(arg_0 -> ClusterLoadStatistic.lambda$init$0(beByTotalReplicaCount, (TStorageMedium)medium, arg_0));
            this.beByTotalReplicaCountMaps.put((TStorageMedium)medium, (TreeMultimap<Long, Long>)beByTotalReplicaCount);
        }
        if (Config.tablet_rebalancer_type.equalsIgnoreCase("Partition")) {
            this.skewMaps = this.invertedIndex.buildPartitionInfoBySkew(this.beLoadStatistics.stream().filter(BackendLoadStatistic::isAvailable).map(BackendLoadStatistic::getBeId).collect(Collectors.toList()));
        }
    }

    private void classifyBackendByLoad(TStorageMedium medium) {
        if (this.backendNumMap.getOrDefault(medium, 0) == 0) {
            return;
        }
        double totalLoadScore = 0.0;
        for (BackendLoadStatistic beStat : this.beLoadStatistics) {
            totalLoadScore += beStat.getLoadScore(medium);
        }
        double avgLoadScore = totalLoadScore / (double)this.backendNumMap.get(medium).intValue();
        this.avgLoadScoreMap.put(medium, avgLoadScore);
        int lowCounter = 0;
        int midCounter = 0;
        int highCounter = 0;
        for (BackendLoadStatistic beStat : this.beLoadStatistics) {
            if (!beStat.hasMedium(medium)) continue;
            if (Math.abs(beStat.getLoadScore(medium) - avgLoadScore) / avgLoadScore > Config.balance_load_score_threshold) {
                if (beStat.getLoadScore(medium) > avgLoadScore) {
                    beStat.setClazz(medium, BackendLoadStatistic.Classification.HIGH);
                    ++highCounter;
                    continue;
                }
                if (!(beStat.getLoadScore(medium) < avgLoadScore)) continue;
                beStat.setClazz(medium, BackendLoadStatistic.Classification.LOW);
                ++lowCounter;
                continue;
            }
            beStat.setClazz(medium, BackendLoadStatistic.Classification.MID);
            ++midCounter;
        }
        LOG.debug("classify backend by load. medium: {} avg load score: {}. low/mid/high: {}/{}/{}", (Object)medium, (Object)avgLoadScore, (Object)lowCounter, (Object)midCounter, (Object)highCounter);
    }

    private static void sortBeStats(List<BackendLoadStatistic> beStats, TStorageMedium medium) {
        if (medium == null) {
            Collections.sort(beStats, BackendLoadStatistic.MIX_COMPARATOR);
        } else if (medium == TStorageMedium.HDD) {
            Collections.sort(beStats, BackendLoadStatistic.HDD_COMPARATOR);
        } else {
            Collections.sort(beStats, BackendLoadStatistic.SSD_COMPARATOR);
        }
    }

    public boolean isMoreBalanced(long srcBeId, long destBeId, long tabletId, long tabletSize, TStorageMedium medium) {
        BackendLoadStatistic srcBeStat = null;
        Optional<BackendLoadStatistic> optSrcBeStat = this.beLoadStatistics.stream().filter(t -> t.getBeId() == srcBeId).findFirst();
        if (!optSrcBeStat.isPresent()) {
            return false;
        }
        srcBeStat = optSrcBeStat.get();
        BackendLoadStatistic destBeStat = null;
        Optional<BackendLoadStatistic> optDestBeStat = this.beLoadStatistics.stream().filter(t -> t.getBeId() == destBeId).findFirst();
        if (!optDestBeStat.isPresent()) {
            return false;
        }
        destBeStat = optDestBeStat.get();
        if (!srcBeStat.hasMedium(medium) || !destBeStat.hasMedium(medium)) {
            return false;
        }
        double currentSrcBeScore = srcBeStat.getLoadScore(medium);
        double currentDestBeScore = destBeStat.getLoadScore(medium);
        BackendLoadStatistic.LoadScore newSrcBeScore = BackendLoadStatistic.calcSore(srcBeStat.getTotalUsedCapacityB(medium) - tabletSize, srcBeStat.getTotalCapacityB(medium), srcBeStat.getReplicaNum(medium) - 1L, this.avgUsedCapacityPercentMap.get(medium), this.avgReplicaNumPercentMap.get(medium));
        BackendLoadStatistic.LoadScore newDestBeScore = BackendLoadStatistic.calcSore(destBeStat.getTotalUsedCapacityB(medium) + tabletSize, destBeStat.getTotalCapacityB(medium), destBeStat.getReplicaNum(medium) + 1L, this.avgUsedCapacityPercentMap.get(medium), this.avgReplicaNumPercentMap.get(medium));
        double currentDiff = Math.abs(currentSrcBeScore - this.avgLoadScoreMap.get(medium)) + Math.abs(currentDestBeScore - this.avgLoadScoreMap.get(medium));
        double newDiff = Math.abs(newSrcBeScore.score - this.avgLoadScoreMap.get(medium)) + Math.abs(newDestBeScore.score - this.avgLoadScoreMap.get(medium));
        LOG.debug("after migrate {}(size: {}) from {} to {}, medium: {}, the load score changed. src: {} -> {}, dest: {}->{}, average score: {}. current diff: {}, new diff: {}, more balanced: {}", new Object[]{tabletId, tabletSize, srcBeId, destBeId, medium, currentSrcBeScore, newSrcBeScore.score, currentDestBeScore, newDestBeScore.score, this.avgLoadScoreMap.get(medium), currentDiff, newDiff, newDiff < currentDiff});
        return newDiff < currentDiff;
    }

    public List<List<String>> getClusterStatistic(TStorageMedium medium) {
        ArrayList statistics = Lists.newArrayList();
        for (BackendLoadStatistic beStatistic : this.beLoadStatistics) {
            if (!beStatistic.hasMedium(medium)) continue;
            List<String> beStat = beStatistic.getInfo(medium);
            statistics.add(beStat);
        }
        return statistics;
    }

    public List<List<String>> getBackendStatistic(long beId) {
        ArrayList statistics = Lists.newArrayList();
        for (BackendLoadStatistic beStatistic : this.beLoadStatistics) {
            if (beStatistic.getBeId() != beId) continue;
            for (RootPathLoadStatistic pathStatistic : beStatistic.getPathStatistics()) {
                ArrayList pathStat = Lists.newArrayList();
                pathStat.add(pathStatistic.getPath());
                pathStat.add(String.valueOf(pathStatistic.getPathHash()));
                pathStat.add(pathStatistic.getStorageMedium().name());
                pathStat.add(String.valueOf(pathStatistic.getUsedCapacityB()));
                pathStat.add(String.valueOf(pathStatistic.getCapacityB()));
                pathStat.add(String.valueOf(DebugUtil.DECIMAL_FORMAT_SCALE_3.format((double)(pathStatistic.getUsedCapacityB() * 100L) / (double)pathStatistic.getCapacityB())));
                pathStat.add(pathStatistic.getClazz().name());
                pathStat.add(pathStatistic.getDiskState().name());
                statistics.add(pathStat);
            }
        }
        return statistics;
    }

    public BackendLoadStatistic getBackendLoadStatistic(long beId) {
        for (BackendLoadStatistic backendLoadStatistic : this.beLoadStatistics) {
            if (backendLoadStatistic.getBeId() != beId) continue;
            return backendLoadStatistic;
        }
        return null;
    }

    public void getBackendStatisticByClass(List<BackendLoadStatistic> low, List<BackendLoadStatistic> mid, List<BackendLoadStatistic> high, TStorageMedium medium) {
        for (BackendLoadStatistic beStat : this.beLoadStatistics) {
            BackendLoadStatistic.Classification clazz = beStat.getClazz(medium);
            switch (clazz) {
                case LOW: {
                    low.add(beStat);
                    break;
                }
                case MID: {
                    mid.add(beStat);
                    break;
                }
                case HIGH: {
                    high.add(beStat);
                    break;
                }
            }
        }
        if (low.isEmpty() && high.isEmpty()) {
            return;
        }
        if (low.isEmpty()) {
            low.addAll(mid);
            mid.clear();
        } else if (high.isEmpty()) {
            high.addAll(mid);
            mid.clear();
        }
        ClusterLoadStatistic.sortBeStats(low, medium);
        ClusterLoadStatistic.sortBeStats(mid, medium);
        ClusterLoadStatistic.sortBeStats(high, medium);
        LOG.debug("after adjust, cluster {} backend classification low/mid/high: {}/{}/{}, medium: {}", (Object)this.clusterName, (Object)low.size(), (Object)mid.size(), (Object)high.size(), (Object)medium);
    }

    public List<BackendLoadStatistic> getSortedBeLoadStats(TStorageMedium medium) {
        if (medium != null) {
            List<BackendLoadStatistic> beStatsWithMedium = this.beLoadStatistics.stream().filter(b -> b.hasMedium(medium)).collect(Collectors.toList());
            ClusterLoadStatistic.sortBeStats(beStatsWithMedium, medium);
            return beStatsWithMedium;
        }
        return this.beLoadStatistics;
    }

    public String getBrief() {
        StringBuilder sb = new StringBuilder();
        for (BackendLoadStatistic backendLoadStatistic : this.beLoadStatistics) {
            sb.append("    ").append(backendLoadStatistic.getBrief()).append("\n");
        }
        return sb.toString();
    }

    public TreeMultimap<Long, Long> getBeByTotalReplicaMap(TStorageMedium medium) {
        return this.beByTotalReplicaCountMaps.get(medium);
    }

    public TreeMultimap<Long, TabletInvertedIndex.PartitionBalanceInfo> getSkewMap(TStorageMedium medium) {
        return this.skewMaps.get(medium);
    }

    private static /* synthetic */ void lambda$init$0(TreeMultimap beByTotalReplicaCount, TStorageMedium medium, BackendLoadStatistic beStat) {
        beByTotalReplicaCount.put((Object)beStat.getReplicaNum(medium), (Object)beStat.getBeId());
    }
}

