/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.clone.BackendLoadStatistic;
import org.apache.doris.clone.BalanceStatus;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.clone.Rebalancer;
import org.apache.doris.clone.SchedException;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeLoadRebalancer
extends Rebalancer {
    private static final Logger LOG = LogManager.getLogger(BeLoadRebalancer.class);

    public BeLoadRebalancer(SystemInfoService infoService, TabletInvertedIndex invertedIndex) {
        super(infoService, invertedIndex);
    }

    @Override
    protected List<TabletSchedCtx> selectAlternativeTabletsForCluster(ClusterLoadStatistic clusterStat, TStorageMedium medium) {
        String clusterName = clusterStat.getClusterName();
        ArrayList alternativeTablets = Lists.newArrayList();
        ArrayList lowBEs = Lists.newArrayList();
        ArrayList midBEs = Lists.newArrayList();
        ArrayList highBEs = Lists.newArrayList();
        clusterStat.getBackendStatisticByClass(lowBEs, midBEs, highBEs, medium);
        if (lowBEs.isEmpty() && highBEs.isEmpty()) {
            LOG.debug("cluster is balance: {} with medium: {}. skip", (Object)clusterName, (Object)medium);
            return alternativeTablets;
        }
        if (lowBEs.stream().noneMatch(BackendLoadStatistic::isAvailable)) {
            LOG.info("all low load backends is dead: {} with medium: {}. skip", (Object)lowBEs.stream().mapToLong(BackendLoadStatistic::getBeId).toArray(), (Object)medium);
            return alternativeTablets;
        }
        if (lowBEs.stream().noneMatch(BackendLoadStatistic::hasAvailDisk)) {
            LOG.info("all low load backends {} have no available disk with medium: {}. skip", (Object)lowBEs.stream().mapToLong(BackendLoadStatistic::getBeId).toArray(), (Object)medium);
            return alternativeTablets;
        }
        long numOfLowPaths = lowBEs.stream().filter(b -> b.isAvailable() && b.hasAvailDisk()).mapToLong(b -> b.getAvailPathNum(medium)).sum();
        LOG.info("get number of low load paths: {}, with medium: {}", (Object)numOfLowPaths, (Object)medium);
        int clusterAvailableBEnum = this.infoService.getClusterBackendIds(clusterName, true).size();
        ColocateTableIndex colocateTableIndex = Catalog.getCurrentColocateIndex();
        block0: for (int i = highBEs.size() - 1; i >= 0; --i) {
            BackendLoadStatistic beStat = (BackendLoadStatistic)highBEs.get(i);
            HashSet pathLow = Sets.newHashSet();
            HashSet pathMid = Sets.newHashSet();
            HashSet pathHigh = Sets.newHashSet();
            beStat.getPathStatisticByClass(pathLow, pathMid, pathHigh, medium);
            pathHigh.addAll(pathMid);
            List<Long> tabletIds = this.invertedIndex.getTabletIdsByBackendIdAndStorageMedium(beStat.getBeId(), medium);
            Collections.shuffle(tabletIds);
            HashMap remainingPaths = Maps.newHashMap();
            for (Long pathHash : pathHigh) {
                remainingPaths.put(pathHash, 2);
            }
            if (remainingPaths.isEmpty()) {
                return alternativeTablets;
            }
            for (Long tabletId : tabletIds) {
                TabletMeta tabletMeta;
                long replicaPathHash;
                Replica replica;
                if (clusterAvailableBEnum <= this.invertedIndex.getReplicasByTabletId(tabletId).size() || (replica = this.invertedIndex.getReplica(tabletId, beStat.getBeId())) == null || !remainingPaths.containsKey(replicaPathHash = replica.getPathHash()) || (tabletMeta = this.invertedIndex.getTabletMeta(tabletId)) == null || colocateTableIndex.isColocateTable(tabletMeta.getTableId())) continue;
                TabletSchedCtx tabletCtx = new TabletSchedCtx(TabletSchedCtx.Type.BALANCE, clusterName, tabletMeta.getDbId(), tabletMeta.getTableId(), tabletMeta.getPartitionId(), tabletMeta.getIndexId(), tabletId, null, System.currentTimeMillis());
                tabletCtx.setTag(clusterStat.getTag());
                tabletCtx.setOrigPriority(TabletSchedCtx.Priority.LOW);
                alternativeTablets.add(tabletCtx);
                if (--numOfLowPaths <= 0L) break block0;
                int remaining = (Integer)remainingPaths.get(replicaPathHash) - 1;
                if (remaining <= 0) {
                    remainingPaths.remove(replicaPathHash);
                    continue;
                }
                remainingPaths.put(replicaPathHash, remaining);
            }
        }
        if (!alternativeTablets.isEmpty()) {
            LOG.info("select alternative tablets for cluster: {}, medium: {}, num: {}, detail: {}", (Object)clusterName, (Object)medium, (Object)alternativeTablets.size(), (Object)alternativeTablets.stream().mapToLong(TabletSchedCtx::getTabletId).toArray());
        }
        return alternativeTablets;
    }

    @Override
    public void completeSchedCtx(TabletSchedCtx tabletCtx, Map<Long, TabletScheduler.PathSlot> backendsWorkingSlots) throws SchedException {
        boolean bl;
        ClusterLoadStatistic clusterStat = (ClusterLoadStatistic)this.statisticMap.get((Object)tabletCtx.getCluster(), (Object)tabletCtx.getTag());
        if (clusterStat == null) {
            throw new SchedException(SchedException.Status.UNRECOVERABLE, "cluster does not exist");
        }
        ArrayList lowBe = Lists.newArrayList();
        ArrayList midBe = Lists.newArrayList();
        ArrayList highBe = Lists.newArrayList();
        clusterStat.getBackendStatisticByClass(lowBe, midBe, highBe, tabletCtx.getStorageMedium());
        if (lowBe.isEmpty() && highBe.isEmpty()) {
            throw new SchedException(SchedException.Status.UNRECOVERABLE, "cluster is balance");
        }
        if (lowBe.stream().noneMatch(BackendLoadStatistic::isAvailable)) {
            throw new SchedException(SchedException.Status.UNRECOVERABLE, "all low load backends is unavailable");
        }
        List<Replica> replicas = tabletCtx.getReplicas();
        HashSet hosts = Sets.newHashSet();
        boolean hasHighReplica = false;
        for (Replica replica : replicas) {
            Backend be;
            if (highBe.stream().anyMatch(b -> b.getBeId() == replica.getBackendId())) {
                hasHighReplica = true;
            }
            if ((be = this.infoService.getBackend(replica.getBackendId())) == null) {
                throw new SchedException(SchedException.Status.UNRECOVERABLE, "backend is dropped: " + replica.getBackendId());
            }
            hosts.add(be.getHost());
        }
        if (!hasHighReplica) {
            throw new SchedException(SchedException.Status.UNRECOVERABLE, "no replica on high load backend");
        }
        boolean setSource = false;
        for (Replica replica : replicas) {
            long pathHash;
            TabletScheduler.PathSlot slot = backendsWorkingSlots.get(replica.getBackendId());
            if (slot == null || (pathHash = slot.takeBalanceSlot(replica.getPathHash())) == -1L) continue;
            tabletCtx.setSrc(replica);
            setSource = true;
            break;
        }
        if (!setSource) {
            throw new SchedException(SchedException.Status.UNRECOVERABLE, "unable to take src slot");
        }
        boolean bl2 = false;
        for (BackendLoadStatistic beStat : lowBe) {
            Backend lowBackend;
            if (!beStat.isAvailable() || !replicas.stream().noneMatch(r -> r.getBackendId() == beStat.getBeId()) || (lowBackend = this.infoService.getBackend(beStat.getBeId())) == null || hosts.contains(lowBackend.getHost())) continue;
            ArrayList availPaths = Lists.newArrayList();
            BalanceStatus bs = beStat.isFit(tabletCtx.getTabletSize(), tabletCtx.getStorageMedium(), availPaths, false);
            if (bs != BalanceStatus.OK) {
                LOG.debug("tablet not fit in BE {}, reason: {}", (Object)beStat.getBeId(), bs.getErrMsgs());
                continue;
            }
            if (!clusterStat.isMoreBalanced(tabletCtx.getSrcBackendId(), beStat.getBeId(), tabletCtx.getTabletId(), tabletCtx.getTabletSize(), tabletCtx.getStorageMedium())) continue;
            TabletScheduler.PathSlot slot = backendsWorkingSlots.get(beStat.getBeId());
            if (slot == null) {
                LOG.debug("BE does not have slot: {}", (Object)beStat.getBeId());
                continue;
            }
            HashSet pathLow = Sets.newHashSet();
            HashSet pathMid = Sets.newHashSet();
            HashSet pathHigh = Sets.newHashSet();
            beStat.getPathStatisticByClass(pathLow, pathMid, pathHigh, tabletCtx.getStorageMedium());
            pathLow.addAll(pathMid);
            long pathHash = slot.takeAnAvailBalanceSlotFrom(pathLow);
            if (pathHash == -1L) {
                LOG.debug("paths has no available balance slot: {}", (Object)pathLow);
                continue;
            }
            tabletCtx.setDest(beStat.getBeId(), pathHash);
            bl = true;
            break;
        }
        if (!bl) {
            throw new SchedException(SchedException.Status.SCHEDULE_FAILED, "unable to find low backend");
        }
    }
}

