/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

import com.google.common.collect.Lists;
import java.util.List;

public class BalanceStatus {
    private ErrCode errCode;
    private List<String> errMsgs = Lists.newArrayList();
    public static final BalanceStatus OK = new BalanceStatus(ErrCode.OK, "");

    public BalanceStatus(ErrCode errCode) {
        this.errCode = errCode;
    }

    public BalanceStatus(ErrCode errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsgs.add(errMsg);
    }

    public ErrCode getErrCode() {
        return this.errCode;
    }

    public List<String> getErrMsgs() {
        return this.errMsgs;
    }

    public void addErrMsgs(List<String> errMsgs) {
        this.errMsgs.addAll(errMsgs);
    }

    public void addErrMsg(String errMsg) {
        this.errMsgs.add(errMsg);
    }

    public boolean ok() {
        return this.errCode == ErrCode.OK;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.errCode.name());
        if (!this.ok()) {
            sb.append(", msg: ").append(this.errMsgs);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum ErrCode {
        OK,
        META_NOT_FOUND,
        STATE_NOT_NORMAL,
        COMMON_ERROR;

    }
}

