/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.clone;

public class BackendInfo {
    private long backendId;
    private String host;
    private long totalCapacityB;
    private long availableCapacityB;
    private long cloneCapacityB;
    private int tableReplicaNum;
    private int cloneReplicaNum;

    public BackendInfo(String host, long backendId, long totalCapacityB, long availableCapacityB) {
        this.backendId = backendId;
        this.totalCapacityB = totalCapacityB;
        this.availableCapacityB = availableCapacityB;
        this.host = host;
        this.cloneCapacityB = 0L;
        this.tableReplicaNum = 0;
        this.cloneReplicaNum = 0;
    }

    public String getHost() {
        return this.host;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public long getTotalCapacityB() {
        return this.totalCapacityB;
    }

    public long getAvailableCapacityB() {
        return this.availableCapacityB;
    }

    public void setCloneCapacityB(long cloneCapacityB) {
        this.cloneCapacityB = cloneCapacityB;
    }

    public boolean canCloneByCapacity(long tabletSizeB) {
        return this.cloneCapacityB > tabletSizeB;
    }

    public void decreaseCloneCapacityB(long tabletSizeB) {
        this.cloneCapacityB -= tabletSizeB;
    }

    public int getTableReplicaNum() {
        return this.tableReplicaNum;
    }

    public void setTableReplicaNum(int tableReplicaNum) {
        this.tableReplicaNum = tableReplicaNum;
    }

    public void setCloneReplicaNum(int cloneReplicaNum) {
        this.cloneReplicaNum = cloneReplicaNum;
    }

    public boolean canCloneByDistribution() {
        return this.cloneReplicaNum > 1;
    }

    public void decreaseCloneReplicaNum() {
        --this.cloneReplicaNum;
    }
}

