/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.DeepCopy;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class View
extends Table {
    private static final Logger LOG = LogManager.getLogger(View.class);
    @Deprecated
    private String originalViewDef = "";
    private String inlineViewDef;
    private long sqlMode = 0L;
    private QueryStmt queryStmt;
    private SoftReference<QueryStmt> queryStmtRef = new SoftReference<Object>(null);
    private boolean isLocalView;
    private List<String> colLabels_;

    public View() {
        super(Table.TableType.VIEW);
        this.isLocalView = false;
    }

    public View(long id, String name, List<Column> schema) {
        super(id, name, Table.TableType.VIEW, schema);
        this.isLocalView = false;
    }

    public View(String alias, QueryStmt queryStmt, List<String> colLabels) {
        super(-1L, alias, Table.TableType.VIEW, null);
        this.isLocalView = true;
        this.queryStmt = queryStmt;
        this.colLabels_ = colLabels;
    }

    public boolean isLocalView() {
        return this.isLocalView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStmt getQueryStmt() {
        if (this.queryStmt != null) {
            return this.queryStmt;
        }
        QueryStmt retStmt = this.queryStmtRef.get();
        if (retStmt == null) {
            View view = this;
            synchronized (view) {
                retStmt = this.queryStmtRef.get();
                if (retStmt == null) {
                    try {
                        retStmt = this.init();
                    }
                    catch (UserException e) {
                        LOG.error("unexpected exception", (Throwable)e);
                    }
                }
            }
        }
        return retStmt;
    }

    public void setInlineViewDefWithSqlMode(String inlineViewDef, long sqlMode) {
        this.inlineViewDef = inlineViewDef;
        this.sqlMode = sqlMode;
    }

    public void setSqlMode(long sqlMode) {
        this.sqlMode = sqlMode;
    }

    public String getInlineViewDef() {
        return this.inlineViewDef;
    }

    @Override
    public String getDdlSql() {
        return this.inlineViewDef;
    }

    public synchronized QueryStmt init() throws UserException {
        StatementBase node;
        Preconditions.checkNotNull((Object)this.inlineViewDef);
        SqlScanner input = new SqlScanner(new StringReader(this.inlineViewDef), (Long)this.sqlMode);
        SqlParser parser = new SqlParser(input);
        try {
            node = SqlParserUtils.getFirstStmt(parser);
        }
        catch (Exception e) {
            LOG.info("stmt is {}", (Object)this.inlineViewDef);
            LOG.info("exception because: ", (Throwable)e);
            LOG.info("msg is {}", (Object)this.inlineViewDef);
            throw new UserException(String.format("Failed to parse view-definition statement of view: %s", this.name));
        }
        if (!(node instanceof QueryStmt)) {
            throw new UserException(String.format("View definition of %s is not a query statement", this.name));
        }
        this.queryStmtRef = new SoftReference<QueryStmt>((QueryStmt)node);
        return (QueryStmt)node;
    }

    public List<String> getOriginalColLabels() {
        return this.colLabels_;
    }

    public List<String> getColLabels() {
        QueryStmt stmt = this.getQueryStmt();
        if (this.colLabels_ == null) {
            return null;
        }
        if (this.colLabels_.size() >= ((ArrayList)stmt.getColLabels()).size()) {
            return this.colLabels_;
        }
        ArrayList explicitColLabels = Lists.newArrayList(this.colLabels_);
        explicitColLabels.addAll(((ArrayList)stmt.getColLabels()).subList(this.colLabels_.size(), ((ArrayList)stmt.getColLabels()).size()));
        return explicitColLabels;
    }

    public boolean hasColLabels() {
        return this.colLabels_ != null;
    }

    @Override
    public String getSignature(int signatureVersion) {
        StringBuilder sb = new StringBuilder(signatureVersion);
        sb.append(this.name);
        sb.append((Object)this.type);
        sb.append(Util.getSchemaSignatureString(this.fullSchema));
        sb.append(this.inlineViewDef);
        sb.append(this.sqlMode);
        String md5 = DigestUtils.md5Hex((String)sb.toString());
        LOG.debug("get signature of view {}: {}. signature string: {}", (Object)this.name, (Object)md5, (Object)sb.toString());
        return md5;
    }

    public View clone() {
        View copied = new View();
        if (!DeepCopy.copy((Writable)this, (Writable)copied, View.class, (int)FeConstants.meta_version)) {
            LOG.warn("failed to copy view: " + this.getName());
            return null;
        }
        copied.setSqlMode(this.sqlMode);
        return copied;
    }

    public void resetIdsForRestore(Catalog catalog) {
        this.id = catalog.getNextId();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.originalViewDef);
        Text.writeString((DataOutput)out, (String)this.inlineViewDef);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.originalViewDef = Text.readString((DataInput)in);
        this.originalViewDef = "";
        this.inlineViewDef = Text.readString((DataInput)in);
    }
}

