/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.MapType;
import org.apache.doris.catalog.MultiRowType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.StructType;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TPrimitiveType;
import org.apache.doris.thrift.TScalarType;
import org.apache.doris.thrift.TStructField;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Type {
    private static final Logger LOG;
    public static int MAX_NESTING_DEPTH;
    public static final ScalarType INVALID;
    public static final ScalarType NULL;
    public static final ScalarType BOOLEAN;
    public static final ScalarType TINYINT;
    public static final ScalarType SMALLINT;
    public static final ScalarType INT;
    public static final ScalarType BIGINT;
    public static final ScalarType LARGEINT;
    public static final ScalarType FLOAT;
    public static final ScalarType DOUBLE;
    public static final ScalarType DATE;
    public static final ScalarType DATETIME;
    public static final ScalarType TIME;
    public static final ScalarType STRING;
    public static final ScalarType DEFAULT_DECIMALV2;
    public static final ScalarType DECIMALV2;
    public static final ScalarType DEFAULT_VARCHAR;
    public static final ScalarType VARCHAR;
    public static final ScalarType HLL;
    public static final ScalarType CHAR;
    public static final ScalarType BITMAP;
    public static final ScalarType ALL;
    public static final MapType Map;
    private static ArrayList<ScalarType> integerTypes;
    private static ArrayList<ScalarType> numericTypes;
    private static ArrayList<ScalarType> supportedTypes;
    public static final String OnlyMetricTypeErrorMsg = "Doris hll and bitmap column must use with specific function, and don't support filter or group by.please run 'help hll' or 'help bitmap' in your mysql client.";
    protected static PrimitiveType[][] compatibilityMatrix;
    protected static PrimitiveType[][] strictCompatibilityMatrix;

    public static ArrayList<ScalarType> getIntegerTypes() {
        return integerTypes;
    }

    public static ArrayList<ScalarType> getNumericTypes() {
        return numericTypes;
    }

    public static ArrayList<ScalarType> getSupportedTypes() {
        return supportedTypes;
    }

    public final String toSql() {
        return this.toSql(0);
    }

    protected abstract String toSql(int var1);

    public String prettyPrint() {
        return this.prettyPrint(0);
    }

    protected abstract String prettyPrint(int var1);

    public boolean isInvalid() {
        return this.isScalarType(PrimitiveType.INVALID_TYPE);
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isNull() {
        return this.isScalarType(PrimitiveType.NULL_TYPE);
    }

    public boolean isBoolean() {
        return this.isScalarType(PrimitiveType.BOOLEAN);
    }

    public boolean isDecimalV2() {
        return this.isScalarType(PrimitiveType.DECIMALV2);
    }

    public boolean isWildcardDecimal() {
        return false;
    }

    public boolean isWildcardVarchar() {
        return false;
    }

    public boolean isWildcardChar() {
        return false;
    }

    public boolean isStringType() {
        return this.isScalarType(PrimitiveType.VARCHAR) || this.isScalarType(PrimitiveType.CHAR) || this.isScalarType(PrimitiveType.STRING);
    }

    public boolean isOnlyMetricType() {
        return this.isScalarType(PrimitiveType.HLL) || this.isScalarType(PrimitiveType.BITMAP);
    }

    public boolean isHllType() {
        return this.isScalarType(PrimitiveType.HLL);
    }

    public boolean isBitmapType() {
        return this.isScalarType(PrimitiveType.BITMAP);
    }

    public boolean isObjectStored() {
        return this.isHllType() || this.isBitmapType();
    }

    public boolean isScalarType() {
        return this instanceof ScalarType;
    }

    public boolean isScalarType(PrimitiveType t) {
        return this.isScalarType() && ((ScalarType)this).getPrimitiveType() == t;
    }

    public boolean isFixedPointType() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT) || this.isScalarType(PrimitiveType.BIGINT) || this.isScalarType(PrimitiveType.LARGEINT);
    }

    public boolean isFloatingPointType() {
        return this.isScalarType(PrimitiveType.FLOAT) || this.isScalarType(PrimitiveType.DOUBLE);
    }

    public boolean isIntegerType() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT) || this.isScalarType(PrimitiveType.BIGINT);
    }

    public boolean isInteger32Type() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT);
    }

    public boolean isLargeIntType() {
        return this.isScalarType(PrimitiveType.LARGEINT);
    }

    public boolean isFixedLengthType() {
        return false;
    }

    public boolean isNumericType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isDecimalV2();
    }

    public boolean isNativeType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isBoolean();
    }

    public boolean isDateType() {
        return this.isScalarType(PrimitiveType.DATE) || this.isScalarType(PrimitiveType.DATETIME);
    }

    public boolean isDatetime() {
        return this.isScalarType(PrimitiveType.DATETIME);
    }

    public boolean isTime() {
        return this.isScalarType(PrimitiveType.TIME);
    }

    public boolean isComplexType() {
        return this.isStructType() || this.isCollectionType();
    }

    public boolean isCollectionType() {
        return this.isMapType() || this.isArrayType() || this.isMultiRowType();
    }

    public boolean isMapType() {
        return this instanceof MapType;
    }

    public boolean isArrayType() {
        return this instanceof ArrayType;
    }

    public boolean isMultiRowType() {
        return this instanceof MultiRowType;
    }

    public boolean isStructType() {
        return this instanceof StructType;
    }

    public boolean isDate() {
        return this.isScalarType(PrimitiveType.DATE);
    }

    public boolean isSupported() {
        return true;
    }

    public int getLength() {
        return -1;
    }

    public boolean supportsTablePartitioning() {
        return false;
    }

    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.INVALID_TYPE;
    }

    public int getSlotSize() {
        if (this.isCollectionType()) {
            return 16;
        }
        throw new IllegalStateException("getSlotSize() not implemented for type " + this.toSql());
    }

    public TTypeDesc toThrift() {
        TTypeDesc container = new TTypeDesc();
        container.setTypes(new ArrayList());
        this.toThrift(container);
        return container;
    }

    public TColumnType toColumnTypeThrift() {
        return null;
    }

    public abstract void toThrift(TTypeDesc var1);

    public boolean matchesType(Type t) {
        return false;
    }

    public static boolean isImplicitlyCastable(Type t1, Type t2, boolean strict) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.isImplicitlyCastable((ScalarType)t1, (ScalarType)t2, strict);
        }
        if (t1.isComplexType() || t2.isComplexType()) {
            if (t1.isArrayType() && t2.isArrayType()) {
                return true;
            }
            if (t1.isMapType() && t2.isMapType()) {
                return true;
            }
            return t1.isStructType() && t2.isStructType();
        }
        return false;
    }

    public static boolean canCastTo(Type t1, Type t2) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.canCastTo((ScalarType)t1, (ScalarType)t2);
        }
        return false;
    }

    public static Type getAssignmentCompatibleType(Type t1, Type t2, boolean strict) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.getAssignmentCompatibleType((ScalarType)t1, (ScalarType)t2, strict);
        }
        return ScalarType.INVALID;
    }

    public static Type getNextNumType(Type t) {
        switch (t.getPrimitiveType()) {
            case BOOLEAN: {
                return TINYINT;
            }
            case TINYINT: {
                return SMALLINT;
            }
            case SMALLINT: {
                return INT;
            }
            case INT: {
                return BIGINT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: {
                return DOUBLE;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
        }
        return INVALID;
    }

    public static Long tryParseToLong(Expr expectStringExpr) {
        if (expectStringExpr instanceof StringLiteral) {
            String value = ((StringLiteral)expectStringExpr).getValue();
            return Longs.tryParse((String)value);
        }
        return null;
    }

    public boolean exceedsMaxNestingDepth() {
        return this.exceedsMaxNestingDepth(0);
    }

    private boolean exceedsMaxNestingDepth(int d) {
        if (d >= MAX_NESTING_DEPTH) {
            return true;
        }
        if (this.isStructType()) {
            StructType structType = (StructType)this;
            for (StructField f : structType.getFields()) {
                if (!f.getType().exceedsMaxNestingDepth(d + 1)) continue;
                return true;
            }
        } else if (this.isArrayType()) {
            ArrayType arrayType = (ArrayType)this;
            if (arrayType.getItemType().exceedsMaxNestingDepth(d + 1)) {
                return true;
            }
        } else if (this.isMultiRowType()) {
            MultiRowType multiRowType = (MultiRowType)this;
            if (multiRowType.getItemType().exceedsMaxNestingDepth(d + 1)) {
                return true;
            }
        } else if (this.isMapType()) {
            MapType mapType = (MapType)this;
            if (mapType.getValueType().exceedsMaxNestingDepth(d + 1)) {
                return true;
            }
        } else {
            Preconditions.checkState((boolean)this.isScalarType());
        }
        return false;
    }

    public static Type fromPrimitiveType(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case TIME: {
                return TIME;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case CHAR: {
                return CHAR;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case STRING: {
                return STRING;
            }
            case HLL: {
                return HLL;
            }
            case ARRAY: {
                return ArrayType.create();
            }
            case MAP: {
                return new MapType();
            }
            case STRUCT: {
                return new StructType();
            }
            case BITMAP: {
                return BITMAP;
            }
        }
        return null;
    }

    public static List<TTypeDesc> toThrift(Type[] types) {
        return Type.toThrift(Lists.newArrayList((Object[])types));
    }

    public static List<TTypeDesc> toThrift(ArrayList<Type> types) {
        ArrayList result = Lists.newArrayList();
        for (Type t : types) {
            result.add(t.toThrift());
        }
        return result;
    }

    public static Type fromThrift(TTypeDesc thrift) {
        Preconditions.checkState((thrift.types.size() > 0 ? 1 : 0) != 0);
        Pair<Type, Integer> t = Type.fromThrift(thrift, 0);
        Preconditions.checkState((boolean)((Integer)t.second).equals(thrift.getTypesSize()));
        return (Type)t.first;
    }

    protected static Pair<Type, Integer> fromThrift(TTypeDesc col, int nodeIdx) {
        TTypeNode node = (TTypeNode)col.getTypes().get(nodeIdx);
        Type type = null;
        int tmpNodeIdx = nodeIdx;
        switch (node.getType()) {
            case SCALAR: {
                Preconditions.checkState((boolean)node.isSetScalarType());
                TScalarType scalarType = node.getScalarType();
                if (scalarType.getType() == TPrimitiveType.CHAR) {
                    Preconditions.checkState((boolean)scalarType.isSetLen());
                    type = ScalarType.createCharType(scalarType.getLen());
                } else if (scalarType.getType() == TPrimitiveType.VARCHAR) {
                    Preconditions.checkState((boolean)scalarType.isSetLen());
                    type = ScalarType.createVarcharType(scalarType.getLen());
                } else if (scalarType.getType() == TPrimitiveType.HLL) {
                    type = ScalarType.createHllType();
                } else if (scalarType.getType() == TPrimitiveType.DECIMALV2) {
                    Preconditions.checkState((scalarType.isSetPrecision() && scalarType.isSetPrecision() ? 1 : 0) != 0);
                    type = ScalarType.createDecimalV2Type(scalarType.getPrecision(), scalarType.getScale());
                } else {
                    type = ScalarType.createType(PrimitiveType.fromThrift(scalarType.getType()));
                }
                ++tmpNodeIdx;
                break;
            }
            case ARRAY: {
                Preconditions.checkState((tmpNodeIdx + 1 < col.getTypesSize() ? 1 : 0) != 0);
                Pair<Type, Integer> childType = Type.fromThrift(col, tmpNodeIdx + 1);
                type = new ArrayType((Type)childType.first);
                tmpNodeIdx = (Integer)childType.second;
                break;
            }
            case MAP: {
                Preconditions.checkState((tmpNodeIdx + 2 < col.getTypesSize() ? 1 : 0) != 0);
                Pair<Type, Integer> keyType = Type.fromThrift(col, tmpNodeIdx + 1);
                Pair<Type, Integer> valueType = Type.fromThrift(col, (Integer)keyType.second);
                type = new MapType((Type)keyType.first, (Type)valueType.first);
                tmpNodeIdx = (Integer)valueType.second;
                break;
            }
            case STRUCT: {
                Preconditions.checkState((tmpNodeIdx + node.getStructFieldsSize() < col.getTypesSize() ? 1 : 0) != 0);
                ArrayList structFields = Lists.newArrayList();
                ++tmpNodeIdx;
                for (int i = 0; i < node.getStructFieldsSize(); ++i) {
                    TStructField thriftField = (TStructField)node.getStructFields().get(i);
                    String name = thriftField.getName();
                    String comment = null;
                    if (thriftField.isSetComment()) {
                        comment = thriftField.getComment();
                    }
                    Pair<Type, Integer> res = Type.fromThrift(col, tmpNodeIdx);
                    tmpNodeIdx = (Integer)res.second;
                    structFields.add(new StructField(name, (Type)res.first, comment));
                }
                type = new StructType(structFields);
                break;
            }
        }
        return new Pair<Object, Integer>(type, tmpNodeIdx);
    }

    public TPrimitiveType getTPrimitiveType(TTypeDesc ttype) {
        Preconditions.checkState((ttype.getTypesSize() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((((TTypeNode)ttype.types.get(0)).getType() == TTypeNodeType.SCALAR ? 1 : 0) != 0);
        return ((TTypeNode)ttype.types.get((int)0)).scalar_type.getType();
    }

    public Integer getColumnSize() {
        if (!this.isScalarType()) {
            return null;
        }
        if (this.isNumericType()) {
            return this.getPrecision();
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case HLL: {
                return t.getLength();
            }
        }
        return null;
    }

    public int getColumnStringRepSize() throws DdlException {
        if (this.isScalarType(PrimitiveType.FLOAT)) {
            return 24;
        }
        if (this.isScalarType(PrimitiveType.DOUBLE)) {
            return 32;
        }
        if (this.isNumericType()) {
            int size = this.getPrecision() + 1;
            if (this.isScalarType(PrimitiveType.DECIMALV2)) {
                ++size;
            }
            return size;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case CHAR: 
            case VARCHAR: {
                return t.getLength();
            }
            case STRING: {
                return Integer.MAX_VALUE;
            }
        }
        throw new DdlException("Can not change " + (Object)((Object)t.getPrimitiveType()) + " to char/varchar/string");
    }

    public Integer getPrecision() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case LARGEINT: {
                return 39;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case DECIMALV2: {
                return t.decimalPrecision();
            }
        }
        return null;
    }

    public Integer getDecimalDigits() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return 0;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case DECIMALV2: {
                return t.decimalScale();
            }
        }
        return null;
    }

    public Integer getNumPrecRadix() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMALV2: {
                return 10;
            }
        }
        return null;
    }

    public Type getResultType() {
        switch (this.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: 
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: 
            case DATETIME: 
            case TIME: 
            case CHAR: 
            case VARCHAR: 
            case HLL: 
            case BITMAP: {
                return VARCHAR;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case STRING: {
                return STRING;
            }
        }
        return INVALID;
    }

    public static Type getCmpType(Type t1, Type t2) {
        if (t1.getPrimitiveType() == PrimitiveType.NULL_TYPE) {
            return t2;
        }
        if (t2.getPrimitiveType() == PrimitiveType.NULL_TYPE) {
            return t1;
        }
        PrimitiveType t1ResultType = t1.getResultType().getPrimitiveType();
        PrimitiveType t2ResultType = t2.getResultType().getPrimitiveType();
        if (Type.canCompareDate(t1.getPrimitiveType(), t2.getPrimitiveType())) {
            return DATETIME;
        }
        if (t1ResultType == PrimitiveType.VARCHAR && t2ResultType == PrimitiveType.VARCHAR) {
            return VARCHAR;
        }
        if (t1ResultType == PrimitiveType.STRING && t2ResultType == PrimitiveType.STRING || t1ResultType == PrimitiveType.STRING && t2ResultType == PrimitiveType.VARCHAR || t1ResultType == PrimitiveType.VARCHAR && t2ResultType == PrimitiveType.STRING) {
            return STRING;
        }
        if (t1ResultType.isFixedPointType() && t2ResultType.isCharFamily() || t2ResultType.isFixedPointType() && t1ResultType.isCharFamily()) {
            return t1.isStringType() ? t1 : t2;
        }
        if (t1ResultType == PrimitiveType.BIGINT && t2ResultType == PrimitiveType.BIGINT) {
            return Type.getAssignmentCompatibleType(t1, t2, false);
        }
        if (!(t1ResultType != PrimitiveType.BIGINT && t1ResultType != PrimitiveType.DECIMALV2 || t2ResultType != PrimitiveType.BIGINT && t2ResultType != PrimitiveType.DECIMALV2)) {
            return DECIMALV2;
        }
        if (!(t1ResultType != PrimitiveType.BIGINT && t1ResultType != PrimitiveType.LARGEINT || t2ResultType != PrimitiveType.BIGINT && t2ResultType != PrimitiveType.LARGEINT)) {
            return LARGEINT;
        }
        return DOUBLE;
    }

    public static boolean canCompareDate(PrimitiveType t1, PrimitiveType t2) {
        if (t1.isDateType()) {
            return t2.isDateType() || t2.isStringType() || t2.isIntegerType();
        }
        if (t2.isDateType()) {
            return t1.isStringType() || t1.isIntegerType();
        }
        return false;
    }

    public Type getMaxResolutionType() {
        Preconditions.checkState((boolean)true, (Object)"must implemented");
        return null;
    }

    public Type getNumResultType() {
        switch (this.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DATE: 
            case DATETIME: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: 
            case DOUBLE: 
            case TIME: 
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case HLL: {
                return DOUBLE;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
        }
        return INVALID;
    }

    public int getStorageLayoutBytes() {
        return 0;
    }

    public int getIndexSize() {
        if (this.getPrimitiveType() == PrimitiveType.CHAR) {
            return ((ScalarType)this).getLength();
        }
        return this.getPrimitiveType().getOlapColumnIndexSize();
    }

    static {
        int i;
        LOG = LogManager.getLogger(Type.class);
        MAX_NESTING_DEPTH = 2;
        INVALID = new ScalarType(PrimitiveType.INVALID_TYPE);
        NULL = new ScalarType(PrimitiveType.NULL_TYPE);
        BOOLEAN = new ScalarType(PrimitiveType.BOOLEAN);
        TINYINT = new ScalarType(PrimitiveType.TINYINT);
        SMALLINT = new ScalarType(PrimitiveType.SMALLINT);
        INT = new ScalarType(PrimitiveType.INT);
        BIGINT = new ScalarType(PrimitiveType.BIGINT);
        LARGEINT = new ScalarType(PrimitiveType.LARGEINT);
        FLOAT = new ScalarType(PrimitiveType.FLOAT);
        DOUBLE = new ScalarType(PrimitiveType.DOUBLE);
        DATE = new ScalarType(PrimitiveType.DATE);
        DATETIME = new ScalarType(PrimitiveType.DATETIME);
        TIME = new ScalarType(PrimitiveType.TIME);
        STRING = new ScalarType(PrimitiveType.STRING);
        DECIMALV2 = DEFAULT_DECIMALV2 = ScalarType.createDecimalV2Type(9, 0);
        DEFAULT_VARCHAR = ScalarType.createVarcharType(-1);
        VARCHAR = ScalarType.createVarcharType(-1);
        HLL = ScalarType.createHllType();
        CHAR = ScalarType.createCharType(-1);
        BITMAP = new ScalarType(PrimitiveType.BITMAP);
        ALL = new ScalarType(PrimitiveType.ALL);
        Map = new MapType();
        integerTypes = Lists.newArrayList();
        integerTypes.add(TINYINT);
        integerTypes.add(SMALLINT);
        integerTypes.add(INT);
        integerTypes.add(BIGINT);
        integerTypes.add(LARGEINT);
        numericTypes = Lists.newArrayList();
        numericTypes.add(TINYINT);
        numericTypes.add(SMALLINT);
        numericTypes.add(INT);
        numericTypes.add(BIGINT);
        numericTypes.add(LARGEINT);
        numericTypes.add(FLOAT);
        numericTypes.add(DOUBLE);
        numericTypes.add(DECIMALV2);
        supportedTypes = Lists.newArrayList();
        supportedTypes.add(NULL);
        supportedTypes.add(BOOLEAN);
        supportedTypes.add(TINYINT);
        supportedTypes.add(SMALLINT);
        supportedTypes.add(INT);
        supportedTypes.add(BIGINT);
        supportedTypes.add(LARGEINT);
        supportedTypes.add(FLOAT);
        supportedTypes.add(DOUBLE);
        supportedTypes.add(VARCHAR);
        supportedTypes.add(HLL);
        supportedTypes.add(BITMAP);
        supportedTypes.add(CHAR);
        supportedTypes.add(DATE);
        supportedTypes.add(DATETIME);
        supportedTypes.add(DECIMALV2);
        supportedTypes.add(TIME);
        supportedTypes.add(STRING);
        compatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        strictCompatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        for (i = 0; i < PrimitiveType.values().length; ++i) {
            Type.compatibilityMatrix[i][i] = PrimitiveType.values()[i];
        }
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.TINYINT.ordinal()] = PrimitiveType.TINYINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.SMALLINT.ordinal()] = PrimitiveType.SMALLINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.INT.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.SMALLINT.ordinal()] = PrimitiveType.SMALLINT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.INT.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.INT.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.strictCompatibilityMatrix[Type.INT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.strictCompatibilityMatrix[Type.BIGINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.DATETIME;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.VARCHAR;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.STRING.ordinal()] = PrimitiveType.STRING;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.STRING.ordinal()] = PrimitiveType.STRING;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        for (i = 0; i < PrimitiveType.values().length - 2; ++i) {
            for (int j = i; j < PrimitiveType.values().length - 2; ++j) {
                PrimitiveType t1 = PrimitiveType.values()[i];
                PrimitiveType t2 = PrimitiveType.values()[j];
                if (t1 == PrimitiveType.INVALID_TYPE || t2 == PrimitiveType.INVALID_TYPE || t1 == PrimitiveType.NULL_TYPE || t2 == PrimitiveType.NULL_TYPE || t1 == PrimitiveType.ARRAY || t2 == PrimitiveType.ARRAY || t1 == PrimitiveType.DECIMALV2 || t2 == PrimitiveType.DECIMALV2 || t1 == PrimitiveType.TIME || t2 == PrimitiveType.TIME || t1 == PrimitiveType.ARRAY || t2 == PrimitiveType.ARRAY || t1 == PrimitiveType.MAP || t2 == PrimitiveType.MAP || t1 == PrimitiveType.STRUCT || t2 == PrimitiveType.STRUCT) continue;
                Preconditions.checkNotNull((Object)((Object)compatibilityMatrix[i][j]));
            }
        }
    }
}

